/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.wildfly.module.installer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

class JBossModule {
    private final Logger log = Logger.getLogger(this.getClass());
    private URL root;
    private String moduleId;
    private List<String> resources = new ArrayList<String>();

    private JBossModule() {
    }

    public String getModuleId() {
        return this.moduleId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JBossModule readFromURL(URL moduleZip) throws Exception {
        JBossModule m = new JBossModule();
        m.root = moduleZip;
        ZipInputStream zin = null;
        BufferedInputStream bin = null;
        boolean moduleXmlFound = false;
        try {
            bin = new BufferedInputStream(moduleZip.openStream());
            zin = new ZipInputStream(bin);
            ZipEntry ze = null;
            while ((ze = zin.getNextEntry()) != null) {
                if (!ze.getName().endsWith("main/module.xml")) continue;
                moduleXmlFound = true;
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(zin);
                m.readModuleXmlInfo(doc);
                break;
            }
        }
        finally {
            try {
                if (zin != null) {
                    zin.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (!moduleXmlFound) {
            throw new FileNotFoundException("module.xml was not found in " + moduleZip);
        }
        return m;
    }

    private void readModuleXmlInfo(Document doc) throws Exception {
        this.moduleId = doc.getDocumentElement().getAttribute("name");
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodeList = (NodeList)xPath.compile("//resources/resource-root").evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.resources.add(nodeList.item(i).getAttributes().getNamedItem("path").getTextContent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstallFrom(File modulesHome) throws Exception {
        this.log.info((Object)("Uninstalling module [" + this.root + "] from [" + modulesHome.getAbsolutePath() + "]"));
        ZipInputStream zin = null;
        try {
            zin = new ZipInputStream(this.root.openStream());
            ZipEntry ze = null;
            while ((ze = zin.getNextEntry()) != null) {
                String fileName = ze.getName();
                File newFile = new File(modulesHome + File.separator + fileName);
                if (ze.isDirectory()) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Deleting " + newFile.getAbsolutePath()));
                }
                FileUtils.deleteQuietly((File)newFile);
            }
        }
        finally {
            try {
                if (zin != null) {
                    zin.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> installTo(File modulesHome) throws Exception {
        ArrayList<File> installedFiles = new ArrayList<File>();
        ZipInputStream zin = null;
        this.log.info((Object)("Extracting module [" + this.root + "] to [" + modulesHome.getAbsolutePath() + "]"));
        try {
            zin = new ZipInputStream(this.root.openStream());
            ZipEntry ze = null;
            while ((ze = zin.getNextEntry()) != null) {
                String fileName = ze.getName();
                File newFile = new File(modulesHome + File.separator + fileName);
                if (ze.isDirectory()) continue;
                this.log.debug((Object)("Writing " + newFile.getAbsolutePath()));
                File parent = newFile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(newFile);
                IOUtils.copy((InputStream)zin, (OutputStream)fos);
                IOUtils.closeQuietly((OutputStream)fos);
                installedFiles.add(newFile);
            }
        }
        finally {
            try {
                if (zin != null) {
                    zin.close();
                }
            }
            catch (IOException iOException) {}
        }
        return installedFiles;
    }
}

