/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.wildfly.module.installer;

import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.hawkular.wildfly.module.installer.RegisterModuleConfiguration;
import org.hawkular.wildfly.module.installer.XmlConfigBuilder;
import org.hawkular.wildfly.module.installer.XmlEdit;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

class RegisterExtension {
    private final Logger log = Logger.getLogger(this.getClass());

    public void register(RegisterModuleConfiguration options) throws Exception {
        switch (options.getConfigType()) {
            case DOMAIN: {
                this.registerToDomain(options);
                break;
            }
            case HOST: {
                this.registerToHost(options);
                break;
            }
            case STANDALONE: {
                this.registerToStandalone(options);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown configuration type: " + (Object)((Object)options.getConfigType()));
            }
        }
        this.log.info((Object)("New serverConfig file written to [" + options.getTargetServerConfig().getAbsolutePath() + "]"));
    }

    private void assertNotRegistered(RegisterModuleConfiguration options, String extensionExpr) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = factory.newDocumentBuilder();
        Document srcDoc = dBuilder.parse(options.getSourceServerConfig());
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression expr = xpath.compile(extensionExpr);
        NodeList data = (NodeList)expr.evaluate(srcDoc, XPathConstants.NODESET);
        if (data != null && data.getLength() > 0) {
            throw new IllegalStateException("Extension [" + extensionExpr + "] is already installed. Aborting.");
        }
    }

    private void registerToStandalone(RegisterModuleConfiguration options) throws Exception {
        ArrayList<XmlEdit> inserts = new ArrayList<XmlEdit>();
        inserts.addAll(options.getXmlEdits());
        if (options.getModuleId() != null) {
            this.log.info((Object)("Register STANDALONE extension module=" + options.getModuleId()));
            this.assertNotRegistered(options, String.format("/server/extensions/extension[@module='%s']", options.getModuleId()));
            inserts.add(new XmlEdit("/server/extensions", "<extension module=\"" + options.getModuleId() + "\"/>"));
        }
        if (options.getSubsystem() != null) {
            inserts.add(new XmlEdit("/server/profile", options.getSubsystem()));
        }
        if (options.getSocketBindingGroups() != null && options.getSocketBinding() != null) {
            for (String group : options.getSocketBindingGroups()) {
                inserts.add(new XmlEdit("/server/socket-binding-group[@name='" + group + "']", options.getSocketBinding()).withAttribute("name"));
            }
        }
        new XmlConfigBuilder(options.getSourceServerConfig(), options.getTargetServerConfig()).edits(inserts).failNoMatch(options.isFailNoMatch()).build();
    }

    private void registerToHost(RegisterModuleConfiguration options) throws Exception {
        ArrayList<XmlEdit> inserts = new ArrayList<XmlEdit>();
        inserts.addAll(options.getXmlEdits());
        if (options.getModuleId() != null) {
            this.log.info((Object)("Register HOST extension module=" + options.getModuleId()));
            this.assertNotRegistered(options, String.format("/host/extensions/extension[@module='%s']", options.getModuleId()));
            inserts.add(new XmlEdit("/host/extensions", "<extension module=\"" + options.getModuleId() + "\"/>"));
        }
        if (options.getSubsystem() != null) {
            inserts.add(new XmlEdit("/host/profile", options.getSubsystem()));
        }
        if (options.getSocketBindingGroups() != null && options.getSocketBinding() != null) {
            for (String group : options.getSocketBindingGroups()) {
                inserts.add(new XmlEdit("/host", "<socket-binding-group default-interface=\"public\" name=\"" + group + "\"/>"));
                inserts.add(new XmlEdit("/host/socket-binding-group[@name='" + group + "']", options.getSocketBinding()).withAttribute("name"));
            }
        }
        new XmlConfigBuilder(options.getSourceServerConfig(), options.getTargetServerConfig()).edits(inserts).failNoMatch(options.isFailNoMatch()).build();
    }

    private void registerToDomain(RegisterModuleConfiguration options) throws Exception {
        ArrayList<XmlEdit> inserts = new ArrayList<XmlEdit>();
        inserts.addAll(options.getXmlEdits());
        if (options.getModuleId() != null) {
            this.log.info((Object)("Register DOMAIN extension module=" + options.getModuleId()));
            this.assertNotRegistered(options, String.format("/domain/extensions/extension[@module='%s']", options.getModuleId()));
            inserts.add(new XmlEdit("/domain/extensions", "<extension module=\"" + options.getModuleId() + "\"/>"));
        }
        if (options.getSubsystem() != null) {
            for (String profile : options.getProfiles()) {
                inserts.add(new XmlEdit("/domain/profiles/profile[@name='" + profile + "']", options.getSubsystem()));
            }
        }
        if (options.getSocketBindingGroups() != null && options.getSocketBinding() != null) {
            for (String group : options.getSocketBindingGroups()) {
                inserts.add(new XmlEdit("/domain/socket-binding-groups/socket-binding-group[@name='" + group + "']", options.getSocketBinding()).withAttribute("name"));
            }
        }
        new XmlConfigBuilder(options.getSourceServerConfig(), options.getTargetServerConfig()).edits(inserts).failNoMatch(options.isFailNoMatch()).build();
    }
}

