/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.wildfly.module.installer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.hawkular.wildfly.module.installer.NamespaceContextImpl;
import org.hawkular.wildfly.module.installer.XmlEdit;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class XmlConfigBuilder {
    private static final String PREFIX = "x";
    private static final String PREFIX_CONTENT = "ns";
    private static final Pattern NS_IN_XPATH = Pattern.compile("namespace-uri\\(\\)[^']+'([^']+)");
    private List<XmlEdit> edits;
    private boolean failNoMatch;
    private final File targetFile;
    private final File sourceFile;
    final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    final XPath xpath = XPathFactory.newInstance().newXPath();
    final NamespaceContextImpl namespaceContext = new NamespaceContextImpl();
    private final Logger log = Logger.getLogger(this.getClass());

    public XmlConfigBuilder(File sourceFile, File targetFile) {
        this.factory.setNamespaceAware(true);
        this.xpath.setNamespaceContext(this.namespaceContext);
        this.sourceFile = sourceFile;
        this.targetFile = targetFile;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    private void debug(String message) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)message);
        }
    }

    private void warning(String message) {
        this.log.warn((Object)message);
    }

    public void build() throws Exception {
        DocumentBuilder dBuilder = this.factory.newDocumentBuilder();
        Document srcDoc = dBuilder.parse(this.sourceFile);
        Collections.sort(this.getXmlEdits(), new Comparator<XmlEdit>(){

            @Override
            public int compare(XmlEdit o1, XmlEdit o2) {
                Integer o1Size = o1.getSelect().split("/").length;
                Integer o2Size = o2.getSelect().split("/").length;
                return o1Size.compareTo(o2Size);
            }
        });
        this.debug("Building [" + this.sourceFile + "] ");
        String namespace = XmlConfigBuilder.getNameSpace(srcDoc);
        if (namespace != null) {
            this.namespaceContext.mapping(PREFIX, namespace);
        }
        block2: for (XmlEdit xmlEdit : this.getXmlEdits()) {
            this.debug("Applying " + xmlEdit);
            String expression = xmlEdit.getSelect();
            if (namespace != null) {
                expression = XmlConfigBuilder.xpath2Namespaced(expression, PREFIX);
                this.debug("Expression " + expression);
            }
            XPathExpression expr = this.xpath.compile(expression);
            try {
                Element element;
                Node node;
                int i;
                NodeList nl = (NodeList)expr.evaluate(srcDoc, XPathConstants.NODESET);
                if (nl.getLength() == 0) {
                    if (this.failNoMatch) {
                        throw new Exception("Failed to update [" + this.targetFile.getAbsolutePath() + "] " + xmlEdit + " does not select any element");
                    }
                    this.warning(xmlEdit + " does not select any element");
                    continue;
                }
                this.debug("Expression evaluated to " + nl.getLength() + " nodes");
                if (xmlEdit.isAttributeContent()) {
                    String attribValue = xmlEdit.getXml();
                    for (i = 0; i < nl.getLength(); ++i) {
                        node = nl.item(i);
                        if (!(node instanceof Element)) continue;
                        element = (Element)node;
                        element.setAttribute(xmlEdit.getAttribute(), attribValue);
                        continue block2;
                    }
                    continue;
                }
                Document contentDoc = null;
                if (xmlEdit.getContent() != null) {
                    this.debug("Loading content XML from file " + xmlEdit.getContent());
                    contentDoc = dBuilder.parse(xmlEdit.getContent().openStream());
                } else {
                    this.debug("Loading content XML from string");
                    contentDoc = dBuilder.parse(new ByteArrayInputStream(xmlEdit.getXml().getBytes()));
                }
                for (i = 0; i < nl.getLength(); ++i) {
                    node = nl.item(i);
                    if (!(node instanceof Element)) continue;
                    element = (Element)node;
                    Node inserting = contentDoc.getDocumentElement().cloneNode(true);
                    srcDoc.adoptNode(inserting);
                    String recentNs = XmlConfigBuilder.findRecentNamespaceFromXpath(expression);
                    XPathExpression contentExpr = this.createContentRootExpression(contentDoc, recentNs, namespace, xmlEdit.getAttribute(), xmlEdit.isIgnoreAttributeValue());
                    NodeList existingNodes = (NodeList)contentExpr.evaluate(element, XPathConstants.NODESET);
                    if (existingNodes.getLength() > 0) {
                        element.replaceChild(inserting, existingNodes.item(existingNodes.getLength() - 1));
                    } else {
                        element.appendChild(inserting);
                    }
                    String contentNs = XmlConfigBuilder.getNameSpace(contentDoc);
                    recentNs = this.findRecentNamespace(srcDoc, inserting);
                    if (contentNs != null || recentNs == null) continue;
                    XmlConfigBuilder.renameNamespaceRecursive(srcDoc, inserting, recentNs);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.writeTargetDcoument(srcDoc);
    }

    public static String findRecentNamespaceFromXpath(String expression) {
        Matcher m = NS_IN_XPATH.matcher(expression);
        String ns = null;
        while (m.find()) {
            ns = m.group(1);
        }
        return ns;
    }

    private String findRecentNamespace(Document doc, Node node) {
        Node parent = null;
        while ((parent = node.getParentNode()) != null) {
            Element parentEl = (Element)parent;
            String ns = parentEl.getAttribute("xmlns");
            if (!ns.isEmpty()) {
                return ns;
            }
            if (parent.isSameNode(doc.getDocumentElement())) {
                return null;
            }
            if (parent.isEqualNode(node)) {
                return null;
            }
            node = parent;
        }
        return null;
    }

    private void writeTargetDcoument(Document doc) throws Exception {
        this.debug("Writing target file..");
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        XPathExpression xpathExp = this.xpath.compile("//text()[normalize-space(.) = '']");
        NodeList emptyTextNodes = (NodeList)xpathExp.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < emptyTextNodes.getLength(); ++i) {
            Node emptyTextNode = emptyTextNodes.item(i);
            emptyTextNode.getParentNode().removeChild(emptyTextNode);
        }
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(this.targetFile);
        transformer.transform(source, result);
    }

    public static String xpath2Namespaced(String expression, String prefix) {
        String[] components = expression.split("/");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < components.length; ++i) {
            String piece = components[i];
            if (piece.matches("^\\w+.*")) {
                piece = prefix + ":" + piece;
            }
            sb.append(piece + "/");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String element2Xpath(Element element, String prefix, String defaultPrefix) {
        return XmlConfigBuilder.element2Xpath(element, prefix, defaultPrefix, null);
    }

    public static String element2Xpath(Element element, String prefix, String defaultPrefix, String identityAttribute) {
        return XmlConfigBuilder.element2Xpath(element, prefix, defaultPrefix, identityAttribute, false);
    }

    public static String element2Xpath(Element element, String prefix, String defaultPrefix, String identityAttribute, boolean ignoreAttributeValue) {
        StringBuilder sb = new StringBuilder("/");
        String ns = element.getAttribute("xmlns");
        String pref = "";
        if (!ns.isEmpty()) {
            pref = prefix + ":";
        } else if (defaultPrefix != null) {
            pref = defaultPrefix + ":";
        }
        sb.append(pref + element.getLocalName());
        if (identityAttribute != null && !identityAttribute.isEmpty()) {
            if (ignoreAttributeValue) {
                sb.append("[@" + identityAttribute + "]");
            } else {
                sb.append("[@" + identityAttribute + "='" + element.getAttribute(identityAttribute) + "']");
            }
        } else {
            NamedNodeMap attributes = element.getAttributes();
            if (attributes.getLength() > 0) {
                StringBuilder sbAttributes = new StringBuilder();
                sbAttributes.append("[");
                int validAttributes = 0;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node node = attributes.item(i);
                    if ("xmlns".equals(node.getNodeName())) continue;
                    ++validAttributes;
                    sbAttributes.append("@" + node.getNodeName() + "='" + node.getNodeValue() + "' and ");
                }
                if (validAttributes > 0) {
                    sbAttributes.delete(sbAttributes.length() - 5, sbAttributes.length());
                    sbAttributes.append("]");
                    sb.append(sbAttributes.toString());
                }
            }
        }
        return sb.toString();
    }

    private XPathExpression createContentRootExpression(Document contentDoc, String contentNamespace, String rootNamespace, String identityAttribute, boolean ignoreAttributeValue) throws Exception {
        String expression = null;
        if (contentNamespace != null) {
            expression = XmlConfigBuilder.element2Xpath(contentDoc.getDocumentElement(), PREFIX_CONTENT, PREFIX_CONTENT, identityAttribute, ignoreAttributeValue);
            this.namespaceContext.mapping(PREFIX_CONTENT, contentNamespace);
        } else {
            String ns = XmlConfigBuilder.getNameSpace(contentDoc);
            if (ns != null) {
                expression = XmlConfigBuilder.element2Xpath(contentDoc.getDocumentElement(), PREFIX_CONTENT, null, identityAttribute, ignoreAttributeValue);
                this.namespaceContext.mapping(PREFIX_CONTENT, ns);
            } else {
                expression = XmlConfigBuilder.element2Xpath(contentDoc.getDocumentElement(), PREFIX_CONTENT, rootNamespace == null ? null : PREFIX, identityAttribute, ignoreAttributeValue);
            }
        }
        this.debug("Content expression " + expression);
        return this.xpath.compile(expression.substring(1));
    }

    public XmlConfigBuilder failNoMatch(boolean failNoMatch) throws Exception {
        this.failNoMatch = failNoMatch;
        return this;
    }

    public XmlConfigBuilder edit(XmlEdit insert) throws Exception {
        this.validateInsert(insert);
        this.getXmlEdits().add(insert);
        return this;
    }

    public XmlConfigBuilder edits(List<XmlEdit> inserts) throws Exception {
        for (XmlEdit i : inserts) {
            this.validateInsert(i);
            this.getXmlEdits().add(i);
        }
        return this;
    }

    private List<XmlEdit> getXmlEdits() {
        if (this.edits == null) {
            this.edits = new ArrayList<XmlEdit>();
        }
        return this.edits;
    }

    private void validateInsert(XmlEdit insert) throws IllegalArgumentException, XPathExpressionException {
        URL f = insert.getContent();
        if (f == null && insert.getXml() == null) {
            throw new IllegalArgumentException("Either content or xml must be specified");
        }
        String expression = insert.getSelect();
        if (expression.length() > 1 && expression.endsWith("/")) {
            insert.setSelect(expression.substring(0, expression.length() - 1));
        }
        try {
            this.xpath.compile(insert.getSelect());
        }
        catch (XPathExpressionException xee) {
            throw new XPathExpressionException(insert.getSelect() + " is not a valid xpath : " + xee.getMessage());
        }
    }

    private static String getNameSpace(Document doc) {
        if (doc == null) {
            return null;
        }
        String ns = doc.getDocumentElement().getAttribute("xmlns");
        if (ns.isEmpty()) {
            return null;
        }
        return ns;
    }

    private static void renameNamespaceRecursive(Document doc, Node node, String namespace) {
        if (node.getNodeType() == 1) {
            Element el = (Element)node;
            if (el.getAttribute("xmlns").isEmpty()) {
                doc.renameNode(node, namespace, node.getNodeName());
            } else {
                return;
            }
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            XmlConfigBuilder.renameNamespaceRecursive(doc, list.item(i), namespace);
        }
    }
}

