/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.elasticsearch;

import com.bazaarvoice.jolt.Shiftr;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.entity.NStringEntity;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.hawkular.alerts.actions.api.ActionMessage;
import org.hawkular.alerts.actions.api.ActionPluginListener;
import org.hawkular.alerts.actions.api.ActionPluginSender;
import org.hawkular.alerts.actions.api.ActionResponseMessage;
import org.hawkular.alerts.actions.api.MsgLogger;
import org.hawkular.alerts.actions.api.Plugin;
import org.hawkular.alerts.actions.api.Sender;
import org.hawkular.alerts.api.json.JsonUtil;
import org.hawkular.alerts.api.model.action.Action;

@Plugin(name="elasticsearch")
public class ElasticSearchPlugin
implements ActionPluginListener {
    public static final String PLUGIN_NAME = "elasticsearch";
    public static final String PROP_URL = "url";
    public static final String PROP_INDEX = "index";
    public static final String PROP_TYPE = "type";
    public static final String PROP_TRANSFORM = "transform";
    public static final String PROP_USER = "user";
    public static final String PROP_PASS = "pass";
    public static final String PROP_FORWARDED_FOR = "forwarded-for";
    public static final String PROP_PROXY_REMOTE_USER = "proxy-remote-user";
    public static final String PROP_TOKEN = "token";
    private static final String PROP_TIMESTAMP_PATTERN = "timestamp_pattern";
    private static final String ELASTICSEARCH_URL = "hawkular-alerts.elasticsearch-url";
    private static final String ELASTICSEARCH_URL_ENV = "ELASTICSEARCH_URL";
    private static final String ELASTICSEARCH_URL_DEFAULT = "http://localhost:9200";
    private static final String ELASTICSEARCH_INDEX = "hawkular-alerts.elasticsearch-index";
    private static final String ELASTICSEARCH_INDEX_ENV = "ELASTICSEARCH_INDEX";
    private static final String ELASTICSEARCH_INDEX_DEFAULT = "alerts";
    private static final String ELASTICSEARCH_TYPE = "hawkular-alerts.elasticsearch-type";
    private static final String ELASTICSEARCH_TYPE_ENV = "ELASTICSEARCH_TYPE";
    private static final String ELASTICSEARCH_TYPE_DEFAULT = "hawkular";
    private static final String ELASTICSEARCH_FORWARDED_FOR = "hawkular-alerts.elasticsearch-forwarded-for";
    private static final String ELASTICSEARCH_FORWARDED_FOR_ENV = "ELASTICSEARCH_FORWARDED_FOR";
    private static final String ELASTICSEARCH_FORWARDED_FOR_DEFAULT = "";
    private static final String ELASTICSEARCH_TOKEN = "hawkular-alerts.elasticsearch-token";
    private static final String ELASTICSEARCH_TOKEN_ENV = "ELASTICSEARCH_TOKEN";
    private static final String ELASTICSEARCH_TOKEN_DEFAULT = "";
    private static final String ELASTICSEARCH_PROXY_REMOTE_USER = "hawkular-alerts.elasticsearch-proxy-remote-user";
    private static final String ELASTICSEARCH_PROXY_REMOTE_USER_ENV = "ELASTICSEARCH_PROXY_REMOTE_USER";
    private static final String ELASTICSEARCH_PROXY_REMOTE_USER_DEFAULT = "";
    private static final Set<String> TIMESTAMP_FIELDS = new HashSet<String>();
    private static final ZoneId UTC;
    private static final String AUTHORIZATION = "Authorization";
    private static final String BEARER = "Bearer";
    private static final String X_FORWARDED = "X-Forwarded-For";
    private static final String X_PROXY_REMOTE_USER = "X-Proxy-Remote-User";
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    Map<String, String> defaultProperties = new HashMap<String, String>();
    @Sender
    ActionPluginSender sender;
    private static final String MESSAGE_PROCESSED = "PROCESSED";
    private static final String MESSAGE_FAILED = "FAILED";

    public ElasticSearchPlugin() {
        this.defaultProperties.put(PROP_URL, this.getProperty(ELASTICSEARCH_URL, ELASTICSEARCH_URL_ENV, ELASTICSEARCH_URL_DEFAULT));
        this.defaultProperties.put(PROP_INDEX, this.getProperty(ELASTICSEARCH_INDEX, ELASTICSEARCH_INDEX_ENV, ELASTICSEARCH_INDEX_DEFAULT));
        this.defaultProperties.put(PROP_TYPE, this.getProperty(ELASTICSEARCH_TYPE, ELASTICSEARCH_TYPE_ENV, ELASTICSEARCH_TYPE_DEFAULT));
        this.defaultProperties.put(PROP_FORWARDED_FOR, this.getProperty(ELASTICSEARCH_FORWARDED_FOR, ELASTICSEARCH_FORWARDED_FOR_ENV, ""));
        this.defaultProperties.put(PROP_TOKEN, this.getProperty(ELASTICSEARCH_TOKEN, ELASTICSEARCH_TOKEN_ENV, ""));
        this.defaultProperties.put(PROP_PROXY_REMOTE_USER, this.getProperty(ELASTICSEARCH_PROXY_REMOTE_USER, ELASTICSEARCH_PROXY_REMOTE_USER_ENV, ""));
        this.defaultProperties.put(PROP_TRANSFORM, "");
        this.defaultProperties.put(PROP_USER, "");
        this.defaultProperties.put(PROP_PASS, "");
        this.defaultProperties.put(PROP_TIMESTAMP_PATTERN, "");
    }

    private String getProperty(String property, String env, String defaultValue) {
        String value = System.getProperty(property);
        if (value != null) {
            return value;
        }
        value = System.getenv(env);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public Set<String> getProperties() {
        return this.defaultProperties.keySet();
    }

    public Map<String, String> getDefaultProperties() {
        return this.defaultProperties;
    }

    public void process(ActionMessage msg) throws Exception {
        if (msg == null || msg.getAction() == null) {
            this.msgLog.warnMessageReceivedWithoutPayload(PLUGIN_NAME);
        }
        try {
            this.writeAlert(msg.getAction());
            this.msgLog.infoActionReceived(PLUGIN_NAME, msg.toString());
            Action successAction = msg.getAction();
            successAction.setResult(MESSAGE_PROCESSED);
            this.sendResult(successAction);
        }
        catch (Exception e) {
            this.msgLog.errorCannotProcessMessage(PLUGIN_NAME, e.getMessage());
            Action failedAction = msg.getAction();
            failedAction.setResult(MESSAGE_FAILED);
            this.sendResult(failedAction);
        }
    }

    protected String transform(Action a) {
        String spec = (String)a.getProperties().get(PROP_TRANSFORM);
        if (spec == null || spec.isEmpty()) {
            return JsonUtil.toJson((Object)a.getEvent());
        }
        try {
            Shiftr transformer = new Shiftr(JsonUtil.fromJson((String)spec, Map.class));
            Map eventMap = JsonUtil.getMap((Object)a.getEvent());
            String timestampPattern = (String)a.getProperties().get(PROP_TIMESTAMP_PATTERN);
            if (!this.isEmpty(timestampPattern)) {
                this.transformTimestamp(timestampPattern, eventMap);
            }
            return JsonUtil.toJson((Object)transformer.transform((Object)eventMap));
        }
        catch (Exception e) {
            this.msgLog.warnf("Plugin elasticsearch can not apply spec [%s]", (Object)spec);
            return JsonUtil.toJson((Object)a.getEvent());
        }
    }

    private void transformTimestamp(String pattern, Object input) {
        if (input == null) {
            return;
        }
        if (input instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)input;
            if (entry.getValue() instanceof Map || entry.getValue() instanceof List) {
                this.transformTimestamp(pattern, entry.getValue());
            } else if (TIMESTAMP_FIELDS.contains(entry.getKey())) {
                try {
                    Long timestamp = (Long)entry.getValue();
                    entry.setValue(DateTimeFormatter.ofPattern(pattern).format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), UTC)));
                }
                catch (Exception e2) {
                    this.msgLog.warnf("Cannot parse %s timestamp", entry.getKey());
                }
            }
        } else if (input instanceof Map) {
            Map map = (Map)input;
            map.entrySet().stream().forEach(e -> this.transformTimestamp(pattern, e));
        } else if (input instanceof List) {
            List list = (List)input;
            list.stream().forEach(e -> this.transformTimestamp(pattern, e));
        }
    }

    protected void writeAlert(Action a) throws Exception {
        String url = (String)a.getProperties().get(PROP_URL);
        String index = (String)a.getProperties().get(PROP_INDEX);
        String type = (String)a.getProperties().get(PROP_TYPE);
        String[] urls = url.split(",");
        HttpHost[] hosts = new HttpHost[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            hosts[i] = HttpHost.create((String)urls[0]);
        }
        RestClient client = RestClient.builder((HttpHost[])hosts).setHttpClientConfigCallback(httpClientBuilder -> {
            httpClientBuilder.useSystemProperties();
            CredentialsProvider credentialsProvider = this.checkBasicCredentials(a);
            if (credentialsProvider != null) {
                httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
            }
            return httpClientBuilder;
        }).build();
        NStringEntity document = new NStringEntity(this.transform(a), ContentType.APPLICATION_JSON);
        String endpoint = "/" + index + "/" + type;
        Header[] headers = this.checkHeaders(a);
        Response response = headers == null ? client.performRequest("POST", endpoint, Collections.EMPTY_MAP, (HttpEntity)document, new Header[0]) : client.performRequest("POST", endpoint, Collections.EMPTY_MAP, (HttpEntity)document, headers);
        this.msgLog.debugf(response.toString(), new Object[0]);
        client.close();
    }

    private CredentialsProvider checkBasicCredentials(Action a) {
        String user = (String)a.getProperties().get(PROP_USER);
        String password = (String)a.getProperties().get(PROP_PASS);
        if (!this.isEmpty(user)) {
            if (!this.isEmpty(password)) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(user, password));
                return credentialsProvider;
            }
            this.msgLog.warnf("User [%s] without password ", (Object)user);
        }
        return null;
    }

    private Header[] checkHeaders(Action a) {
        Header[] headers = null;
        int nHeaders = 0;
        String token = (String)a.getProperties().get(PROP_TOKEN);
        BasicHeader bearer = null;
        if (!this.isEmpty(token)) {
            bearer = new BasicHeader(AUTHORIZATION, "Bearer " + token);
            ++nHeaders;
        }
        String forwarded = (String)a.getProperties().get(PROP_FORWARDED_FOR);
        BasicHeader xforwarded = null;
        if (!this.isEmpty(forwarded)) {
            xforwarded = new BasicHeader(X_FORWARDED, forwarded);
            ++nHeaders;
        }
        String proxyRemoteUser = (String)a.getProperties().get(PROP_PROXY_REMOTE_USER);
        BasicHeader xProxyRemoteUser = null;
        if (!this.isEmpty(proxyRemoteUser)) {
            xProxyRemoteUser = new BasicHeader(X_PROXY_REMOTE_USER, proxyRemoteUser);
            ++nHeaders;
        }
        if (nHeaders > 0) {
            headers = new Header[nHeaders];
            int i = 0;
            if (bearer != null) {
                headers[i] = bearer;
                ++i;
            }
            if (xforwarded != null) {
                headers[i] = xforwarded;
                ++i;
            }
            if (xProxyRemoteUser != null) {
                headers[i] = xProxyRemoteUser;
            }
        }
        return headers;
    }

    private void sendResult(Action action) {
        if (this.sender == null) {
            throw new IllegalStateException("ActionPluginSender is not present in the plugin");
        }
        if (action == null) {
            throw new IllegalStateException("Action to update result must be not null");
        }
        ActionResponseMessage newMessage = this.sender.createMessage(ActionResponseMessage.Operation.RESULT);
        newMessage.getPayload().put("action", JsonUtil.toJson((Object)action));
        try {
            this.sender.send(newMessage);
        }
        catch (Exception e) {
            this.msgLog.error((Object)"Error sending ActionResponseMessage", (Throwable)e);
        }
    }

    private boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    static {
        TIMESTAMP_FIELDS.add("ctime");
        TIMESTAMP_FIELDS.add("stime");
        TIMESTAMP_FIELDS.add("evalTimestamp");
        TIMESTAMP_FIELDS.add("dataTimestamp");
        UTC = ZoneId.of("UTC");
    }
}

