/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.standalone;

import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hawkular.alerts.actions.api.ActionPluginListener;
import org.hawkular.alerts.actions.api.ActionPluginSender;
import org.hawkular.alerts.actions.api.Global;
import org.hawkular.alerts.actions.api.Plugin;
import org.hawkular.alerts.actions.api.Sender;
import org.hawkular.alerts.actions.standalone.MsgLogger;
import org.hawkular.alerts.actions.standalone.ServiceNames;
import org.hawkular.alerts.actions.standalone.StandaloneActionPluginSender;
import org.hawkular.alerts.api.services.ActionsService;
import org.jboss.vfs.VirtualFile;

public class ActionPlugins {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private ActionsService actions;
    private static ActionPlugins instance;
    private Map<String, ActionPluginListener> plugins;
    private Set<String> globals;
    private Map<String, ActionPluginSender> senders;

    public static synchronized Map<String, ActionPluginListener> getPlugins() {
        if (instance == null) {
            instance = new ActionPlugins();
        }
        return Collections.unmodifiableMap(ActionPlugins.instance.plugins);
    }

    public static synchronized Set<String> getGlobals() {
        if (instance == null) {
            instance = new ActionPlugins();
        }
        return Collections.unmodifiableSet(ActionPlugins.instance.globals);
    }

    public static synchronized Map<String, ActionPluginSender> getSenders() {
        if (instance == null) {
            instance = new ActionPlugins();
        }
        return Collections.unmodifiableMap(ActionPlugins.instance.senders);
    }

    private ActionPlugins() {
        try {
            this.plugins = new HashMap<String, ActionPluginListener>();
            this.globals = new HashSet<String>();
            this.senders = new HashMap<String, ActionPluginSender>();
            this.init();
            List<URL> webInfUrls = this.getWebInfUrls();
            for (URL webInfUrl : webInfUrls) {
                List<Class> pluginClasses = this.findAnnotationInJar(webInfUrl, Plugin.class);
                for (Class pluginClass : pluginClasses) {
                    Plugin actionPlugin = pluginClass.getDeclaredAnnotation(Plugin.class);
                    if (!(actionPlugin instanceof Plugin)) continue;
                    String name = actionPlugin.name();
                    Object newInstance = pluginClass.newInstance();
                    if (newInstance instanceof ActionPluginListener) {
                        ActionPluginListener pluginInstance = (ActionPluginListener)newInstance;
                        this.injectActionPluginSender(name, pluginInstance);
                        this.plugins.put(name, pluginInstance);
                        if (!pluginClass.isAnnotationPresent(Global.class)) continue;
                        this.globals.add(name);
                        continue;
                    }
                    throw new IllegalStateException("Plugin [" + name + "] is not instance of ActionPluginListener");
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private List<URL> getWebInfUrls() throws Exception {
        Enumeration<URL> allUrls = Thread.currentThread().getContextClassLoader().getResources("");
        ArrayList<URL> webInfUrls = new ArrayList<URL>();
        while (allUrls != null && allUrls.hasMoreElements()) {
            int indexSuffix;
            URL url = allUrls.nextElement();
            String sUrl = url.toExternalForm();
            int indexPrefix = sUrl.indexOf("hawkular-alerts-actions-");
            if (indexPrefix <= 0 || (indexSuffix = sUrl.indexOf("-plugin", indexPrefix)) <= 0) continue;
            this.msgLog.debugf("Scanning %s", url);
            webInfUrls.add(url);
        }
        return webInfUrls;
    }

    private List<Class> findAnnotationInJar(URL url, Class annotation) throws Exception {
        if (url == null || annotation == null) {
            throw new IllegalArgumentException("url or annotation must be not null");
        }
        ArrayList<Class> plugins = new ArrayList<Class>();
        URLConnection conn = url.openConnection();
        Object content = conn.getContent();
        if (content instanceof VirtualFile) {
            VirtualFile root = (VirtualFile)content;
            List children = root.getChildrenRecursively();
            for (VirtualFile vf : children) {
                String vfName = vf.toURI().toString();
                this.msgLog.debugf("Searching %s", vfName);
                if (!vfName.endsWith(".class")) continue;
                int startName = vfName.indexOf(".jar/") + 5;
                int stopName = vfName.indexOf(".class");
                String className = vfName.substring(startName, stopName).replace("/", ".");
                this.msgLog.debugf("Loading %s", className);
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                if (!clazz.isAnnotationPresent(annotation)) continue;
                plugins.add(clazz);
            }
        }
        return plugins;
    }

    private void injectActionPluginSender(String actionPlugin, ActionPluginListener pluginInstance) throws Exception {
        if (pluginInstance == null) {
            throw new IllegalArgumentException("pluginInstance must be not null");
        }
        Field[] fields = pluginInstance.getClass().getDeclaredFields();
        Field sender = null;
        for (Field field : fields) {
            if (!field.isAnnotationPresent(Sender.class) || !field.getType().isAssignableFrom(ActionPluginSender.class)) continue;
            sender = field;
            break;
        }
        if (sender != null) {
            StandaloneActionPluginSender standaloneSender = new StandaloneActionPluginSender(this.actions);
            sender.setAccessible(true);
            sender.set(pluginInstance, standaloneSender);
            this.senders.put(actionPlugin, standaloneSender);
        }
    }

    private void init() {
        if (this.actions == null) {
            try {
                InitialContext ctx = new InitialContext();
                this.actions = (ActionsService)ctx.lookup(ServiceNames.getServiceName(ServiceNames.Service.ACTIONS_SERVICE));
            }
            catch (NamingException e) {
                this.msgLog.error("Cannot access to JNDI context", e);
            }
        }
    }
}

