/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.hawkular.alerts.actions.tests.CommonData;
import org.hawkular.alerts.api.model.condition.AvailabilityCondition;
import org.hawkular.alerts.api.model.condition.AvailabilityConditionEval;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.data.AvailabilityType;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.model.event.Alert;
import org.hawkular.alerts.api.model.trigger.Mode;
import org.hawkular.alerts.api.model.trigger.Trigger;

public class UrlAvailabilityData
extends CommonData {
    public static Trigger trigger;
    public static AvailabilityCondition firingCondition;
    public static AvailabilityCondition autoResolveCondition;
    public static Dampening firingDampening;

    public static Alert getOpenAlert() {
        ArrayList satisfyingEvals = new ArrayList();
        Data avBadData1 = Data.forAvailability((String)firingCondition.getDataId(), (long)System.currentTimeMillis(), (AvailabilityType)AvailabilityType.DOWN);
        AvailabilityConditionEval eval1 = new AvailabilityConditionEval(firingCondition, avBadData1);
        HashSet<AvailabilityConditionEval> evalSet1 = new HashSet<AvailabilityConditionEval>();
        evalSet1.add(eval1);
        satisfyingEvals.add(evalSet1);
        Data avBadData2 = Data.forAvailability((String)firingCondition.getDataId(), (long)(System.currentTimeMillis() + 5000L), (AvailabilityType)AvailabilityType.DOWN);
        AvailabilityConditionEval eval2 = new AvailabilityConditionEval(firingCondition, avBadData2);
        HashSet<AvailabilityConditionEval> evalSet2 = new HashSet<AvailabilityConditionEval>();
        evalSet2.add(eval2);
        satisfyingEvals.add(evalSet2);
        Alert openAlert = new Alert(trigger.getTenantId(), trigger, firingDampening, satisfyingEvals);
        return openAlert;
    }

    public static Alert resolveAlert(Alert unresolvedAlert) {
        ArrayList resolvedEvals = new ArrayList();
        Data avGoodData = Data.forAvailability((String)autoResolveCondition.getDataId(), (long)(System.currentTimeMillis() + 20000L), (AvailabilityType)AvailabilityType.UP);
        AvailabilityConditionEval eval1 = new AvailabilityConditionEval(autoResolveCondition, avGoodData);
        HashSet<AvailabilityConditionEval> evalSet1 = new HashSet<AvailabilityConditionEval>();
        evalSet1.add(eval1);
        resolvedEvals.add(evalSet1);
        unresolvedAlert.setResolvedEvalSets(resolvedEvals);
        unresolvedAlert.setStatus(Alert.Status.RESOLVED);
        unresolvedAlert.setResolvedBy("resolve-user");
        unresolvedAlert.addNote("resolve-user", "These resolved notes are automatically generated");
        unresolvedAlert.setResolvedTime(System.currentTimeMillis());
        return unresolvedAlert;
    }

    static {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("resourceType", "URL");
        context.put("resourceName", "http://www.jboss.org");
        String triggerId = "jboss-url-availability-trigger";
        String triggerDescription = "Data for http://www.jboss.org";
        String dataId = "jboss-url-availability-data-id";
        trigger = new Trigger("test-tenant", triggerId, triggerDescription, context);
        firingCondition = new AvailabilityCondition(trigger.getId(), Mode.FIRING, dataId, AvailabilityCondition.Operator.NOT_UP);
        firingCondition.setTenantId("test-tenant");
        firingCondition.getContext().put("description", "Availability");
        autoResolveCondition = new AvailabilityCondition(trigger.getId(), Mode.AUTORESOLVE, dataId, AvailabilityCondition.Operator.UP);
        autoResolveCondition.setTenantId("test-tenant");
        autoResolveCondition.getContext().put("description", "Availability");
        firingDampening = Dampening.forStrictTime((String)trigger.getId(), (Mode)Mode.FIRING, (long)10000L);
        firingDampening.setTenantId("test-tenant");
    }
}

