/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.tests;

import java.util.List;
import java.util.Set;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.event.Alert;

public abstract class CommonData {
    public static final String TENANT = "test-tenant";
    public static final String ACK_BY = "ack-user";
    public static final String ACK_NOTES = "These ack notes are automatically generated";
    public static final String RESOLVED_BY = "resolve-user";
    public static final String RESOLVED_NOTES = "These resolved notes are automatically generated";

    public static Alert ackAlert(Alert openAlert) {
        if (null == openAlert) {
            return null;
        }
        openAlert.addLifecycle(Alert.Status.ACKNOWLEDGED, ACK_BY, System.currentTimeMillis());
        openAlert.setStatus(Alert.Status.ACKNOWLEDGED);
        openAlert.addNote(ACK_BY, ACK_NOTES);
        return openAlert;
    }

    public static Alert resolveAlert(Alert unresolvedAlert, List<Set<ConditionEval>> resolvedEvals) {
        if (null == unresolvedAlert) {
            return null;
        }
        unresolvedAlert.setResolvedEvalSets(resolvedEvals);
        unresolvedAlert.addLifecycle(Alert.Status.RESOLVED, RESOLVED_BY, System.currentTimeMillis());
        unresolvedAlert.addNote(RESOLVED_BY, RESOLVED_NOTES);
        return unresolvedAlert;
    }
}

