/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.webhook;

import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hawkular.alerts.actions.api.ActionMessage;
import org.hawkular.alerts.actions.api.ActionPluginListener;
import org.hawkular.alerts.actions.api.ActionPluginSender;
import org.hawkular.alerts.actions.api.ActionResponseMessage;
import org.hawkular.alerts.actions.api.MsgLogger;
import org.hawkular.alerts.actions.api.Plugin;
import org.hawkular.alerts.actions.api.Sender;
import org.hawkular.alerts.api.json.JsonUtil;
import org.hawkular.alerts.api.model.action.Action;
import org.jboss.logging.Logger;

@Plugin(name="webhook")
public class WebHookPlugin
implements ActionPluginListener {
    private static final String DEFAULT_URL = "http://localhost:8080/hawkular/actions/webhook/ping";
    private static final String DEFAULT_METHOD = "POST";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_JSON = "application/json";
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private static final Logger log = Logger.getLogger(WebHookPlugin.class);
    Map<String, String> defaultProperties = new HashMap<String, String>();
    @Sender
    ActionPluginSender sender;
    private static final String MESSAGE_PROCESSED = "PROCESSED";
    private static final String MESSAGE_FAILED = "FAILED";

    public WebHookPlugin() {
        this.defaultProperties.put("url", DEFAULT_URL);
        this.defaultProperties.put("method", DEFAULT_METHOD);
    }

    public Set<String> getProperties() {
        return this.defaultProperties.keySet();
    }

    public Map<String, String> getDefaultProperties() {
        return this.defaultProperties;
    }

    public void process(ActionMessage msg) throws Exception {
        this.msgLog.infoActionReceived("webhook", msg.toString());
        Action receivedAction = msg.getAction();
        try {
            this.invokeWebhook(receivedAction);
            receivedAction.setResult(MESSAGE_PROCESSED);
        }
        catch (Exception e) {
            this.msgLog.errorCannotProcessMessage("webhook", e.getMessage());
            receivedAction.setResult(MESSAGE_FAILED);
        }
        this.sendResult(receivedAction);
    }

    public void invokeWebhook(Action action) throws Exception {
        if (action.getProperties() == null) {
            throw new IllegalArgumentException("Received action without properties");
        }
        String url = this.isEmpty((String)action.getProperties().get("url")) ? DEFAULT_URL : (String)action.getProperties().get("url");
        String method = this.isEmpty((String)action.getProperties().get("method")) ? DEFAULT_METHOD : (String)action.getProperties().get("method");
        String jsonEvent = JsonUtil.toJson((Object)action.getEvent());
        URL webHookUrl = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)webHookUrl.openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod(method);
        conn.setRequestProperty(CONTENT_TYPE, APPLICATION_JSON);
        OutputStream os = conn.getOutputStream();
        os.write(jsonEvent.getBytes());
        os.flush();
        os.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Webhook for " + url + " . Request code: " + conn.getResponseCode()));
        }
        conn.disconnect();
    }

    private void sendResult(Action action) {
        if (this.sender == null) {
            throw new IllegalStateException("ActionPluginSender is not present in the plugin");
        }
        if (action == null) {
            throw new IllegalStateException("Action to update result must be not null");
        }
        ActionResponseMessage newMessage = this.sender.createMessage(ActionResponseMessage.Operation.RESULT);
        newMessage.getPayload().put("action", JsonUtil.toJson((Object)action));
        try {
            this.sender.send(newMessage);
        }
        catch (Exception e) {
            this.msgLog.error((Object)"Error sending ActionResponseMessage", (Throwable)e);
        }
    }

    private boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }
}

