/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.webhook;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hawkular.alerts.actions.api.ActionMessage;
import org.hawkular.alerts.actions.api.ActionPluginListener;
import org.hawkular.alerts.actions.api.Global;
import org.hawkular.alerts.actions.api.MsgLogger;
import org.hawkular.alerts.actions.api.Plugin;
import org.hawkular.alerts.actions.webhook.WebHooks;
import org.hawkular.alerts.api.json.JsonUtil;
import org.hawkular.alerts.api.model.action.Action;
import org.hawkular.alerts.api.model.event.Alert;
import org.jboss.logging.Logger;

@Global
@Plugin(name="webhook")
public class WebHookPlugin
implements ActionPluginListener {
    public static final String FILE_PROPERTY = "org.hawkular.alerts.actions.webhooks.file";
    private static final String TRIGGER_ID = "triggerId";
    private static final String ALERT_ID = "alertId";
    private static final String STATUS = "status";
    private static final String SEVERITY = "severity";
    private static final String POST = "POST";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_JSON = "application/json";
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private static final Logger log = Logger.getLogger(WebHookPlugin.class);
    Map<String, String> defaultProperties = new HashMap();

    public WebHookPlugin() {
        String webHooksFile = System.getProperty(FILE_PROPERTY);
        if (webHooksFile != null) {
            WebHooks.setFile((String)webHooksFile);
            File f = new File(webHooksFile);
            if (!f.exists()) {
                log.debug((Object)("WebHooks file " + webHooksFile + " doesn't exist"));
            } else {
                try {
                    WebHooks.loadFile();
                    log.debug((Object)"WebHooks file loaded.");
                }
                catch (IOException e) {
                    this.msgLog.warn((Object)e.toString(), (Throwable)e);
                }
            }
        }
        if (WebHooks.isSupportsFile()) {
            this.defaultProperties.put("usingWebHooksFile", "true");
            this.defaultProperties.put("webHooksFile", WebHooks.getFile());
        } else {
            this.defaultProperties.put("usingWebHooksFile", "false");
        }
    }

    public Set<String> getProperties() {
        return this.defaultProperties.keySet();
    }

    public Map<String, String> getDefaultProperties() {
        return this.defaultProperties;
    }

    public void process(ActionMessage msg) throws Exception {
        this.msgLog.infoActionReceived("webhook", msg.toString());
        Action receivedAction = msg.getAction();
        String tenantId = receivedAction.getTenantId();
        List webhooks = WebHooks.getWebHooks((String)tenantId);
        if (webhooks == null) {
            log.debug((Object)"Webhook received a message but there are not webhooks configured");
            return;
        }
        for (Map webhook : webhooks) {
            if (!this.checkFilter(receivedAction, (String)webhook.get("filter"))) continue;
            try {
                this.invokeWebhook(receivedAction, (String)webhook.get("url"));
            }
            catch (IOException e) {
                this.msgLog.errorCannotProcessMessage("webhook", "Webhook with url " + (String)webhook.get("url") + " cannot be invoked");
            }
        }
    }

    public boolean checkFilter(Action action, String filter) {
        String[] filters;
        if (action == null || action.getEvent() == null || filter == null || filter.isEmpty()) {
            return true;
        }
        if (!(action.getEvent() instanceof Alert)) {
            return true;
        }
        Alert alert = (Alert)action.getEvent();
        for (String f : filters = filter.split(",")) {
            String[] filterDetails = f.split("=");
            if (filterDetails.length != 2) continue;
            String key = filterDetails[0];
            String value = filterDetails[1];
            if (!TRIGGER_ID.equals(key) && !ALERT_ID.equals(key) && !SEVERITY.equals(key) && !STATUS.equals(key)) continue;
            if (TRIGGER_ID.equals(key) && !alert.getTriggerId().equals(value)) {
                return false;
            }
            if (ALERT_ID.equals(key) && !alert.getAlertId().equals(value)) {
                return false;
            }
            if (STATUS.equals(key) && !alert.getStatus().name().equals(value)) {
                return false;
            }
            if (!SEVERITY.equals(key) || alert.getSeverity().name().equals(value)) continue;
            return false;
        }
        return true;
    }

    public void invokeWebhook(Action action, String url) throws IOException {
        String jsonAction = JsonUtil.toJson((Object)action);
        URL webHookUrl = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)webHookUrl.openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod(POST);
        conn.setRequestProperty(CONTENT_TYPE, APPLICATION_JSON);
        OutputStream os = conn.getOutputStream();
        os.write(jsonAction.getBytes());
        os.flush();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Webhook for " + url + " . Request code: " + conn.getResponseCode()));
        }
        conn.disconnect();
    }
}

