/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.ejb.EJB;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.jboss.logging.Logger;

@Path(value="/plugins")
@Api(value="/plugins", description="Query operations for action plugins")
public class ActionPluginHandler {
    private final Logger log = Logger.getLogger(ActionPluginHandler.class);
    @EJB
    DefinitionsService definitions;

    public ActionPluginHandler() {
        this.log.debugf("Creating instance.", new Object[0]);
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all action plugins", responseContainer="Collection<String>", response=String.class, notes="Pagination is not yet implemented")
    public void findAllActionPlugins(@Suspended AsyncResponse response) {
        try {
            Collection actionPlugins = this.definitions.getActionPlugins();
            if (actionPlugins == null || actionPlugins.isEmpty()) {
                this.log.debugf("GET - findAllActionPlugins - Empty", new Object[0]);
                response.resume((Object)Response.status((Response.Status)Response.Status.NO_CONTENT).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                this.log.debugf("GET - findAllActionPlugins - %s action plugins ", (Object)actionPlugins);
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)actionPlugins).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="/{actionPlugin}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find list of properties to fill for a specific action plugin", responseContainer="Collection<String>", response=String.class, notes="Each action plugin can have a different and variable number of properties. This method should be invoked before of a creation of a new action.")
    public void getActionPlugin(@Suspended AsyncResponse response, @ApiParam(value="Action plugin to query", required=true) @PathParam(value="actionPlugin") String actionPlugin) {
        try {
            Set actionPluginProps = this.definitions.getActionPlugin(actionPlugin);
            if (actionPluginProps == null || actionPluginProps.isEmpty()) {
                this.log.debugf("GET - getActionPlugin - Empty", new Object[0]);
                response.resume((Object)Response.status((Response.Status)Response.Status.NO_CONTENT).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                this.log.debugf("GET - getActionPlugin - actionPlugin: %s - properties: %s ", (Object)actionPlugin, (Object)actionPluginProps);
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)actionPluginProps).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }
}

