/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.EJB;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.hawkular.alerts.api.model.action.Action;
import org.hawkular.alerts.api.services.ActionsService;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.jboss.logging.Logger;

@Path(value="/actions")
@Api(value="/actions", description="Action Handling")
public class ActionsHandler {
    private final Logger log = Logger.getLogger(ActionsHandler.class);
    @EJB
    DefinitionsService definitions;
    @EJB
    ActionsService actions;

    public ActionsHandler() {
        this.log.debugf("Creating instance.", new Object[0]);
    }

    @POST
    @Path(value="/send")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Send an action to the ActionService.", notes="ActionService should not be invoked directly. This method is for demo/poc purposes.")
    public void send(@Suspended AsyncResponse response, Action action) {
        this.actions.send(action);
        response.resume((Object)Response.status((Response.Status)Response.Status.OK).build());
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all action ids", responseContainer="Collection", response=String.class, notes="Pagination is not yet implemented")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Actions Found"), @ApiResponse(code=204, message="Success, No Actions Found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void findAllActions(@Suspended AsyncResponse response) {
        try {
            Collection actions = this.definitions.getAllActions();
            if (actions == null || actions.isEmpty()) {
                this.log.debugf("GET - findAllActions - Empty", new Object[0]);
                response.resume((Object)Response.status((Response.Status)Response.Status.NO_CONTENT).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                this.log.debugf("GET - findAllActions - %s actions ", (Object)actions);
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)actions).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="/plugin/{actionPlugin}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all action ids of an specific action plugin", responseContainer="Collection", response=String.class, notes="Pagination is not yet implemented")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Actions Found"), @ApiResponse(code=204, message="Success, No Actions Found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void findAllActionsByPlugin(@Suspended AsyncResponse response, @ApiParam(value="Action plugin to filter query for action ids", required=true) @PathParam(value="actionPlugin") String actionPlugin) {
        try {
            Collection actions = this.definitions.getActions(actionPlugin);
            if (actions == null || actions.isEmpty()) {
                this.log.debugf("GET - findAllActions - Empty", new Object[0]);
                response.resume((Object)Response.status((Response.Status)Response.Status.NO_CONTENT).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                this.log.debugf("GET - findAllActions - %s notifiers ", (Object)actions);
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)actions).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new action", responseContainer="Map<String, String>", response=String.class, notes="Action properties are variable and depends on the action plugin. A user needs to request previously ActionPlugin API to get the list of properties to fill for a specific type. All actions should have actionId and actionPlugin as mandatory properties")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Action Created"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void createAction(@Suspended AsyncResponse response, @ApiParam(value="Action properties. Properties depend of specific ActionPlugin.", name="actionProperties", required=true) Map<String, String> actionProperties) {
        try {
            if (actionProperties != null && !actionProperties.isEmpty() && actionProperties.containsKey("actionId") && this.definitions.getAction(actionProperties.get("actionId")) == null) {
                String actionId = actionProperties.get("actionId");
                this.log.debugf("POST - createAction - actionId %s - properties %s ", (Object)actionId, actionProperties);
                this.definitions.addAction(actionId, actionProperties);
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity(actionProperties).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                this.log.debugf("POST - createAction - ID not valid or existing condition", new Object[0]);
                HashMap<String, String> errors = new HashMap<String, String>();
                errors.put("errorMsg", "Existing action or invalid actionId");
                response.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="/{actionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get an existing action", responseContainer="Map<String, String>", response=String.class, notes="Action is represented as a map of properties.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Action Found"), @ApiResponse(code=404, message="No Action Found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void getAction(@Suspended AsyncResponse response, @ApiParam(value="Action id to be retrieved", required=true) @PathParam(value="actionId") String actionId) {
        try {
            Map actionProps = this.definitions.getAction(actionId);
            if (actionProps == null || actionProps.isEmpty()) {
                this.log.debugf("GET - getAction - Empty", new Object[0]);
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                this.log.debugf("GET - getAction - actionId: %s - properties: %s ", (Object)actionId, (Object)actionProps);
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)actionProps).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @PUT
    @Path(value="/{actionId}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update an existing action", notes="Action properties are variable and depends on the action plugin. A user needs to request previously ActionPlugin API to get the list of properties to fill for a specific type. All actions should have actionId and actionPlugin as mandatory properties")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Action Updated"), @ApiResponse(code=404, message="No Action Found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void updateAction(@Suspended AsyncResponse response, @ApiParam(value="action id to be updated", required=true) @PathParam(value="actionId") String actionId, @ApiParam(value="Action properties. Properties depend of specific ActionPlugin.", name="actionProperties", required=true) Map<String, String> actionProperties) {
        try {
            if (actionId != null && !actionId.isEmpty() && actionProperties != null && !actionProperties.isEmpty() && actionProperties.containsKey("actionId") && actionProperties.get("actionId").equals(actionId) && this.definitions.getAction(actionId) != null) {
                this.log.debugf("POST - updateAction - actionId %s - properties: %s ", (Object)actionId, actionProperties);
                this.definitions.updateAction(actionId, actionProperties);
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity(actionProperties).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                this.log.debugf("PUT - updateAction - actionId: %s not found or invalid. ", (Object)actionId);
                HashMap<String, String> errors = new HashMap<String, String>();
                errors.put("errorMsg", "actionId  " + actionId + " not found or invalid Id");
                errors.put("errorMsg", "Existing action or invalid Id");
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @DELETE
    @Path(value="/{actionId}")
    @ApiOperation(value="Delete an existing action")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Action Deleted"), @ApiResponse(code=404, message="No Action Found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void deleteAction(@Suspended AsyncResponse response, @ApiParam(value="Action id to be deleted", required=true) @PathParam(value="actionId") String actionId) {
        try {
            if (actionId != null && !actionId.isEmpty() && this.definitions.getAction(actionId) != null) {
                this.log.debugf("DELETE - deleteAction - actionId: %s ", (Object)actionId);
                this.definitions.removeAction(actionId);
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).build());
            } else {
                this.log.debugf("DELETE - deleteAction - actionId: %s not found or invalid. ", (Object)actionId);
                HashMap<String, String> errors = new HashMap<String, String>();
                errors.put("errorMsg", "actionId " + actionId + " not found or invalid Id");
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }
}

