/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.ejb.EJB;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.hawkular.alerts.api.model.condition.Alert;
import org.hawkular.alerts.api.model.data.MixedData;
import org.hawkular.alerts.api.model.trigger.Tag;
import org.hawkular.alerts.api.services.AlertsCriteria;
import org.hawkular.alerts.api.services.AlertsService;
import org.jboss.logging.Logger;

@Path(value="/")
@Api(value="/", description="Alert Handling")
public class AlertsHandler {
    private final Logger log = Logger.getLogger(AlertsHandler.class);
    @EJB
    AlertsService alerts;

    public AlertsHandler() {
        this.log.debugf("Creating instance.", new Object[0]);
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get alerts with optional filtering", responseContainer="Collection<Alert>", response=Alert.class, notes="Pagination is not yet implemented.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Alerts found and returned"), @ApiResponse(code=204, message="Success, no Alerts found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void findAlerts(@Suspended AsyncResponse response, @ApiParam(required=false, value="filter out alerts created before this time, millisecond since epoch") @QueryParam(value="startTime") Long startTime, @ApiParam(required=false, value="filter out alerts created after this time, millisecond since epoch") @QueryParam(value="endTime") Long endTime, @ApiParam(required=false, value="filter out alerts for unspecified alertIds, comma separated list of alert IDs") @QueryParam(value="alertIds") String alertIds, @ApiParam(required=false, value="filter out alerts for unspecified triggers, comma separated list of trigger IDs") @QueryParam(value="triggerIds") String triggerIds, @ApiParam(required=false, value="filter out alerts for unspecified lifecycle status, comma separated list of status values") @QueryParam(value="statuses") String statuses, @ApiParam(required=false, value="filter out alerts for unspecified tags, comma separated list of tags, each tag of format [category|]name") @QueryParam(value="tags") String tags) {
        try {
            List alertList;
            AlertsCriteria criteria = new AlertsCriteria();
            criteria.setStartTime(startTime);
            criteria.setEndTime(endTime);
            if (null != alertIds && !alertIds.trim().isEmpty()) {
                criteria.setAlertIds(Arrays.asList(alertIds.split(",")));
            }
            if (null != triggerIds && !triggerIds.trim().isEmpty()) {
                criteria.setTriggerIds(Arrays.asList(triggerIds.split(",")));
            }
            if (null != statuses && !statuses.trim().isEmpty()) {
                HashSet<Alert.Status> statusSet = new HashSet<Alert.Status>();
                for (String s : statuses.split(",")) {
                    statusSet.add(Alert.Status.valueOf((String)s));
                }
                criteria.setStatusSet(statusSet);
            }
            if (null != tags && !tags.trim().isEmpty()) {
                String[] tagTokens = tags.split(",");
                ArrayList<Tag> tagList = new ArrayList<Tag>(tagTokens.length);
                for (String tagToken : tagTokens) {
                    String[] fields = tagToken.split("\\|");
                    tagList.add(fields.length == 1 ? new Tag(fields[0]) : new Tag(fields[0], fields[1]));
                }
                criteria.setTags(tagList);
            }
            if ((alertList = this.alerts.getAlerts(criteria)).isEmpty()) {
                this.log.debugf("GET - findAlerts - Empty", new Object[0]);
                response.resume((Object)Response.status((Response.Status)Response.Status.NO_CONTENT).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                this.log.debugf("GET - findAlerts - %s alerts", (Object)alertList.size());
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)alertList).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="/reload")
    @ApiOperation(value="Reload all definitions into the alerts service", notes="This service is temporal for demos/poc, this functionality will be handled internallybetween definitions and alerts services")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void reloadAlerts(@Suspended AsyncResponse response) {
        this.alerts.reload();
        response.resume((Object)Response.status((Response.Status)Response.Status.OK).build());
    }

    @GET
    @Path(value="/reload/{triggerId}")
    @ApiOperation(value="Reload a specific trigger into the alerts service")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void reloadTrigger(@Suspended AsyncResponse response, @PathParam(value="triggerId") String triggerId) {
        this.alerts.reloadTrigger(triggerId);
        response.resume((Object)Response.status((Response.Status)Response.Status.OK).build());
    }

    @PUT
    @Path(value="/ack")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Set one or more alerts Acknowledged")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Alerts Acknowledged"), @ApiResponse(code=404, message="AlertIds invalid or not found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void ackAlerts(@Suspended AsyncResponse response, @ApiParam(required=true, value="comma separated list of alertIds to Ack") @QueryParam(value="alertIds") String alertIds, @ApiParam(required=false, value="user acknowledging the alerts") @QueryParam(value="ackBy") String ackBy, @ApiParam(required=false, value="additional notes asscoiated with the acknowledgement") @QueryParam(value="ackNotes") String ackNotes) {
        try {
            if (alertIds != null && !alertIds.isEmpty()) {
                this.log.debugf("PUT - ackAlerts : %s ", (Object)alertIds);
                this.alerts.ackAlerts(Arrays.asList(alertIds.split(",")), ackBy, ackNotes);
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).build());
            } else {
                this.log.debugf("PUT - ackAlerts - alertIds required.", new Object[0]);
                HashMap<String, String> errors = new HashMap<String, String>();
                errors.put("errorMsg", "alertIds required");
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @PUT
    @Path(value="/resolve")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Set one or more alerts Resolved")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Alerts Resolveded"), @ApiResponse(code=404, message="AlertIds invalid or not found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void resolveAlerts(@Suspended AsyncResponse response, @ApiParam(required=true, value="comma separated list of alertIds to set Resolved") @QueryParam(value="alertIds") String alertIds, @ApiParam(required=false, value="user resolving the alerts") @QueryParam(value="resolvedBy") String resolvedBy, @ApiParam(required=false, value="additional notes asscoiated with the resolution") @QueryParam(value="resolvedNotes") String resolvedNotes) {
        try {
            if (alertIds != null && !alertIds.isEmpty()) {
                this.log.debugf("PUT - resolveAlerts : %s ", (Object)alertIds);
                this.alerts.resolveAlerts(Arrays.asList(alertIds.split(",")), resolvedBy, resolvedNotes, null);
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).build());
            } else {
                this.log.debugf("PUT - resolveAlerts - alertIds required.", new Object[0]);
                HashMap<String, String> errors = new HashMap<String, String>();
                errors.put("errorMsg", "alertIds required");
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @POST
    @Path(value="/data")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Send data for alert processing/condition evaluation.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, data added."), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void sendData(@Suspended AsyncResponse response, @ApiParam(required=true, name="mixedData", value="data to be processed by alerting") MixedData mixedData) {
        try {
            if (null == mixedData || mixedData.isEmpty()) {
                String errorMsg = "POST - Data is empty";
                this.log.debugf(errorMsg, new Object[0]);
                HashMap<String, String> errors = new HashMap<String, String>();
                errors.put("errorMsg", errorMsg);
                response.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                this.log.debugf("POST - sendData - %s datums ", (Object)mixedData.size());
                this.alerts.sendData(mixedData.asCollection());
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).build());
            }
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }
}

