/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.Collection;
import java.util.HashMap;
import javax.ejb.EJB;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.hawkular.alerts.api.model.condition.AvailabilityCondition;
import org.hawkular.alerts.api.model.condition.CompareCondition;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.StringCondition;
import org.hawkular.alerts.api.model.condition.ThresholdCondition;
import org.hawkular.alerts.api.model.condition.ThresholdRangeCondition;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.trigger.Tag;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.rest.TriggersHandler;
import org.jboss.logging.Logger;

@Path(value="/triggers")
@Api(value="/triggers", description="Trigger Handling")
public class TriggersHandler {
    private static final Logger log = Logger.getLogger(TriggersHandler.class);
    @EJB
    DefinitionsService definitions;
    ObjectMapper objectMapper;

    public TriggersHandler() {
        log.debugf("Creating instance.", new Object[0]);
        this.objectMapper = new ObjectMapper();
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all Trigger definitions", responseContainer="Collection<Trigger>", response=Trigger.class, notes="Pagination is not yet implemented")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Triggers Found"), @ApiResponse(code=204, message="Success, No Triggers Found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void findAllTriggers(@Suspended AsyncResponse response) {
        try {
            Collection triggerList = this.definitions.getAllTriggers();
            if (triggerList.isEmpty()) {
                log.debugf("GET - findAllTriggers - Empty", new Object[0]);
                response.resume((Object)Response.status((Response.Status)Response.Status.NO_CONTENT).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                log.debugf("GET - findAllTriggers - %s triggers ", (Object)triggerList.size());
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)triggerList).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new trigger definitions. If trigger ID is null, a (likely) unique ID will be generated", response=Trigger.class, notes="Returns Trigger created if operation finished correctly")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Trigger Created"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void createTrigger(@Suspended AsyncResponse response, @ApiParam(value="Trigger definition to be created", name="trigger", required=true) Trigger trigger) {
        try {
            if (null != trigger) {
                if (this.isEmpty(trigger.getId())) {
                    trigger.setId(Trigger.generateId());
                } else if (this.definitions.getTrigger(trigger.getId()) != null) {
                    String errorMsg = "POST - Trigger with ID [" + trigger.getId() + "] exists.";
                    log.debugf(errorMsg, new Object[0]);
                    HashMap<String, String> errors = new HashMap<String, String>();
                    errors.put("errorMsg", errorMsg);
                    response.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
                    return;
                }
                log.debugf("POST - createTrigger - triggerId %s ", (Object)trigger.getId());
                this.definitions.addTrigger(trigger);
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)trigger).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                String errorMsg = "POST - Trigger is null";
                log.debugf(errorMsg, new Object[0]);
                HashMap<String, String> errors = new HashMap<String, String>();
                errors.put("errorMsg", errorMsg);
                response.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="/{triggerId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get an existing trigger definition", response=Trigger.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Trigger Found"), @ApiResponse(code=404, message="Success, No Trigger Found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void getTrigger(@Suspended AsyncResponse response, @ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId) {
        try {
            Trigger found = null;
            if (!this.isEmpty(triggerId)) {
                found = this.definitions.getTrigger(triggerId);
            }
            if (found != null) {
                log.debugf("GET - getTrigger - triggerId: %s ", (Object)found.getId());
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)found).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                log.debugf("GET - getTrigger - triggerId: %s not found or invalid. ", (Object)triggerId);
                HashMap<String, String> errors = new HashMap<String, String>();
                errors.put("errorMsg", "Trigger ID " + triggerId + " not found or invalid ID");
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @PUT
    @Path(value="/{triggerId}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update an existing trigger definition")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Trigger Updated"), @ApiResponse(code=404, message="No Trigger Found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void updateTrigger(@Suspended AsyncResponse response, @ApiParam(value="Trigger definition id to be updated", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Updated trigger definition", name="trigger", required=true) Trigger trigger) {
        try {
            boolean exists = false;
            if (trigger != null && !this.isEmpty(triggerId)) {
                trigger.setId(triggerId);
                boolean bl = exists = this.definitions.getTrigger(triggerId) != null;
            }
            if (exists) {
                log.debugf("PUT - updateTrigger - triggerId: %s ", (Object)triggerId);
                this.definitions.updateTrigger(trigger);
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).build());
            } else {
                log.debugf("PUT - updateTrigger - triggerId: %s not found or invalid. ", (Object)triggerId);
                HashMap<String, String> errors = new HashMap<String, String>();
                errors.put("errorMsg", "Trigger ID " + triggerId + " not found or invalid ID");
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @DELETE
    @Path(value="/{triggerId}")
    @ApiOperation(value="Delete an existing trigger definition")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Trigger Deleted"), @ApiResponse(code=404, message="No Trigger Found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void deleteTrigger(@Suspended AsyncResponse response, @ApiParam(value="Trigger definition id to be deleted", required=true) @PathParam(value="triggerId") String triggerId) {
        try {
            if (!this.isEmpty(triggerId) && this.definitions.getTrigger(triggerId) != null) {
                log.debugf("DELETE - deleteTrigger - triggerId: %s ", (Object)triggerId);
                this.definitions.removeTrigger(triggerId);
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).build());
            } else {
                log.debugf("DELETE - deleteTrigger - triggerId: %s not found or invalid. ", (Object)triggerId);
                HashMap<String, String> errors = new HashMap<String, String>();
                errors.put("errorMsg", "Trigger ID " + triggerId + " not found or invalid ID");
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="/{triggerId}/dampenings")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all Dampenings for a Trigger (1 Dampening per mode).", responseContainer="Collection<Dampening>", response=Dampening.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampenings Found"), @ApiResponse(code=204, message="Success, No Dampenings Found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void getTriggerDampenings(@Suspended AsyncResponse response, @ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId) {
        try {
            Collection dampeningList = this.definitions.getTriggerDampenings(triggerId, null);
            if (dampeningList.isEmpty()) {
                log.debugf("GET - getTriggerDampenings - Empty", new Object[0]);
                response.resume((Object)Response.status((Response.Status)Response.Status.NO_CONTENT).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                log.debugf("GET - getTriggerDampenings - %s conditions ", (Object)dampeningList.size());
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)dampeningList).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="/{triggerId}/dampenings/mode/{triggerMode}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a dampening using triggerId and triggerMode", response=Dampening.class, notes="Similar as getDampening(dampeningId)")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampening Found"), @ApiResponse(code=204, message="Success, No Dampening Found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void getTriggerModeDampenings(@Suspended AsyncResponse response, @ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Trigger mode", required=true) @PathParam(value="triggerMode") Trigger.Mode triggerMode) {
        try {
            Collection dampeningList = this.definitions.getTriggerDampenings(triggerId, triggerMode);
            if (dampeningList.isEmpty()) {
                log.debugf("GET - getTriggerDampenings - Empty", new Object[0]);
                response.resume((Object)Response.status((Response.Status)Response.Status.NO_CONTENT).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                log.debugf("GET - getTriggerDampenings - %s dampenings ", (Object)dampeningList.size());
                Dampening first = (Dampening)dampeningList.iterator().next();
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)first).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="/{triggerId}/dampenings/{dampeningId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get an existing dampening", response=Dampening.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampening Found"), @ApiResponse(code=404, message="No Dampening Found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void getDampening(@Suspended AsyncResponse response, @ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Dampening id", required=true) @PathParam(value="dampeningId") String dampeningId) {
        try {
            Dampening found = null;
            if (!this.isEmpty(dampeningId) && dampeningId.startsWith(triggerId)) {
                found = this.definitions.getDampening(dampeningId);
            }
            if (found != null) {
                log.debugf("GET - getDampening - dampeningId: %s ", (Object)found.getDampeningId());
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)found).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                log.debugf("GET - getDampening - dampeningId: %s not found or invalid. ", (Object)dampeningId);
                HashMap<String, String> errors = new HashMap<String, String>();
                errors.put("errorMsg", "Dampening ID " + dampeningId + " not found or invalid ID");
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @POST
    @Path(value="/{triggerId}/dampenings")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new dampening", response=Dampening.class, notes="Returns Dampening created if operation finished correctly")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampening Created"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void createDampening(@Suspended AsyncResponse response, @ApiParam(value="Trigger definition id attached to dampening", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Dampening definition to be created", name="dampening", required=true) Dampening dampening) {
        try {
            boolean exists = false;
            if (dampening != null && !this.isEmpty(triggerId)) {
                dampening.setTriggerId(triggerId);
                boolean bl = exists = this.definitions.getDampening(dampening.getDampeningId()) != null;
            }
            if (!exists) {
                Dampening d = this.getCleanDampening(dampening);
                log.debugf("POST - createDampening - triggerId %s ", (Object)d.getTriggerId());
                this.definitions.addDampening(d);
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)d).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                log.debugf("POST - createDampening - ID not valid or existing dampening", new Object[0]);
                HashMap<String, String> errors = new HashMap<String, String>();
                errors.put("errorMsg", "Existing dampening or invalid ID");
                response.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    private Dampening getCleanDampening(Dampening dampening) throws Exception {
        switch (1.$SwitchMap$org$hawkular$alerts$api$model$dampening$Dampening$Type[dampening.getType().ordinal()]) {
            case 1: {
                return Dampening.forStrict((String)dampening.getTriggerId(), (Trigger.Mode)dampening.getTriggerMode(), (int)dampening.getEvalTrueSetting());
            }
            case 2: {
                return Dampening.forStrictTime((String)dampening.getTriggerId(), (Trigger.Mode)dampening.getTriggerMode(), (long)dampening.getEvalTimeSetting());
            }
            case 3: {
                return Dampening.forStrictTimeout((String)dampening.getTriggerId(), (Trigger.Mode)dampening.getTriggerMode(), (long)dampening.getEvalTimeSetting());
            }
            case 4: {
                return Dampening.forRelaxedCount((String)dampening.getTriggerId(), (Trigger.Mode)dampening.getTriggerMode(), (int)dampening.getEvalTrueSetting(), (int)dampening.getEvalTotalSetting());
            }
            case 5: {
                return Dampening.forRelaxedTime((String)dampening.getTriggerId(), (Trigger.Mode)dampening.getTriggerMode(), (int)dampening.getEvalTrueSetting(), (long)dampening.getEvalTimeSetting());
            }
        }
        throw new Exception("Unhandled Dampening Type: " + dampening.toString());
    }

    @PUT
    @Path(value="/{triggerId}/dampenings/{dampeningId}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update an existing dampening definition. Note that the trigger mode can not be changed.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampening Updated"), @ApiResponse(code=404, message="No Dampening Found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void updateDampening(@Suspended AsyncResponse response, @ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Dampening id", required=true) @PathParam(value="dampeningId") String dampeningId, @ApiParam(value="Updated dampening definition", name="dampening", required=true) Dampening dampening) {
        try {
            boolean exists = false;
            if (dampening != null && !this.isEmpty(triggerId) && !this.isEmpty(dampeningId)) {
                dampening.setTriggerId(triggerId);
                if (dampeningId.equals(dampening.getDampeningId())) {
                    boolean bl = exists = this.definitions.getDampening(dampeningId) != null;
                }
            }
            if (exists) {
                log.debugf("PUT - updateDampening - dampeningId: %s ", (Object)dampeningId);
                Dampening d = this.getCleanDampening(dampening);
                this.definitions.updateDampening(d);
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).build());
            } else {
                log.debugf("PUT - updateDampening - dampeningId: %s not found or invalid. ", (Object)dampeningId);
                HashMap<String, String> errors = new HashMap<String, String>();
                errors.put("errorMsg", "Dampening ID " + dampeningId + " not found or invalid ID");
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @DELETE
    @Path(value="/{triggerId}/dampenings/{dampeningId}")
    @ApiOperation(value="Delete an existing dampening definition")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampening Deleted"), @ApiResponse(code=404, message="No Dampening Found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void deleteDampening(@Suspended AsyncResponse response, @ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Dampening id for dampening definition to be deleted", required=true) @PathParam(value="dampeningId") String dampeningId) {
        try {
            if (!this.isEmpty(dampeningId) && dampeningId.startsWith(triggerId) && this.definitions.getDampening(dampeningId) != null) {
                log.debugf("DELETE - deleteDampening - dampeningId: %s ", (Object)dampeningId);
                this.definitions.removeDampening(dampeningId);
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).build());
            } else {
                log.debugf("DELETE - deleteDampening - dampeningId: %s not found or invalid ", (Object)dampeningId);
                HashMap<String, String> errors = new HashMap<String, String>();
                errors.put("errorMsg", "Dampening ID " + dampeningId + " not found or invalid ID");
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="/{triggerId}/conditions")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a map with all conditions for a specific trigger.", responseContainer="Collection<Condition>", response=Condition.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Conditions Found"), @ApiResponse(code=204, message="Success, No Conditions Found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void getTriggerConditions(@Suspended AsyncResponse response, @ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId) {
        try {
            Collection conditionsList = this.definitions.getTriggerConditions(triggerId, null);
            if (conditionsList.isEmpty()) {
                log.debugf("GET - getTriggerConditions - Empty", new Object[0]);
                response.resume((Object)Response.status((Response.Status)Response.Status.NO_CONTENT).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                log.debugf("GET - getTriggerConditions - %s conditions ", (Object)conditionsList.size());
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)conditionsList).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="/{triggerId}/conditions/{conditionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a condition for a specific trigger id.", response=Condition.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Condition Found"), @ApiResponse(code=404, message="No Condition Found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void getTriggerCondition(@Suspended AsyncResponse response, @ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId, @PathParam(value="conditionId") String conditionId) {
        try {
            Condition condition = null;
            if (conditionId.startsWith(triggerId)) {
                condition = this.definitions.getCondition(conditionId);
            }
            if (condition == null) {
                log.debugf("GET - getTriggerCondition - Empty", new Object[0]);
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                log.debugf("GET - getTriggerCondition - %s condition ", (Object)conditionId);
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)condition).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @POST
    @Path(value="/{triggerId}/conditions")
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new condition for a specific trigger", responseContainer="Collection", response=Condition.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Condition Created"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void createCondition(@Suspended AsyncResponse response, @ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Json representation of a condition. For examples of Condition types, See https://github.com/hawkular/hawkular-alerts/blob/master/hawkular-alerts-rest-tests/src/test/groovy/org/hawkular/alerts/rest/ConditionsITest.groovy") String jsonCondition) {
        try {
            if (this.isEmpty(jsonCondition) || !jsonCondition.contains("type")) {
                log.debugf("POST - createCondition - json condition empty or without type", new Object[0]);
                HashMap<String, String> errors = new HashMap<String, String>();
                errors.put("errorMsg", "Condition empty or without type");
                response.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                Condition.Type conditionType = this.conditionType(jsonCondition);
                if (conditionType == null || this.isEmpty(triggerId)) {
                    log.debugf("POST - createCondition - bad type or bad triggerId ", new Object[0]);
                    HashMap<String, String> errors = new HashMap<String, String>();
                    errors.put("errorMsg", "Condition with bad type");
                    response.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
                } else {
                    Condition condition = null;
                    if (conditionType.equals((Object)Condition.Type.AVAILABILITY)) {
                        condition = (Condition)this.objectMapper.readValue(jsonCondition, AvailabilityCondition.class);
                    } else if (conditionType.equals((Object)Condition.Type.COMPARE)) {
                        condition = (Condition)this.objectMapper.readValue(jsonCondition, CompareCondition.class);
                    } else if (conditionType.equals((Object)Condition.Type.STRING)) {
                        condition = (Condition)this.objectMapper.readValue(jsonCondition, StringCondition.class);
                    } else if (conditionType.equals((Object)Condition.Type.THRESHOLD)) {
                        condition = (Condition)this.objectMapper.readValue(jsonCondition, ThresholdCondition.class);
                    } else if (conditionType.equals((Object)Condition.Type.RANGE)) {
                        condition = (Condition)this.objectMapper.readValue(jsonCondition, ThresholdRangeCondition.class);
                    }
                    condition.setTriggerId(triggerId);
                    Collection newConditions = this.definitions.addCondition(condition.getTriggerId(), condition.getTriggerMode(), condition);
                    response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)newConditions).type(MediaType.APPLICATION_JSON_TYPE).build());
                }
            }
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @PUT
    @Path(value="/{triggerId}/conditions/{conditionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Update an existing condition for a specific trigger")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Condition Updated"), @ApiResponse(code=404, message="No Condition Found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void updateCondition(@Suspended AsyncResponse response, @ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId, @PathParam(value="conditionId") String conditionId, @ApiParam(value="Json representation of a condition") String jsonCondition) {
        try {
            if (this.isEmpty(jsonCondition) || !jsonCondition.contains("type")) {
                log.debugf("POST - updateCondition - json condition empty or without type", new Object[0]);
                HashMap<String, String> errors = new HashMap<String, String>();
                errors.put("errorMsg", "Condition empty or without type");
                response.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                Condition.Type conditionType = this.conditionType(jsonCondition);
                if (conditionType == null || this.isEmpty(conditionId)) {
                    log.debugf("POST - createCondition - bad type or invalid conditionId ", new Object[0]);
                    HashMap<String, String> errors = new HashMap<String, String>();
                    errors.put("errorMsg", "Condition with bad type");
                    response.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
                } else {
                    Condition condition = null;
                    if (conditionType.equals((Object)Condition.Type.AVAILABILITY)) {
                        condition = (Condition)this.objectMapper.readValue(jsonCondition, AvailabilityCondition.class);
                    } else if (conditionType.equals((Object)Condition.Type.COMPARE)) {
                        condition = (Condition)this.objectMapper.readValue(jsonCondition, CompareCondition.class);
                    } else if (conditionType.equals((Object)Condition.Type.STRING)) {
                        condition = (Condition)this.objectMapper.readValue(jsonCondition, StringCondition.class);
                    } else if (conditionType.equals((Object)Condition.Type.THRESHOLD)) {
                        condition = (Condition)this.objectMapper.readValue(jsonCondition, ThresholdCondition.class);
                    } else if (conditionType.equals((Object)Condition.Type.RANGE)) {
                        condition = (Condition)this.objectMapper.readValue(jsonCondition, ThresholdRangeCondition.class);
                    }
                    boolean exists = false;
                    if (conditionId.equals(condition.getConditionId())) {
                        boolean bl = exists = this.definitions.getCondition(condition.getConditionId()) != null;
                    }
                    if (!exists) {
                        log.debugf("PUT - updateCondition - Condition " + condition.getConditionId() + " doesn't exist", new Object[0]);
                        HashMap<String, String> errors = new HashMap<String, String>();
                        errors.put("errorMsg", "Condition " + condition.getConditionId() + " doesn't exist");
                        response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
                    } else {
                        Collection updatedConditions = this.definitions.updateCondition(condition);
                        response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)updatedConditions).type(MediaType.APPLICATION_JSON_TYPE).build());
                    }
                }
            }
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @DELETE
    @Path(value="/{triggerId}/conditions/{conditionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete an existing condition for a specific trigger", responseContainer="Collection<Condition>", response=Condition.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Condition Deleted"), @ApiResponse(code=404, message="No Condition Found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void deleteCondition(@Suspended AsyncResponse response, @ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId, @PathParam(value="conditionId") String conditionId) {
        try {
            Condition test = this.definitions.getCondition(conditionId);
            if (test == null) {
                log.debugf("POST - deleteCondition - Condition " + conditionId + " not found or invalid", new Object[0]);
                HashMap<String, String> errors = new HashMap<String, String>();
                errors.put("errorMsg", "Condition " + conditionId + " not found or invalid");
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                Collection updatedConditions = this.definitions.removeCondition(conditionId);
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)updatedConditions).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    private Condition.Type conditionType(String jsonCondition) {
        int startType = jsonCondition.indexOf("\"type\"") + 6;
        int endType = jsonCondition.indexOf(",", startType);
        if (endType == -1 && (endType = jsonCondition.indexOf("}", startType)) == -1) {
            return null;
        }
        String type = jsonCondition.substring(startType, endType);
        startType = type.indexOf(34) + 1;
        endType = type.indexOf(34, startType);
        type = type.substring(startType, endType);
        try {
            return Condition.Type.valueOf((String)type);
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            return null;
        }
    }

    @POST
    @Path(value="/tags")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new trigger tag", response=Tag.class, notes="Returns Tag created if operation finished correctly")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Tag Created"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void createTag(@Suspended AsyncResponse response, @ApiParam(value="Tag to be created", name="tag", required=true) Tag tag) {
        try {
            if (!this.isEmpty(tag.getTriggerId()) && !this.isEmpty(tag.getName())) {
                log.debugf("POST - createTag: %s ", (Object)tag);
                this.definitions.addTag(tag);
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)tag).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                log.debugf("POST - createTag - Invalid Tag, trigger-id, name required", new Object[0]);
                HashMap<String, String> errors = new HashMap<String, String>();
                errors.put("errorMsg", "Invalid Tag, no trigger or missing required field");
                response.resume((Object)Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @POST
    @Path(value="/{triggerId}/tags")
    @ApiOperation(value="Delete existing Tags from a Trigger")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Tags Deleted"), @ApiResponse(code=404, message="No Trigger Found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void deleteTags(@Suspended AsyncResponse response, @ApiParam(value="Trigger id of tags to be deleted", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Category of tags to be deleted", required=false) @QueryParam(value="category") String category, @ApiParam(value="Name of tags to be deleted", required=false) @QueryParam(value="name") String name) {
        try {
            if (!this.isEmpty(triggerId)) {
                log.debugf("DELETE - deleteTags - triggerId: %s, category: %s, name: %s ", (Object)triggerId, (Object)category, (Object)name);
                this.definitions.removeTags(triggerId, category, name);
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).build());
            } else {
                log.debugf("DELETE - deleteTags - triggerId: %s not found or invalid. ", (Object)triggerId);
                HashMap<String, String> errors = new HashMap<String, String>();
                errors.put("errorMsg", "Trigger ID " + triggerId + " not found or invalid ID");
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    @GET
    @Path(value="/{triggerId}/tags")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get tags for a trigger.", responseContainer="Collection<Tag>", response=Tag.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Tags Found"), @ApiResponse(code=204, message="Success, No Tags Found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public void getTriggerTags(@Suspended AsyncResponse response, @ApiParam(value="Trigger id for the retrieved Tags", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Category of tags to be retrieved", required=false) @QueryParam(value="category") String category) {
        try {
            Collection tagsList = null;
            if (!this.isEmpty(triggerId)) {
                tagsList = this.definitions.getTriggerTags(triggerId, category);
            }
            if (null == tagsList || tagsList.isEmpty()) {
                log.debugf("GET - getTriggerTags - Empty", new Object[0]);
                response.resume((Object)Response.status((Response.Status)Response.Status.NO_CONTENT).type(MediaType.APPLICATION_JSON_TYPE).build());
            } else {
                log.debugf("GET - getTriggerTags - %s tags ", (Object)tagsList.size());
                response.resume((Object)Response.status((Response.Status)Response.Status.OK).entity((Object)tagsList).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
        }
        catch (Exception e) {
            log.debugf(e.getMessage(), (Object)e);
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("errorMsg", "Internal Error: " + e.getMessage());
            response.resume((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(errors).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    private boolean isEmpty(String s) {
        return null == s || s.trim().isEmpty();
    }
}

