/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.Collection;
import java.util.Map;
import javax.ejb.EJB;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.alerts.api.model.action.Action;
import org.hawkular.alerts.api.services.ActionsService;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.rest.ResponseUtil;
import org.jboss.logging.Logger;

@Path(value="/actions")
@Api(value="/actions", description="Action Handling")
public class ActionsHandler {
    private final Logger log = Logger.getLogger(ActionsHandler.class);
    @Inject
    Persona persona;
    @EJB
    DefinitionsService definitions;
    @EJB
    ActionsService actions;

    public ActionsHandler() {
        this.log.debugf("Creating instance.", new Object[0]);
    }

    @POST
    @Path(value="/send")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Send an action to the ActionService.", notes="ActionService should not be invoked directly. This method is for demo/poc purposes.")
    @ApiResponses(value={@ApiResponse(code=200, message="Action sent succesfully."), @ApiResponse(code=500, message="Internal server error")})
    public Response send(Action action) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            this.actions.send(action);
            return ResponseUtil.ok();
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all action ids grouped by plugin", notes="Pagination is not yet implemented")
    @ApiResponses(value={@ApiResponse(code=200, message="Success. Actions found."), @ApiResponse(code=204, message="Success. No actions found."), @ApiResponse(code=500, message="Internal server error")})
    public Response findActions() {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            Map actions = this.definitions.getActions(this.persona.getId());
            this.log.debugf("Actions: ", (Object)actions);
            if (this.isEmpty(actions)) {
                return ResponseUtil.noContent();
            }
            return ResponseUtil.ok((Object)actions);
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @GET
    @Path(value="/plugin/{actionPlugin}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all action ids of an specific action plugin", notes="Pagination is not yet implemented")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Actions Found"), @ApiResponse(code=204, message="No Actions Found"), @ApiResponse(code=500, message="Internal server error")})
    public Response findActionsByPlugin(@ApiParam(value="Action plugin to filter query for action ids", required=true) @PathParam(value="actionPlugin") String actionPlugin) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            Collection actions = this.definitions.getActions(this.persona.getId(), actionPlugin);
            this.log.debugf("Actions: %s ", (Object)actions);
            if (this.isEmpty(actions)) {
                return ResponseUtil.noContent();
            }
            return ResponseUtil.ok((Object)actions);
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new action", notes="Action properties are variable and depends on the action plugin. A user needs to request previously ActionPlugin API to get the list of properties to fill for a specific type. All actions should have actionId and actionPlugin as mandatory properties")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Action Created"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Existing action/Invalid Parameters")})
    public Response createAction(@ApiParam(value="Action properties. Properties depend of specific ActionPlugin.", name="actionProperties", required=true) Map<String, String> actionProperties) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        String actionPlugin = actionProperties.get("actionPlugin");
        String actionId = actionProperties.get("actionId");
        if (this.isEmpty(actionPlugin)) {
            return ResponseUtil.badRequest((String)"actionPlugin must be not null");
        }
        if (this.isEmpty(actionId)) {
            return ResponseUtil.badRequest((String)"actionId must be not null");
        }
        try {
            if (this.definitions.getAction(this.persona.getId(), actionPlugin, actionId) != null) {
                return ResponseUtil.badRequest((String)("Existing action:  " + actionId));
            }
            this.definitions.addAction(this.persona.getId(), actionPlugin, actionId, actionProperties);
            this.log.debugf("ActionId: %s - Properties: %s ", (Object)actionId, actionProperties);
            return ResponseUtil.ok(actionProperties);
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @GET
    @Path(value="/{actionPlugin}/{actionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get an existing action", responseContainer="Map<String, String>", response=String.class, notes="Action is represented as a map of properties.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Action Found"), @ApiResponse(code=404, message="No Action Found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getAction(@ApiParam(value="Action plugin", required=true) @PathParam(value="actionPlugin") String actionPlugin, @ApiParam(value="Action id to be retrieved", required=true) @PathParam(value="actionId") String actionId) {
        if (!this.checkPersona()) {
            return ResponseUtil.internalError((String)"No persona found");
        }
        try {
            Map actionProperties = this.definitions.getAction(this.persona.getId(), actionPlugin, actionId);
            this.log.debugf("ActionId: %s - Properties: %s ", (Object)actionId, (Object)actionProperties);
            if (this.isEmpty(actionProperties)) {
                return ResponseUtil.notFound((Object)("Not action found for actionPlugin: " + actionPlugin + " and actionId: " + actionId));
            }
            return ResponseUtil.ok((Object)actionProperties);
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @PUT
    @Path(value="/{actionPlugin}/{actionId}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update an existing action", notes="Action properties are variable and depends on the action plugin. A user needs to request previously ActionPlugin API to get the list of properties to fill for a specific type. All actions should have actionId and actionPlugin as mandatory properties")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Action Updated"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="Action not found for update")})
    public Response updateAction(@ApiParam(value="Action plugin", required=true) @PathParam(value="actionPlugin") String actionPlugin, @ApiParam(value="action id to be updated", required=true) @PathParam(value="actionId") String actionId, @ApiParam(value="Action properties. Properties depend of specific ActionPlugin.", required=true) Map<String, String> actionProperties) {
        try {
            if (!this.checkPersona()) {
                return ResponseUtil.internalError((String)"No persona found");
            }
            if (this.definitions.getAction(this.persona.getId(), actionPlugin, actionId) != null) {
                this.definitions.updateAction(this.persona.getId(), actionPlugin, actionId, actionProperties);
                this.log.debugf("ActionId: %s - Properties: %s ", (Object)actionId, actionProperties);
                return ResponseUtil.ok(actionProperties);
            }
            return ResponseUtil.notFound((Object)("ActionId: " + actionId + " not found for update"));
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @DELETE
    @Path(value="/{actionPlugin}/{actionId}")
    @ApiOperation(value="Delete an existing action")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Action Deleted"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="ActionId not found for delete")})
    public Response deleteAction(@ApiParam(value="Action plugin", required=true) @PathParam(value="actionPlugin") String actionPlugin, @ApiParam(value="Action id to be deleted", required=true) @PathParam(value="actionId") String actionId) {
        try {
            if (!this.checkPersona()) {
                return ResponseUtil.internalError((String)"No persona found");
            }
            if (this.definitions.getAction(this.persona.getId(), actionPlugin, actionId) != null) {
                this.definitions.removeAction(this.persona.getId(), actionPlugin, actionId);
                this.log.debugf("ActionId: %s ", (Object)actionId);
                return ResponseUtil.ok();
            }
            return ResponseUtil.notFound((Object)("ActionId: " + actionId + " not found for delete"));
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    private boolean checkPersona() {
        if (this.persona == null) {
            this.log.warn((Object)"Persona is null. Possible issue with accounts integration ? ");
            return false;
        }
        if (this.persona.getId().trim().isEmpty()) {
            this.log.warn((Object)"Persona is empty. Possible issue with accounts integration ? ");
            return false;
        }
        return true;
    }

    private boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    private boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }
}

