/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.rest.accounts;

import java.io.IOException;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.alerts.rest.ResponseUtil;
import org.jboss.logging.Logger;

@Provider
public class PersonaFilter
implements ContainerRequestFilter {
    private final Logger log = Logger.getLogger(PersonaFilter.class);
    @Inject
    Persona persona;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (!this.checkPersona()) {
            requestContext.abortWith(ResponseUtil.internalError((String)"No persona found"));
        }
        requestContext.getHeaders().putSingle((Object)"Hawkular-Tenant", (Object)this.persona.getId());
    }

    private boolean checkPersona() {
        if (this.persona == null) {
            this.log.warn((Object)"Persona is null. Possible issue with accounts integration ? ");
            return false;
        }
        if (this.isEmpty(this.persona.getId())) {
            this.log.warn((Object)"Persona is empty. Possible issue with accounts integration ? ");
            return false;
        }
        return true;
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }
}

