/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.rest;

import java.util.ArrayList;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.hawkular.alerts.api.model.paging.Page;
import org.hawkular.alerts.api.model.paging.PageContext;
import org.hawkular.alerts.rest.ResponseUtil;
import org.hawkular.alerts.rest.json.Link;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResponseUtil {
    public static Response internalError(String message) {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ApiError(message)).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public static Response notFound(String message) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ApiError(message)).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public static Response ok(Object entity) {
        return Response.status((Response.Status)Response.Status.OK).entity(entity).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public static <T> Response paginatedOk(Page<T> page, UriInfo uri) {
        ArrayList<T> data = new ArrayList<T>(page);
        Response.ResponseBuilder response = Response.status((Response.Status)Response.Status.OK).entity(data);
        ResponseUtil.createPagingHeader((Response.ResponseBuilder)response, (UriInfo)uri, page);
        return response.build();
    }

    public static Response ok() {
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public static Response badRequest(String message) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ApiError(message)).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public static void createPagingHeader(Response.ResponseBuilder builder, UriInfo uriInfo, Page<?> resultList) {
        UriBuilder uriBuilder;
        PageContext pc = resultList.getPageContext();
        int page = pc.getPageNumber();
        ArrayList<Link> links = new ArrayList<Link>();
        if (pc.isLimited() && resultList.getTotalSize() > (long)((pc.getPageNumber() + 1) * pc.getPageSize())) {
            int nextPage = page + 1;
            uriBuilder = uriInfo.getRequestUriBuilder();
            uriBuilder.replaceQueryParam("page", new Object[]{nextPage});
            links.add(new Link("next", uriBuilder.build(new Object[0]).toString()));
        }
        if (page > 0) {
            int prevPage = page - 1;
            uriBuilder = uriInfo.getRequestUriBuilder();
            uriBuilder.replaceQueryParam("page", new Object[]{prevPage});
            links.add(new Link("prev", uriBuilder.build(new Object[0]).toString()));
        }
        if (pc.isLimited()) {
            long lastPage = resultList.getTotalSize() / (long)pc.getPageSize();
            if (resultList.getTotalSize() % (long)pc.getPageSize() == 0L) {
                --lastPage;
            }
            uriBuilder = uriInfo.getRequestUriBuilder();
            uriBuilder.replaceQueryParam("page", new Object[]{lastPage});
            links.add(new Link("last", uriBuilder.build(new Object[0]).toString()));
        }
        uriBuilder = uriInfo.getRequestUriBuilder();
        StringBuilder linkHeader = new StringBuilder(new Link("current", uriBuilder.build(new Object[0]).toString()).rfc5988String());
        links.forEach(l -> linkHeader.append(", ").append(l.rfc5988String()));
        builder.header("Link", (Object)linkHeader.toString());
        builder.header("X-Total-Count", (Object)resultList.getTotalSize());
    }
}

