/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.Collection;
import java.util.Set;
import javax.ejb.EJB;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.rest.ResponseUtil;
import org.jboss.logging.Logger;

@Path(value="/plugins")
@Api(value="/plugins", description="Query operations for action plugins")
public class ActionPluginHandler {
    private final Logger log = Logger.getLogger(ActionPluginHandler.class);
    @HeaderParam(value="Hawkular-Tenant")
    String tenantId;
    @EJB
    DefinitionsService definitions;

    public ActionPluginHandler() {
        this.log.debug((Object)"Creating instance.");
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all action plugins.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched list of actions plugins."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class)})
    public Response findActionPlugins() {
        try {
            Collection actionPlugins = this.definitions.getActionPlugins();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("ActionPlugins: " + actionPlugins));
            }
            return ResponseUtil.ok((Object)actionPlugins);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @GET
    @Path(value="/{actionPlugin}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find list of properties to fill for a specific action plugin.", notes="Each action plugin can have a different and variable number of properties. This method should be invoked before of a creation of a new action.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Action Plugin found."), @ApiResponse(code=404, message="Action Plugin not found.", response=ResponseUtil.ApiError.class), @ApiResponse(code=500, message="Internal server error", response=ResponseUtil.ApiError.class)})
    public Response getActionPlugin(@ApiParam(value="Action plugin to query.", required=true) @PathParam(value="actionPlugin") String actionPlugin) {
        try {
            Set actionPluginProps = this.definitions.getActionPlugin(actionPlugin);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("ActionPlugin: " + actionPlugin + " - Properties: " + actionPluginProps));
            }
            if (this.isEmpty((Collection)actionPluginProps)) {
                return ResponseUtil.notFound((String)("actionPlugin: " + actionPlugin + " not found"));
            }
            return ResponseUtil.ok((Object)actionPluginProps);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    private boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }
}

