/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.ejb.EJB;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.alerts.api.model.action.Action;
import org.hawkular.alerts.api.model.action.ActionDefinition;
import org.hawkular.alerts.api.model.paging.Page;
import org.hawkular.alerts.api.model.paging.Pager;
import org.hawkular.alerts.api.services.ActionsCriteria;
import org.hawkular.alerts.api.services.ActionsService;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.rest.RequestUtil;
import org.hawkular.alerts.rest.ResponseUtil;
import org.jboss.logging.Logger;

@Path(value="/actions")
@Api(value="/actions", description="Actions Handling")
public class ActionsHandler {
    private final Logger log = Logger.getLogger(ActionsHandler.class);
    @HeaderParam(value="Hawkular-Tenant")
    String tenantId;
    @EJB
    DefinitionsService definitions;
    @EJB
    ActionsService actions;

    public ActionsHandler() {
        this.log.debug((Object)"Creating instance.");
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all action ids grouped by plugin.", notes="Return a Map<String, Collection<String>> where key is the plugin id and value a collection if actionIds.", response=Map.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched map of action ids grouped by plugin."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class)})
    public Response findActionIds() {
        try {
            Map actions = this.definitions.getActionDefinitionIds(this.tenantId);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Actions: " + actions));
            }
            return ResponseUtil.ok((Object)actions);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @GET
    @Path(value="/plugin/{actionPlugin}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all action ids of an specific action plugin.", response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched list of action ids."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class)})
    public Response findActionIdsByPlugin(@ApiParam(value="Action plugin to filter query for action ids.", required=true) @PathParam(value="actionPlugin") String actionPlugin) {
        try {
            Collection actions = this.definitions.getActionDefinitionIds(this.tenantId, actionPlugin);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Actions: " + actions));
            }
            return ResponseUtil.ok((Object)actions);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @GET
    @Path(value="/{actionPlugin}/{actionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get an existing action definition.", response=ActionDefinition.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Action found."), @ApiResponse(code=404, message="No Action found.", response=ResponseUtil.ApiError.class), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class)})
    public Response getActionDefinition(@ApiParam(value="Action plugin.", required=true) @PathParam(value="actionPlugin") String actionPlugin, @ApiParam(value="Action id to be retrieved.", required=true) @PathParam(value="actionId") String actionId) {
        try {
            ActionDefinition actionDefinition = this.definitions.getActionDefinition(this.tenantId, actionPlugin, actionId);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("ActionDefinition: " + actionDefinition));
            }
            if (actionDefinition == null) {
                return ResponseUtil.notFound((String)("Not action found for actionPlugin: " + actionPlugin + " and actionId: " + actionId));
            }
            return ResponseUtil.ok((Object)actionDefinition);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new ActionDefinition.", notes="Returns created ActionDefinition", response=ActionDefinition.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, ActionDefinition Created."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Existing ActionDefinition/Invalid Parameters", response=ResponseUtil.ApiError.class)})
    public Response createActionDefinition(@ApiParam(value="ActionDefinition to be created.", name="actionDefinition", required=true) ActionDefinition actionDefinition) {
        if (actionDefinition == null) {
            return ResponseUtil.badRequest((String)"actionDefinition must be not null");
        }
        if (this.isEmpty(actionDefinition.getActionPlugin())) {
            return ResponseUtil.badRequest((String)"actionPlugin must be not null");
        }
        if (this.isEmpty(actionDefinition.getActionId())) {
            return ResponseUtil.badRequest((String)"actionId must be not null");
        }
        if (this.isEmpty(actionDefinition.getProperties())) {
            return ResponseUtil.badRequest((String)"properties must be not null");
        }
        try {
            if (this.definitions.getActionDefinition(this.tenantId, actionDefinition.getActionPlugin(), actionDefinition.getActionId()) != null) {
                return ResponseUtil.badRequest((String)("Existing ActionDefinition:  " + actionDefinition));
            }
            this.definitions.addActionDefinition(this.tenantId, actionDefinition);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("ActionDefinition: " + actionDefinition));
            }
            return ResponseUtil.ok((Object)actionDefinition);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @PUT
    @Path(value="/")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update an existing ActionDefinition.", notes="Returns updated ActionDefinition.", response=ActionDefinition.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, ActionDefinition Updated."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=404, message="ActionDefinition not found for update.", response=ResponseUtil.ApiError.class)})
    public Response updateActionDefinition(@ApiParam(value="ActionDefinition to be updated.", name="actionDefinition", required=true) ActionDefinition actionDefinition) {
        if (actionDefinition == null) {
            return ResponseUtil.badRequest((String)"actionDefinition must be not null");
        }
        if (this.isEmpty(actionDefinition.getActionPlugin())) {
            return ResponseUtil.badRequest((String)"actionPlugin must be not null");
        }
        if (this.isEmpty(actionDefinition.getActionId())) {
            return ResponseUtil.badRequest((String)"actionId must be not null");
        }
        try {
            actionDefinition.setTenantId(this.tenantId);
            if (this.definitions.getActionDefinition(this.tenantId, actionDefinition.getActionPlugin(), actionDefinition.getActionId()) != null) {
                this.definitions.updateActionDefinition(this.tenantId, actionDefinition);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("ActionDefinition: " + actionDefinition));
                }
                return ResponseUtil.ok((Object)actionDefinition);
            }
            return ResponseUtil.notFound((String)("ActionDefinition: " + actionDefinition + " not found for update"));
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @DELETE
    @Path(value="/{actionPlugin}/{actionId}")
    @ApiOperation(value="Delete an existing ActionDefinition.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, ActionDefinition Deleted."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=404, message="ActionDefinition not found for delete.", response=ResponseUtil.ApiError.class)})
    public Response deleteActionDefinition(@ApiParam(value="Action plugin.", required=true) @PathParam(value="actionPlugin") String actionPlugin, @ApiParam(value="Action id to be deleted.", required=true) @PathParam(value="actionId") String actionId) {
        try {
            if (this.definitions.getActionDefinition(this.tenantId, actionPlugin, actionId) != null) {
                this.definitions.removeActionDefinition(this.tenantId, actionPlugin, actionId);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("ActionPlugin: " + actionPlugin + " ActionId: " + actionId));
                }
                return ResponseUtil.ok();
            }
            return ResponseUtil.notFound((String)("ActionPlugin: " + actionPlugin + " ActionId: " + actionId + " not found for delete"));
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @GET
    @Path(value="/history")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get actions from history with optional filtering.", response=Action.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched list of actions."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class)})
    public Response findActionsHistory(@ApiParam(required=false, value="Filter out actions created before this time, millisecond since epoch.") @QueryParam(value="startTime") Long startTime, @ApiParam(required=false, value="Filter out actions created after this time, millisecond since epoch.") @QueryParam(value="endTime") Long endTime, @ApiParam(required=false, value="Filter out actions for unspecified actionPlugin, comma separated list of plugin names.") @QueryParam(value="actionPlugins") String actionPlugins, @ApiParam(required=false, value="Filter out actions for unspecified actionId, comma separated list of action IDs.") @QueryParam(value="actionIds") String actionIds, @ApiParam(required=false, value="Filter out actions for unspecified alertIds, comma separated list of alert IDs.") @QueryParam(value="alertIds") String alertIds, @ApiParam(required=false, value="Filter out alerts for unspecified result, comma separated list of action results.") @QueryParam(value="results") String results, @ApiParam(required=false, value="Return only thin actions, do not include full alert, only alertId.") @QueryParam(value="thin") Boolean thin, @Context UriInfo uri) {
        Pager pager = RequestUtil.extractPaging((UriInfo)uri);
        try {
            ActionsCriteria criteria = this.buildCriteria(startTime, endTime, actionPlugins, actionIds, alertIds, results, thin);
            Page actionPage = this.actions.getActions(this.tenantId, criteria, pager);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Actions: " + actionPage));
            }
            if (this.isEmpty((Collection)actionPage)) {
                return ResponseUtil.ok((Object)actionPage);
            }
            return ResponseUtil.paginatedOk((Page)actionPage, (UriInfo)uri);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @PUT
    @Path(value="/history/delete")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete actions from history with optional filtering.", response=Integer.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Actions deleted."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class)})
    public Response deleteActionsHistory(@ApiParam(required=false, value="Filter out actions created before this time, millisecond since epoch.") @QueryParam(value="startTime") Long startTime, @ApiParam(required=false, value="Filter out action created after this time, millisecond since epoch.") @QueryParam(value="endTime") Long endTime, @ApiParam(required=false, value="Filter out actions for unspecified actionPlugin, comma separated list of plugin names.") @QueryParam(value="actionPlugins") String actionPlugins, @ApiParam(required=false, value="Filter out actions for unspecified actionId, comma separated list of action IDs.") @QueryParam(value="actionIds") String actionIds, @ApiParam(required=false, value="Filter out actions for unspecified alertIds, comma separated list of alert IDs.") @QueryParam(value="alertIds") String alertIds, @ApiParam(required=false, value="Filter out alerts for unspecified result, comma separated list of action results.") @QueryParam(value="results") String results) {
        try {
            ActionsCriteria criteria = this.buildCriteria(startTime, endTime, actionPlugins, actionIds, alertIds, results, Boolean.valueOf(false));
            int numDeleted = this.actions.deleteActions(this.tenantId, criteria);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Actions deleted: " + numDeleted));
            }
            return ResponseUtil.ok((Object)numDeleted);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    private ActionsCriteria buildCriteria(Long startTime, Long endTime, String actionPlugins, String actionIds, String alertIds, String results, Boolean thin) {
        ActionsCriteria criteria = new ActionsCriteria();
        criteria.setStartTime(startTime);
        criteria.setEndTime(endTime);
        if (!this.isEmpty(actionPlugins)) {
            criteria.setActionPlugins(Arrays.asList(actionPlugins.split(",")));
        }
        if (!this.isEmpty(actionIds)) {
            criteria.setActionIds(Arrays.asList(actionPlugins.split(",")));
        }
        if (!this.isEmpty(alertIds)) {
            criteria.setAlertIds(Arrays.asList(alertIds.split(",")));
        }
        if (!this.isEmpty(results)) {
            criteria.setResults(Arrays.asList(results.split(",")));
        }
        if (thin != null) {
            criteria.setThin(thin.booleanValue());
        } else {
            criteria.setThin(false);
        }
        return criteria;
    }

    private boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    private boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }
}

