/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.ejb.EJB;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.alerts.api.model.Severity;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.model.event.Alert;
import org.hawkular.alerts.api.model.paging.Page;
import org.hawkular.alerts.api.model.paging.Pager;
import org.hawkular.alerts.api.services.AlertsCriteria;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.engine.service.AlertsEngine;
import org.hawkular.alerts.rest.RequestUtil;
import org.hawkular.alerts.rest.ResponseUtil;
import org.jboss.logging.Logger;

@Path(value="/")
@Api(value="/", description="Alerts Handling")
public class AlertsHandler {
    private final Logger log = Logger.getLogger(AlertsHandler.class);
    @HeaderParam(value="Hawkular-Tenant")
    String tenantId;
    @EJB
    AlertsService alertsService;
    @EJB
    AlertsEngine alertsEngine;

    public AlertsHandler() {
        this.log.debug((Object)"Creating instance.");
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get alerts with optional filtering.", response=Alert.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched list of alerts."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class)})
    public Response findAlerts(@ApiParam(required=false, value="Filter out alerts created before this time, millisecond since epoch.") @QueryParam(value="startTime") Long startTime, @ApiParam(required=false, value="Filter out alerts created after this time, millisecond since epoch.") @QueryParam(value="endTime") Long endTime, @ApiParam(required=false, value="Filter out alerts for unspecified alertIds, comma separated list of alert IDs.") @QueryParam(value="alertIds") String alertIds, @ApiParam(required=false, value="Filter out alerts for unspecified triggers, comma separated list of trigger IDs.") @QueryParam(value="triggerIds") String triggerIds, @ApiParam(required=false, value="Filter out alerts for unspecified lifecycle status, comma separated list of status values.") @QueryParam(value="statuses") String statuses, @ApiParam(required=false, value="Filter out alerts for unspecified severity, comma separated list of severity values.") @QueryParam(value="severities") String severities, @ApiParam(required=false, value="Filter out events for unspecified tags, comma separated list of tags, each tag of format 'name|value'. Specify '*' for value to match all values.") @QueryParam(value="tags") String tags, @ApiParam(required=false, value="Return only thin alerts, do not include: evalSets, resolvedEvalSets.") @QueryParam(value="thin") Boolean thin, @Context UriInfo uri) {
        Pager pager = RequestUtil.extractPaging((UriInfo)uri);
        try {
            AlertsCriteria criteria = this.buildCriteria(startTime, endTime, alertIds, triggerIds, statuses, severities, tags, thin);
            Page alertPage = this.alertsService.getAlerts(this.tenantId, criteria, pager);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Alerts: " + alertPage));
            }
            if (this.isEmpty((Collection)alertPage)) {
                return ResponseUtil.ok((Object)alertPage);
            }
            return ResponseUtil.paginatedOk((Page)alertPage, (UriInfo)uri);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @PUT
    @Path(value="/ack/{alertId}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Set one alert Acknowledged.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Alert Acknowledged invoked successfully."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters.", response=ResponseUtil.ApiError.class)})
    public Response ackAlert(@ApiParam(required=true, value="The alertId to Ack.") @PathParam(value="alertId") String alertId, @ApiParam(required=false, value="User acknowledging the alerts.") @QueryParam(value="ackBy") String ackBy, @ApiParam(required=false, value="Additional notes associated with the acknowledgement.") @QueryParam(value="ackNotes") String ackNotes) {
        try {
            if (!this.isEmpty(alertId)) {
                this.alertsService.ackAlerts(this.tenantId, Arrays.asList(alertId), ackBy, ackNotes);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("AlertId: " + alertId));
                }
                return ResponseUtil.ok();
            }
            return ResponseUtil.badRequest((String)"AlertId required for ack");
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @PUT
    @Path(value="/note/{alertId}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Add a note into an existing Alert.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Alert Acknowledged invoked successfully."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters.", response=ResponseUtil.ApiError.class)})
    public Response addAlertNote(@ApiParam(required=true, value="The alertId to add the note.") @PathParam(value="alertId") String alertId, @ApiParam(required=false, value="Author of the note.") @QueryParam(value="user") String user, @ApiParam(required=false, value="Text of the note.") @QueryParam(value="text") String text) {
        try {
            if (!this.isEmpty(alertId)) {
                this.alertsService.addNote(this.tenantId, alertId, user, text);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("AlertId: " + alertId));
                }
                return ResponseUtil.ok();
            }
            return ResponseUtil.badRequest((String)"AlertId required for adding notes");
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @PUT
    @Path(value="/tags")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Add tags to existing Alerts.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Alerts tagged successfully."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters.", response=ResponseUtil.ApiError.class)})
    public Response addTags(@ApiParam(required=true, value="Comma separated list of alertIds to tag.") @QueryParam(value="alertIds") String alertIds, @ApiParam(required=true, value="Comma separated list of tags to add, each tag of format 'name|value'.") @QueryParam(value="tags") String tags) {
        try {
            if (!this.isEmpty(alertIds) || this.isEmpty(tags)) {
                AlertsCriteria c = this.buildCriteria(null, null, alertIds, null, null, null, tags, Boolean.valueOf(false));
                this.alertsService.addAlertTags(this.tenantId, c.getAlertIds(), c.getTags());
                if (this.log.isDebugEnabled()) {
                    this.log.debugf("Tagged alertIds:%s, %s", (Object)c.getAlertIds(), (Object)c.getTags());
                }
                return ResponseUtil.ok();
            }
            return ResponseUtil.badRequest((String)"AlertIds and Tags required for adding tags");
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @DELETE
    @Path(value="/tags")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Remove tags from existing Alerts.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Alerts untagged successfully."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters.", response=ResponseUtil.ApiError.class)})
    public Response deleteTags(@ApiParam(required=true, value="Comma separated list of alertIds to untag.") @QueryParam(value="alertIds") String alertIds, @ApiParam(required=true, value="Comma separated list of tag names to remove.") @QueryParam(value="tagNames") String tagNames) {
        try {
            if (!this.isEmpty(alertIds) || this.isEmpty(tagNames)) {
                List<String> ids = Arrays.asList(alertIds.split(","));
                List<String> tags = Arrays.asList(tagNames.split(","));
                this.alertsService.removeAlertTags(this.tenantId, ids, tags);
                if (this.log.isDebugEnabled()) {
                    this.log.debugf("Untagged alertIds:%s, %s", ids, tags);
                }
                return ResponseUtil.ok();
            }
            return ResponseUtil.badRequest((String)"AlertIds and Tags required for removing tags");
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @PUT
    @Path(value="/ack")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Set one or more alerts Acknowledged.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Alerts Acknowledged invoked successfully."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters", response=ResponseUtil.ApiError.class)})
    public Response ackAlerts(@ApiParam(required=true, value="Comma separated list of alertIds to Ack.") @QueryParam(value="alertIds") String alertIds, @ApiParam(required=false, value="User acknowledging the alerts.") @QueryParam(value="ackBy") String ackBy, @ApiParam(required=false, value="Additional notes asscoiated with the acknowledgement.") @QueryParam(value="ackNotes") String ackNotes) {
        try {
            if (!this.isEmpty(alertIds)) {
                this.alertsService.ackAlerts(this.tenantId, Arrays.asList(alertIds.split(",")), ackBy, ackNotes);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Acked alertIds: " + alertIds));
                }
                return ResponseUtil.ok();
            }
            return ResponseUtil.badRequest((String)"AlertIds required for ack");
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @DELETE
    @Path(value="/{alertId}")
    @ApiOperation(value="Delete an existing Alert.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Alert deleted."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=404, message="Alert not found.", response=ResponseUtil.ApiError.class)})
    public Response deleteAlert(@ApiParam(required=true, value="Alert id to be deleted.") @PathParam(value="alertId") String alertId) {
        try {
            AlertsCriteria criteria = new AlertsCriteria();
            criteria.setAlertId(alertId);
            int numDeleted = this.alertsService.deleteAlerts(this.tenantId, criteria);
            if (1 == numDeleted) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("AlertId: " + alertId));
                }
                return ResponseUtil.ok();
            }
            return ResponseUtil.notFound((String)("Alert " + alertId + " doesn't exist for delete"));
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @PUT
    @Path(value="/delete")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete alerts with optional filtering.", notes="Return number of alerts deleted.", response=Integer.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Alerts deleted."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class)})
    public Response deleteAlerts(@ApiParam(required=false, value="Filter out alerts created before this time, millisecond since epoch.") @QueryParam(value="startTime") Long startTime, @ApiParam(required=false, value="Filter out alerts created after this time, millisecond since epoch.") @QueryParam(value="endTime") Long endTime, @ApiParam(required=false, value="Filter out alerts for unspecified alertIds, comma separated list of alert IDs.") @QueryParam(value="alertIds") String alertIds, @ApiParam(required=false, value="Filter out alerts for unspecified triggers, comma separated list of trigger IDs.") @QueryParam(value="triggerIds") String triggerIds, @ApiParam(required=false, value="Filter out alerts for unspecified lifecycle status, comma separated list of status values.") @QueryParam(value="statuses") String statuses, @ApiParam(required=false, value="Filter out alerts for unspecified severity, comma separated list of severity values.") @QueryParam(value="severities") String severities, @ApiParam(required=false, value="Filter out alerts for unspecified tags, comma separated list of tags, each tag of format 'name|value'. Specify '*' for value to match all values.") @QueryParam(value="tags") String tags) {
        try {
            AlertsCriteria criteria = this.buildCriteria(startTime, endTime, alertIds, triggerIds, statuses, severities, tags, null);
            int numDeleted = this.alertsService.deleteAlerts(this.tenantId, criteria);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Alerts deleted: " + numDeleted));
            }
            return ResponseUtil.ok((Object)numDeleted);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    private AlertsCriteria buildCriteria(Long startTime, Long endTime, String alertIds, String triggerIds, String statuses, String severities, String tags, Boolean thin) {
        AlertsCriteria criteria = new AlertsCriteria();
        criteria.setStartTime(startTime);
        criteria.setEndTime(endTime);
        if (!this.isEmpty(alertIds)) {
            criteria.setAlertIds(Arrays.asList(alertIds.split(",")));
        }
        if (!this.isEmpty(triggerIds)) {
            criteria.setTriggerIds(Arrays.asList(triggerIds.split(",")));
        }
        if (!this.isEmpty(statuses)) {
            HashSet<Alert.Status> statusSet = new HashSet<Alert.Status>();
            for (String s : statuses.split(",")) {
                statusSet.add(Alert.Status.valueOf((String)s));
            }
            criteria.setStatusSet(statusSet);
        }
        if (null != severities && !severities.trim().isEmpty()) {
            HashSet<Severity> severitySet = new HashSet<Severity>();
            for (String s : severities.split(",")) {
                severitySet.add(Severity.valueOf((String)s));
            }
            criteria.setSeverities(severitySet);
        }
        if (!this.isEmpty(tags)) {
            String[] tagTokens = tags.split(",");
            HashMap<String, String> tagsMap = new HashMap<String, String>(tagTokens.length);
            for (String tagToken : tagTokens) {
                Object[] fields = tagToken.split("\\|");
                if (fields.length != 2) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Invalid Tag Criteria " + Arrays.toString(fields)));
                    }
                    throw new IllegalArgumentException("Invalid Tag Criteria " + Arrays.toString(fields));
                }
                tagsMap.put(fields[0], fields[1]);
            }
            criteria.setTags(tagsMap);
        }
        if (null != thin) {
            criteria.setThin(thin.booleanValue());
        }
        return criteria;
    }

    @GET
    @Path(value="/alert/{alertId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get an existing Alert.", response=Alert.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Alert found."), @ApiResponse(code=404, message="Alert not found.", response=ResponseUtil.ApiError.class), @ApiResponse(code=500, message="Internal server error", response=ResponseUtil.ApiError.class)})
    public Response getAlert(@ApiParam(value="Id of alert to be retrieved", required=true) @PathParam(value="alertId") String alertId, @ApiParam(required=false, value="Return only a thin alert, do not include: evalSets, resolvedEvalSets.") @QueryParam(value="thin") Boolean thin) {
        try {
            Alert found = this.alertsService.getAlert(this.tenantId, alertId, null == thin ? false : thin);
            if (found != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Alert: " + found));
                }
                return ResponseUtil.ok((Object)found);
            }
            return ResponseUtil.notFound((String)("alertId: " + alertId + " not found"));
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @PUT
    @Path(value="/resolve/{alertId}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Set one alert Resolved.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Alerts Resolution invoked successfully."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters", response=ResponseUtil.ApiError.class)})
    public Response resolveAlert(@ApiParam(required=true, value="The alertId to set resolved.") @PathParam(value="alertId") String alertId, @ApiParam(required=false, value="User resolving the alerts.") @QueryParam(value="resolvedBy") String resolvedBy, @ApiParam(required=false, value="Additional notes associated with the resolution.") @QueryParam(value="resolvedNotes") String resolvedNotes) {
        try {
            if (!this.isEmpty(alertId)) {
                this.alertsService.resolveAlerts(this.tenantId, Arrays.asList(alertId), resolvedBy, resolvedNotes, null);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("AlertId: " + alertId));
                }
                return ResponseUtil.ok();
            }
            return ResponseUtil.badRequest((String)"AlertsId required for resolve");
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @PUT
    @Path(value="/resolve")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Set one or more alerts resolved.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Alerts Resolution invoked successfully."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters", response=ResponseUtil.ApiError.class)})
    public Response resolveAlerts(@ApiParam(required=true, value="Comma separated list of alertIds to set resolved.") @QueryParam(value="alertIds") String alertIds, @ApiParam(required=false, value="User resolving the alerts.") @QueryParam(value="resolvedBy") String resolvedBy, @ApiParam(required=false, value="Additional notes associated with the resolution.") @QueryParam(value="resolvedNotes") String resolvedNotes) {
        try {
            if (!this.isEmpty(alertIds)) {
                this.alertsService.resolveAlerts(this.tenantId, Arrays.asList(alertIds.split(",")), resolvedBy, resolvedNotes, null);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("AlertsIds: " + alertIds));
                }
                return ResponseUtil.ok();
            }
            return ResponseUtil.badRequest((String)"AlertsIds required for resolve");
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @POST
    @Path(value="/data")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Send data for alert processing/condition evaluation.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, data added."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters", response=ResponseUtil.ApiError.class)})
    public Response sendData(@ApiParam(required=true, name="datums", value="Data to be processed by alerting.") Collection<Data> datums) {
        try {
            if (this.isEmpty(datums)) {
                return ResponseUtil.badRequest((String)"Data is empty");
            }
            for (Data d : datums) {
                d.setTenantId(this.tenantId);
            }
            this.alertsService.sendData(datums);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Datums: " + datums));
            }
            return ResponseUtil.ok();
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    private boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }
}

