/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.ejb.EJB;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.alerts.api.model.event.Event;
import org.hawkular.alerts.api.model.paging.Page;
import org.hawkular.alerts.api.model.paging.Pager;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.api.services.EventsCriteria;
import org.hawkular.alerts.rest.RequestUtil;
import org.hawkular.alerts.rest.ResponseUtil;
import org.jboss.logging.Logger;

@Path(value="/events")
@Api(value="/events", description="Event Handling")
public class EventsHandler {
    private final Logger log = Logger.getLogger(EventsHandler.class);
    @HeaderParam(value="Hawkular-Tenant")
    String tenantId;
    @EJB
    AlertsService alertsService;

    public EventsHandler() {
        this.log.debug((Object)"Creating instance.");
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new Event.", notes="Returns created Event.", response=Event.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Event Created."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters.", response=ResponseUtil.ApiError.class)})
    public Response createEvent(@ApiParam(value="Event to be created. Category and Text fields required,", name="event", required=true) Event event) {
        try {
            if (null != event) {
                if (this.isEmpty(event.getId())) {
                    return ResponseUtil.badRequest((String)"Event with id null.");
                }
                if (this.isEmpty(event.getCategory())) {
                    return ResponseUtil.badRequest((String)"Event with category null.");
                }
                event.setTenantId(this.tenantId);
                if (null != this.alertsService.getEvent(this.tenantId, event.getId(), true)) {
                    return ResponseUtil.badRequest((String)("Event with ID [" + event.getId() + "] exists."));
                }
                this.alertsService.addEvents(Collections.singletonList(event));
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Event: " + event.toString()));
                }
                return ResponseUtil.ok((Object)event);
            }
            return ResponseUtil.badRequest((String)"Event is null");
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.badRequest((String)("Bad arguments: " + e.getMessage()));
            }
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @PUT
    @Path(value="/tags")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Add tags to existing Events.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Events tagged successfully."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters.", response=ResponseUtil.ApiError.class)})
    public Response addTags(@ApiParam(required=true, value="Comma separated list of eventIds to tag.") @QueryParam(value="eventIds") String eventIds, @ApiParam(required=true, value="Comma separated list of tags to add, each tag of format 'name|value'.") @QueryParam(value="tags") String tags) {
        try {
            if (!this.isEmpty(eventIds) || this.isEmpty(tags)) {
                EventsCriteria c = this.buildCriteria(null, null, eventIds, null, null, tags, Boolean.valueOf(false));
                this.alertsService.addEventTags(this.tenantId, c.getEventIds(), c.getTags());
                if (this.log.isDebugEnabled()) {
                    this.log.debugf("Tagged alertIds:%s, %s", (Object)c.getEventIds(), (Object)c.getTags());
                }
                return ResponseUtil.ok();
            }
            return ResponseUtil.badRequest((String)"EventIds and Tags required for adding tags");
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.badRequest((String)("Bad arguments: " + e.getMessage()));
            }
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @DELETE
    @Path(value="/tags")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Remove tags from existing Events.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Events untagged successfully."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters.", response=ResponseUtil.ApiError.class)})
    public Response deleteTags(@ApiParam(required=true, value="Comma separated list of eventIds to untag.") @QueryParam(value="eventIds") String eventIds, @ApiParam(required=true, value="Comma separated list of tag names to remove.") @QueryParam(value="tagNames") String tagNames) {
        try {
            if (!this.isEmpty(eventIds) || this.isEmpty(tagNames)) {
                List<String> ids = Arrays.asList(eventIds.split(","));
                List<String> tags = Arrays.asList(tagNames.split(","));
                this.alertsService.removeEventTags(this.tenantId, ids, tags);
                if (this.log.isDebugEnabled()) {
                    this.log.debugf("Untagged eventIds:%s, %s", ids, tags);
                }
                return ResponseUtil.ok();
            }
            return ResponseUtil.badRequest((String)"EventIds and Tags required for removing tags");
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.badRequest((String)("Bad arguments: " + e.getMessage()));
            }
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get events with optional filtering.", response=Event.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched list of events."), @ApiResponse(code=400, message="Bad Request/Invalid Parameters."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class)})
    public Response findEvents(@ApiParam(required=false, value="Filter out events created before this time, millisecond since epoch.") @QueryParam(value="startTime") Long startTime, @ApiParam(required=false, value="Filter out events created after this time, millisecond since epoch.") @QueryParam(value="endTime") Long endTime, @ApiParam(required=false, value="Filter out events for unspecified eventIds, comma separated list of event IDs.") @QueryParam(value="eventIds") String eventIds, @ApiParam(required=false, value="Filter out events for unspecified triggers, comma separated list of trigger IDs.") @QueryParam(value="triggerIds") String triggerIds, @ApiParam(required=false, value="Filter out events for unspecified categories, comma separated list of category values.") @QueryParam(value="categories") String categories, @ApiParam(required=false, value="Filter out events for unspecified tags, comma separated list of tags, each tag of format 'name|value'. Specify '*' for value to match all values.") @QueryParam(value="tags") String tags, @ApiParam(required=false, value="Return only thin events, do not include: evalSets.") @QueryParam(value="thin") Boolean thin, @Context UriInfo uri) {
        Pager pager = RequestUtil.extractPaging((UriInfo)uri);
        try {
            EventsCriteria criteria = this.buildCriteria(startTime, endTime, eventIds, triggerIds, categories, tags, thin);
            Page eventPage = this.alertsService.getEvents(this.tenantId, criteria, pager);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Events: " + eventPage));
            }
            if (this.isEmpty((Collection)eventPage)) {
                return ResponseUtil.ok((Object)eventPage);
            }
            return ResponseUtil.paginatedOk((Page)eventPage, (UriInfo)uri);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.badRequest((String)("Bad arguments: " + e.getMessage()));
            }
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @DELETE
    @Path(value="/{eventId}")
    @ApiOperation(value="Delete an existing Event.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Event deleted."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=404, message="Event not found.", response=ResponseUtil.ApiError.class)})
    public Response deleteEvent(@ApiParam(required=true, value="Event id to be deleted.") @PathParam(value="eventId") String eventId) {
        try {
            EventsCriteria criteria = new EventsCriteria();
            criteria.setEventId(eventId);
            int numDeleted = this.alertsService.deleteEvents(this.tenantId, criteria);
            if (1 == numDeleted) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("EventId: " + eventId));
                }
                return ResponseUtil.ok();
            }
            return ResponseUtil.notFound((String)("Event " + eventId + " doesn't exist for delete"));
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @PUT
    @Path(value="/delete")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete events with optional filtering.", notes="Return number of events deleted.", response=Integer.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success."), @ApiResponse(code=400, message="Bad Request/Invalid Parameters."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class)})
    public Response deleteEvents(@ApiParam(required=false, value="Filter out events created before this time, millisecond since epoch.") @QueryParam(value="startTime") Long startTime, @ApiParam(required=false, value="Filter out events created after this time, millisecond since epoch.") @QueryParam(value="endTime") Long endTime, @ApiParam(required=false, value="Filter out events for unspecified eventIds, comma separated list of event IDs.") @QueryParam(value="eventIds") String eventIds, @ApiParam(required=false, value="Filter out events for unspecified triggers, comma separated list of trigger IDs.") @QueryParam(value="triggerIds") String triggerIds, @ApiParam(required=false, value="Filter out events for unspecified categories, comma separated list of category values.") @QueryParam(value="categories") String categories, @ApiParam(required=false, value="Filter out events for unspecified tags, comma separated list of tags, each tag of format 'name|value'. Specify '*' for value to match all values.") @QueryParam(value="tags") String tags) {
        try {
            EventsCriteria criteria = this.buildCriteria(startTime, endTime, eventIds, triggerIds, categories, tags, null);
            int numDeleted = this.alertsService.deleteEvents(this.tenantId, criteria);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Events deleted: " + numDeleted));
            }
            return ResponseUtil.ok((Object)numDeleted);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.badRequest((String)("Bad arguments: " + e.getMessage()));
            }
            return ResponseUtil.internalError((Exception)e);
        }
    }

    private EventsCriteria buildCriteria(Long startTime, Long endTime, String eventIds, String triggerIds, String categories, String tags, Boolean thin) {
        EventsCriteria criteria = new EventsCriteria();
        criteria.setStartTime(startTime);
        criteria.setEndTime(endTime);
        if (!this.isEmpty(eventIds)) {
            criteria.setEventIds(Arrays.asList(eventIds.split(",")));
        }
        if (!this.isEmpty(triggerIds)) {
            criteria.setTriggerIds(Arrays.asList(triggerIds.split(",")));
        }
        if (!this.isEmpty(categories)) {
            criteria.setCategories(Arrays.asList(categories.split(",")));
        }
        if (!this.isEmpty(tags)) {
            String[] tagTokens = tags.split(",");
            HashMap<String, String> tagsMap = new HashMap<String, String>(tagTokens.length);
            for (String tagToken : tagTokens) {
                Object[] fields = tagToken.split("\\|");
                if (fields.length == 2) {
                    tagsMap.put(fields[0], fields[1]);
                    continue;
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Invalid Tag Criteria " + Arrays.toString(fields)));
            }
            criteria.setTags(tagsMap);
        }
        if (null != thin) {
            criteria.setThin(thin.booleanValue());
        }
        return criteria;
    }

    @GET
    @Path(value="/event/{eventId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get an existing Event.", response=Event.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Event found."), @ApiResponse(code=404, message="Event not found.", response=ResponseUtil.ApiError.class), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class)})
    public Response getEvent(@ApiParam(value="Id of Event to be retrieved.", required=true) @PathParam(value="eventId") String eventId, @ApiParam(required=false, value="Return only a thin event, do not include: evalSets, dampening.") @QueryParam(value="thin") Boolean thin) {
        try {
            Event found = this.alertsService.getEvent(this.tenantId, eventId, null == thin ? false : thin);
            if (found != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Event: " + found));
                }
                return ResponseUtil.ok((Object)found);
            }
            return ResponseUtil.notFound((String)("eventId: " + eventId + " not found"));
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    private boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }
}

