/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.rest;

import io.swagger.annotations.Api;
import java.util.HashMap;
import javax.ejb.EJB;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.rest.ManifestUtil;
import org.hawkular.alerts.rest.ResponseUtil;

@Path(value="/status")
@Api(value="/status", description="Status of Alerts Service")
public class StatusHandler {
    private static final String STATUS = "status";
    private static final String STARTED = "STARTED";
    private static final String FAILED = "FAILED";
    @EJB
    DefinitionsService definitionsService;
    @Inject
    ManifestUtil manifestUtil;

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response status(@Context ServletContext servletContext) {
        HashMap<String, String> status = new HashMap<String, String>();
        status.putAll(this.manifestUtil.getFrom(servletContext));
        try {
            this.definitionsService.getActionPlugins();
            status.put(STATUS, STARTED);
        }
        catch (Exception e) {
            status.put(STATUS, FAILED);
        }
        return ResponseUtil.ok(status);
    }
}

