/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ejb.EJB;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.hawkular.alerts.api.model.export.Definitions;
import org.hawkular.alerts.api.model.export.ImportType;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.rest.ResponseUtil;
import org.jboss.logging.Logger;

@Path(value="/import")
@Api(value="/import", description="Import of triggers and actions definitions")
public class ImportHandler {
    private final Logger log = Logger.getLogger(ImportHandler.class);
    @HeaderParam(value="Hawkular-Tenant")
    String tenantId;
    @EJB
    DefinitionsService definitions;

    @POST
    @Path(value="/{strategy}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Import a list of full triggers and action definitions.", notes="Return a list of effectively imported full triggers and action definitions.", response=Definitions.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully exported list of full triggers and action definitions."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters", response=ResponseUtil.ApiError.class)})
    public Response importDefinitions(@ApiParam(value="Import strategy: DELETE, ALL, NEW or OLD (not case sensitive).", required=true) @PathParam(value="strategy") String strategy, @ApiParam(value="Collection of full triggers and action definitions to import.") Definitions definitions) {
        try {
            ImportType importType = ImportType.valueOf((String)strategy.toUpperCase());
            Definitions imported = this.definitions.importDefinitions(this.tenantId, definitions, importType);
            return ResponseUtil.ok((Object)imported);
        }
        catch (IllegalArgumentException e) {
            return ResponseUtil.badRequest((String)("Bad argument: " + e.getMessage()));
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }
}

