/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.rest;

import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.enterprise.context.ApplicationScoped;
import javax.servlet.ServletContext;

@ApplicationScoped
public class ManifestUtil {
    private static final String IMPLEMENTATION_VERSION = "Implementation-Version";
    private static final String BUILT_FROM_GIT = "Built-From-Git-SHA1";
    private static final List<String> VERSION_ATTRIBUTES = ImmutableList.of((Object)"Implementation-Version", (Object)"Built-From-Git-SHA1");
    private Map<String, String> manifestInformation = new HashMap();

    public Map<String, String> getFrom(ServletContext servletContext) {
        if (!this.manifestInformation.containsKey(IMPLEMENTATION_VERSION) && !this.manifestInformation.containsKey(BUILT_FROM_GIT)) {
            try (InputStream inputStream = servletContext.getResourceAsStream("/META-INF/MANIFEST.MF");){
                Manifest manifest = new Manifest(inputStream);
                Attributes attr = manifest.getMainAttributes();
                for (String attribute : VERSION_ATTRIBUTES) {
                    this.manifestInformation.put(attribute, attr.getValue(attribute));
                }
            }
            catch (Exception e) {
                for (String attribute : VERSION_ATTRIBUTES) {
                    if (this.manifestInformation.get(attribute) != null) continue;
                    this.manifestInformation.put(attribute, "Unknown");
                }
            }
        }
        return this.manifestInformation;
    }
}

