/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.alerts.api.exception.NotFoundException;
import org.hawkular.alerts.api.json.GroupConditionsInfo;
import org.hawkular.alerts.api.json.GroupMemberInfo;
import org.hawkular.alerts.api.json.UnorphanMemberInfo;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.paging.Page;
import org.hawkular.alerts.api.model.paging.Pager;
import org.hawkular.alerts.api.model.trigger.FullTrigger;
import org.hawkular.alerts.api.model.trigger.Mode;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.api.services.TriggersCriteria;
import org.hawkular.alerts.rest.RequestUtil;
import org.hawkular.alerts.rest.ResponseUtil;
import org.hawkular.alerts.rest.TriggersHandler;
import org.jboss.logging.Logger;

@Path(value="/triggers")
@Api(value="/triggers", description="Trigger Handling")
public class TriggersHandler {
    private static final Logger log = Logger.getLogger(TriggersHandler.class);
    @HeaderParam(value="Hawkular-Tenant")
    String tenantId;
    @EJB
    DefinitionsService definitions;

    public TriggersHandler() {
        log.debug((Object)"Creating instance.");
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get triggers with optional filtering.", response=Trigger.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched list of triggers."), @ApiResponse(code=400, message="Bad request/Invalid Parameters.", response=ResponseUtil.ApiError.class), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class)})
    public Response findTriggers(@ApiParam(required=false, value="Filter out triggers for unspecified triggerIds, comma separated list of trigger IDs.") @QueryParam(value="triggerIds") String triggerIds, @ApiParam(required=false, value="Filter out triggers for unspecified tags, comma separated list of tags, each tag of format 'name|value'. Specify '*' for value to match all values.") @QueryParam(value="tags") String tags, @ApiParam(required=false, value="Return only thin triggers. Currently Ignored.") @QueryParam(value="thin") Boolean thin, @Context UriInfo uri) {
        Pager pager = RequestUtil.extractPaging((UriInfo)uri);
        try {
            TriggersCriteria criteria = this.buildCriteria(triggerIds, tags, thin);
            Page triggerPage = this.definitions.getTriggers(this.tenantId, criteria, pager);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Triggers: " + triggerPage));
            }
            if (this.isEmpty((Collection)triggerPage)) {
                return ResponseUtil.ok((Object)triggerPage);
            }
            return ResponseUtil.paginatedOk((Page)triggerPage, (UriInfo)uri);
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.badRequest((String)("Bad arguments: " + e.getMessage()));
            }
            return ResponseUtil.internalError((Exception)e);
        }
    }

    private TriggersCriteria buildCriteria(String triggerIds, String tags, Boolean thin) {
        TriggersCriteria criteria = new TriggersCriteria();
        if (!this.isEmpty(triggerIds)) {
            criteria.setTriggerIds(Arrays.asList(triggerIds.split(",")));
        }
        if (!this.isEmpty(tags)) {
            String[] tagTokens = tags.split(",");
            HashMap<String, String> tagsMap = new HashMap<String, String>(tagTokens.length);
            for (String tagToken : tagTokens) {
                Object[] fields = tagToken.split("\\|");
                if (fields.length != 2) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Invalid Tag Criteria " + Arrays.toString(fields)));
                    }
                    throw new IllegalArgumentException("Invalid Tag Criteria " + Arrays.toString(fields));
                }
                tagsMap.put(fields[0], fields[1]);
            }
            criteria.setTags(tagsMap);
        }
        if (null != thin) {
            criteria.setThin(thin.booleanValue());
        }
        return criteria;
    }

    @GET
    @Path(value="/groups/{groupId}/members")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all Group Member Trigger Definitions.", notes="Pagination is not yet implemented.", response=Trigger.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched list of triggers."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class)})
    public Response findGroupMembers(@ApiParam(value="Group TriggerId.", required=true) @PathParam(value="groupId") String groupId, @ApiParam(value="include Orphan members? No if omitted.", required=false) @QueryParam(value="includeOrphans") boolean includeOrphans) {
        try {
            Collection members = this.definitions.getMemberTriggers(this.tenantId, groupId, includeOrphans);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Member Triggers: " + members));
            }
            return ResponseUtil.ok((Object)members);
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new trigger.", notes="Return created trigger.", response=Trigger.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Trigger created."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters", response=ResponseUtil.ApiError.class)})
    public Response createTrigger(@ApiParam(value="Trigger definition to be created.", name="trigger", required=true) Trigger trigger) {
        try {
            if (null != trigger) {
                if (this.isEmpty(trigger.getId())) {
                    trigger.setId(Trigger.generateId());
                } else if (this.definitions.getTrigger(this.tenantId, trigger.getId()) != null) {
                    return ResponseUtil.badRequest((String)("Trigger with ID [" + trigger.getId() + "] exists."));
                }
                this.definitions.addTrigger(this.tenantId, trigger);
                log.debug((Object)("Trigger: " + trigger.toString()));
                return ResponseUtil.ok((Object)trigger);
            }
            return ResponseUtil.badRequest((String)"Trigger is null");
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.badRequest((String)("Bad arguments: " + e.getMessage()));
            }
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @POST
    @Path(value="/trigger")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new full trigger (trigger, dampenings and conditions).", notes="Return created full trigger.", response=FullTrigger.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, FullTrigger created."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters.", response=ResponseUtil.ApiError.class)})
    public Response createFullTrigger(@ApiParam(value="FullTrigger (trigger, dampenings, conditions) to be created.", name="fullTrigger", required=true) FullTrigger fullTrigger) {
        if (fullTrigger == null || fullTrigger.getTrigger() == null) {
            return ResponseUtil.badRequest((String)"Trigger is empty ");
        }
        try {
            List autoResolveConditions;
            Trigger trigger = fullTrigger.getTrigger();
            trigger.setTenantId(this.tenantId);
            if (this.isEmpty(trigger.getId())) {
                trigger.setId(Trigger.generateId());
            } else if (this.definitions.getTrigger(this.tenantId, trigger.getId()) != null) {
                return ResponseUtil.badRequest((String)("Trigger with ID [" + trigger.getId() + "] exists."));
            }
            this.definitions.addTrigger(this.tenantId, trigger);
            log.debug((Object)("Trigger: " + trigger.toString()));
            for (Dampening dampening : fullTrigger.getDampenings()) {
                boolean exist;
                dampening.setTenantId(this.tenantId);
                dampening.setTriggerId(trigger.getId());
                boolean bl = exist = this.definitions.getDampening(this.tenantId, dampening.getDampeningId()) != null;
                if (exist) {
                    this.definitions.removeDampening(this.tenantId, dampening.getDampeningId());
                }
                this.definitions.addDampening(this.tenantId, dampening);
                log.debug((Object)("Dampening: " + dampening.toString()));
            }
            fullTrigger.getConditions().stream().forEach(c -> {
                c.setTenantId(this.tenantId);
                c.setTriggerId(trigger.getId());
            });
            List firingConditions = fullTrigger.getConditions().stream().filter(c -> c.getTriggerMode() == Mode.FIRING).collect(Collectors.toList());
            if (firingConditions != null && !firingConditions.isEmpty()) {
                this.definitions.setConditions(this.tenantId, trigger.getId(), Mode.FIRING, firingConditions);
                log.debug((Object)("Conditions: " + firingConditions));
            }
            if ((autoResolveConditions = fullTrigger.getConditions().stream().filter(c -> c.getTriggerMode() == Mode.AUTORESOLVE).collect(Collectors.toList())) != null && !autoResolveConditions.isEmpty()) {
                this.definitions.setConditions(this.tenantId, trigger.getId(), Mode.AUTORESOLVE, autoResolveConditions);
                log.debug((Object)("Conditions:" + autoResolveConditions));
            }
            return ResponseUtil.ok((Object)fullTrigger);
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.badRequest((String)("Bad arguments: " + e.getMessage()));
            }
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @POST
    @Path(value="/groups")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new group trigger.", notes="Returns created group trigger.", response=Trigger.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Group Trigger Created."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters.", response=ResponseUtil.ApiError.class)})
    public Response createGroupTrigger(@ApiParam(value="Trigger definition to be created.", name="groupTrigger", required=true) Trigger groupTrigger) {
        try {
            if (null != groupTrigger) {
                if (this.isEmpty(groupTrigger.getId())) {
                    groupTrigger.setId(Trigger.generateId());
                } else if (this.definitions.getTrigger(this.tenantId, groupTrigger.getId()) != null) {
                    return ResponseUtil.badRequest((String)("Trigger with ID [" + groupTrigger.getId() + "] exists."));
                }
                this.definitions.addGroupTrigger(this.tenantId, groupTrigger);
                log.debug((Object)("Group Trigger: " + groupTrigger.toString()));
                return ResponseUtil.ok((Object)groupTrigger);
            }
            return ResponseUtil.badRequest((String)"Trigger is null");
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.badRequest((String)("Bad arguments: " + e.getMessage()));
            }
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @POST
    @Path(value="/groups/members")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new member trigger for a parent trigger.", notes="Returns Member Trigger created if operation finished correctly.", response=Trigger.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Member Trigger Created."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=404, message="Group trigger not found.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters.", response=ResponseUtil.ApiError.class)})
    public Response createGroupMember(@ApiParam(value="Group member trigger to be created.", name="groupMember", required=true) GroupMemberInfo groupMember) {
        try {
            if (null == groupMember) {
                return ResponseUtil.badRequest((String)"MemberTrigger is null");
            }
            String groupId = groupMember.getGroupId();
            if (this.isEmpty(groupId)) {
                return ResponseUtil.badRequest((String)"MemberTrigger groupId is null");
            }
            Trigger child = this.definitions.addMemberTrigger(this.tenantId, groupId, groupMember.getMemberId(), groupMember.getMemberName(), groupMember.getMemberDescription(), groupMember.getMemberContext(), groupMember.getMemberTags(), groupMember.getDataIdMap());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Child Trigger: " + child.toString()));
            }
            return ResponseUtil.ok((Object)child);
        }
        catch (NotFoundException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.notFound((String)e.getMessage());
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.badRequest((String)("Bad arguments: " + e.getMessage()));
            }
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @GET
    @Path(value="/{triggerId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get an existing trigger definition.", response=Trigger.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Trigger found."), @ApiResponse(code=404, message="Trigger not found.", response=ResponseUtil.ApiError.class), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class)})
    public Response getTrigger(@ApiParam(value="Trigger definition id to be retrieved.", required=true) @PathParam(value="triggerId") String triggerId) {
        try {
            Trigger found = this.definitions.getTrigger(this.tenantId, triggerId);
            if (found != null) {
                log.debug((Object)("Trigger: " + found));
                return ResponseUtil.ok((Object)found);
            }
            return ResponseUtil.notFound((String)("triggerId: " + triggerId + " not found"));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @GET
    @Path(value="/trigger/{triggerId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get an existing full trigger definition (trigger, dampenings and conditions).", response=FullTrigger.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, FullTrigger found."), @ApiResponse(code=404, message="Trigger not found.", response=ResponseUtil.ApiError.class), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class)})
    public Response getFullTrigger(@ApiParam(value="Full Trigger definition id to be retrieved.", required=true) @PathParam(value="triggerId") String triggerId) {
        try {
            Trigger found = this.definitions.getTrigger(this.tenantId, triggerId);
            if (found != null) {
                log.debug((Object)("Trigger: " + found));
                ArrayList dampenings = new ArrayList(this.definitions.getTriggerDampenings(this.tenantId, found.getId(), null));
                ArrayList conditions = new ArrayList(this.definitions.getTriggerConditions(this.tenantId, found.getId(), null));
                FullTrigger fullTrigger = new FullTrigger(found, dampenings, conditions);
                return ResponseUtil.ok((Object)fullTrigger);
            }
            return ResponseUtil.notFound((String)("triggerId: " + triggerId + " not found"));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @PUT
    @Path(value="/{triggerId}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update an existing trigger definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Trigger updated."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters.", response=ResponseUtil.ApiError.class), @ApiResponse(code=404, message="Trigger doesn't exist.", response=ResponseUtil.ApiError.class)})
    public Response updateTrigger(@ApiParam(value="Trigger definition id to be updated.", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Updated trigger definition.", name="trigger", required=true) Trigger trigger) {
        try {
            if (trigger != null && !this.isEmpty(triggerId)) {
                trigger.setId(triggerId);
            }
            this.definitions.updateTrigger(this.tenantId, trigger);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trigger: " + trigger));
            }
            return ResponseUtil.ok();
        }
        catch (NotFoundException e) {
            return ResponseUtil.notFound((String)("Trigger " + triggerId + " doesn't exist for update"));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.badRequest((String)("Bad arguments: " + e.getMessage()));
            }
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @PUT
    @Path(value="/groups/{groupId}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update an existing group trigger definition and its member definitions.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Group Trigger updated."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters.", response=ResponseUtil.ApiError.class), @ApiResponse(code=404, message="Trigger doesn't exist.", response=ResponseUtil.ApiError.class)})
    public Response updateGroupTrigger(@ApiParam(value="Group Trigger id to be updated.", required=true) @PathParam(value="groupId") String groupId, @ApiParam(value="Updated group trigger definition.", name="groupTrigger", required=true) Trigger groupTrigger) {
        try {
            if (groupTrigger != null && !this.isEmpty(groupId)) {
                groupTrigger.setId(groupId);
            }
            this.definitions.updateGroupTrigger(this.tenantId, groupTrigger);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trigger: " + groupTrigger));
            }
            return ResponseUtil.ok();
        }
        catch (NotFoundException e) {
            return ResponseUtil.notFound((String)("Trigger " + groupId + " doesn't exist for update"));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.badRequest((String)("Bad arguments: " + e.getMessage()));
            }
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @POST
    @Path(value="/groups/members/{memberId}/orphan")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Make a non-orphan member trigger into an orphan.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Trigger updated."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=404, message="Trigger doesn't exist/Invalid Parameters.", response=ResponseUtil.ApiError.class)})
    public Response orphanMemberTrigger(@ApiParam(value="Member Trigger id to be made an orphan.", required=true) @PathParam(value="memberId") String memberId) {
        try {
            Trigger child = this.definitions.orphanMemberTrigger(this.tenantId, memberId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Orphan Member Trigger: " + child));
            }
            return ResponseUtil.ok();
        }
        catch (NotFoundException e) {
            return ResponseUtil.notFound((String)("Member Trigger " + memberId + " doesn't exist for update"));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @POST
    @Path(value="/groups/members/{memberId}/unorphan")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Make a non-orphan member trigger into an orphan.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Trigger updated."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters.", response=ResponseUtil.ApiError.class), @ApiResponse(code=404, message="Trigger doesn't exist.", response=ResponseUtil.ApiError.class)})
    public Response unorphanMemberTrigger(@ApiParam(value="Member Trigger id to be made an orphan.", required=true) @PathParam(value="memberId") String memberId, @ApiParam(required=true, name="memberTrigger", value="Only context and dataIdMap are used when changing back to a non-orphan.") UnorphanMemberInfo unorphanMemberInfo) {
        try {
            if (null == unorphanMemberInfo) {
                return ResponseUtil.badRequest((String)"MemberTrigger is null");
            }
            Trigger child = this.definitions.unorphanMemberTrigger(this.tenantId, memberId, unorphanMemberInfo.getMemberContext(), unorphanMemberInfo.getMemberTags(), unorphanMemberInfo.getDataIdMap());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Member Trigger: " + child));
            }
            return ResponseUtil.ok();
        }
        catch (NotFoundException e) {
            return ResponseUtil.notFound((String)("Member Trigger " + memberId + " doesn't exist for update"));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.badRequest((String)("Bad arguments: " + e.getMessage()));
            }
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @DELETE
    @Path(value="/{triggerId}")
    @ApiOperation(value="Delete an existing standard or group member trigger definition. This can not be used to delete a group trigger definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Trigger deleted."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=404, message="Trigger not found.", response=ResponseUtil.ApiError.class)})
    public Response deleteTrigger(@ApiParam(value="Trigger definition id to be deleted.", required=true) @PathParam(value="triggerId") String triggerId) {
        try {
            this.definitions.removeTrigger(this.tenantId, triggerId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("TriggerId: " + triggerId));
            }
            return ResponseUtil.ok();
        }
        catch (NotFoundException e) {
            return ResponseUtil.notFound((String)("Trigger " + triggerId + " doesn't exist for delete"));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @DELETE
    @Path(value="/groups/{groupId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete a group trigger.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Group Trigger Removed."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=404, message="Group Trigger not found.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters.", response=ResponseUtil.ApiError.class)})
    public Response deleteGroupTrigger(@ApiParam(required=true, value="Group Trigger id.") @PathParam(value="groupId") String groupId, @ApiParam(required=true, value="Convert the non-orphan member triggers to standard triggers.") @QueryParam(value="keepNonOrphans") boolean keepNonOrphans, @ApiParam(required=true, value="Convert the orphan member triggers to standard triggers.") @QueryParam(value="keepOrphans") boolean keepOrphans) {
        try {
            this.definitions.removeGroupTrigger(this.tenantId, groupId, keepNonOrphans, keepOrphans);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remove Group Trigger: " + this.tenantId + "/" + groupId));
            }
            return ResponseUtil.ok();
        }
        catch (NotFoundException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.notFound((String)e.getMessage());
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @GET
    @Path(value="/{triggerId}/dampenings")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all Dampenings for a Trigger (1 Dampening per mode).", response=Dampening.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched list of dampenings."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class)})
    public Response getTriggerDampenings(@ApiParam(value="Trigger definition id to be retrieved.", required=true) @PathParam(value="triggerId") String triggerId) {
        try {
            Collection dampenings = this.definitions.getTriggerDampenings(this.tenantId, triggerId, null);
            log.debug((Object)("Dampenings: " + dampenings));
            return ResponseUtil.ok((Object)dampenings);
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @GET
    @Path(value="/{triggerId}/dampenings/mode/{triggerMode}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get dampening using triggerId and triggerMode.", response=Dampening.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched list of dampenings."), @ApiResponse(code=400, message="Bad Request/Invalid Parameters.", response=ResponseUtil.ApiError.class), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class)})
    public Response getTriggerModeDampenings(@ApiParam(value="Trigger definition id to be retrieved.", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Trigger mode", required=true) @PathParam(value="triggerMode") Mode triggerMode) {
        try {
            Collection dampenings = this.definitions.getTriggerDampenings(this.tenantId, triggerId, triggerMode);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Dampenings: " + dampenings));
            }
            return ResponseUtil.ok((Object)dampenings);
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.badRequest((String)("Bad arguments: " + e.getMessage()));
            }
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @GET
    @Path(value="/{triggerId}/dampenings/{dampeningId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get an existing dampening.", response=Dampening.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampening Found."), @ApiResponse(code=404, message="No Dampening Found.", response=ResponseUtil.ApiError.class), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class)})
    public Response getDampening(@ApiParam(value="Trigger definition id to be retrieved.", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Dampening id", required=true) @PathParam(value="dampeningId") String dampeningId) {
        try {
            Dampening found = this.definitions.getDampening(this.tenantId, dampeningId);
            log.debug((Object)("Dampening: " + found));
            if (found == null) {
                return ResponseUtil.notFound((String)("No dampening found for triggerId: " + triggerId + " and dampeningId:" + dampeningId));
            }
            return ResponseUtil.ok((Object)found);
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @POST
    @Path(value="/{triggerId}/dampenings")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new dampening.", notes="Return Dampening created.", response=Dampening.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampening created."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters.", response=ResponseUtil.ApiError.class)})
    public Response createDampening(@ApiParam(value="Trigger definition id attached to dampening.", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Dampening definition to be created.", required=true) Dampening dampening) {
        try {
            boolean exists;
            dampening.setTenantId(this.tenantId);
            dampening.setTriggerId(triggerId);
            boolean bl = exists = this.definitions.getDampening(this.tenantId, dampening.getDampeningId()) != null;
            if (!exists) {
                Dampening d = this.getCleanDampening(dampening);
                this.definitions.addDampening(this.tenantId, d);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Dampening: " + d));
                }
                return ResponseUtil.ok((Object)d);
            }
            return ResponseUtil.badRequest((String)("Existing dampening for dampeningId: " + dampening.getDampeningId()));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.badRequest((String)("Bad arguments: " + e.getMessage()));
            }
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @POST
    @Path(value="/groups/{groupId}/dampenings")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new group dampening.", notes=" Return group Dampening created.", response=Dampening.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampening created."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters", response=ResponseUtil.ApiError.class)})
    public Response createGroupDampening(@ApiParam(value="Group Trigger definition id attached to dampening.", required=true) @PathParam(value="groupId") String groupId, @ApiParam(value="Dampening definition to be created.", required=true) Dampening dampening) {
        try {
            boolean exists;
            dampening.setTriggerId(groupId);
            boolean bl = exists = this.definitions.getDampening(this.tenantId, dampening.getDampeningId()) != null;
            if (!exists) {
                Dampening d = this.getCleanDampening(dampening);
                this.definitions.addGroupDampening(this.tenantId, d);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Dampening: " + d));
                }
                return ResponseUtil.ok((Object)d);
            }
            return ResponseUtil.badRequest((String)("Existing dampening for dampeningId: " + dampening.getDampeningId()));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.badRequest((String)("Bad arguments: " + e.getMessage()));
            }
            return ResponseUtil.internalError((Exception)e);
        }
    }

    private Dampening getCleanDampening(Dampening dampening) throws Exception {
        switch (1.$SwitchMap$org$hawkular$alerts$api$model$dampening$Dampening$Type[dampening.getType().ordinal()]) {
            case 1: {
                return Dampening.forStrict((String)dampening.getTenantId(), (String)dampening.getTriggerId(), (Mode)dampening.getTriggerMode(), (int)dampening.getEvalTrueSetting());
            }
            case 2: {
                return Dampening.forStrictTime((String)dampening.getTenantId(), (String)dampening.getTriggerId(), (Mode)dampening.getTriggerMode(), (long)dampening.getEvalTimeSetting());
            }
            case 3: {
                return Dampening.forStrictTimeout((String)dampening.getTenantId(), (String)dampening.getTriggerId(), (Mode)dampening.getTriggerMode(), (long)dampening.getEvalTimeSetting());
            }
            case 4: {
                return Dampening.forRelaxedCount((String)dampening.getTenantId(), (String)dampening.getTriggerId(), (Mode)dampening.getTriggerMode(), (int)dampening.getEvalTrueSetting(), (int)dampening.getEvalTotalSetting());
            }
            case 5: {
                return Dampening.forRelaxedTime((String)dampening.getTenantId(), (String)dampening.getTriggerId(), (Mode)dampening.getTriggerMode(), (int)dampening.getEvalTrueSetting(), (long)dampening.getEvalTimeSetting());
            }
        }
        throw new Exception("Unhandled Dampening Type: " + dampening.toString());
    }

    @PUT
    @Path(value="/{triggerId}/dampenings/{dampeningId}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update an existing dampening definition.", notes="Note that the trigger mode can not be changed. Return Dampening updated.", response=Dampening.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampening Updated."), @ApiResponse(code=400, message="Bad Request/Invalid Parameters.", response=ResponseUtil.ApiError.class), @ApiResponse(code=404, message="No Dampening Found.", response=ResponseUtil.ApiError.class), @ApiResponse(code=500, message="Internal server error", response=ResponseUtil.ApiError.class)})
    public Response updateDampening(@ApiParam(value="Trigger definition id to be retrieved.", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Dampening id.", required=true) @PathParam(value="dampeningId") String dampeningId, @ApiParam(value="Updated dampening definition", required=true) Dampening dampening) {
        try {
            boolean exists;
            boolean bl = exists = this.definitions.getDampening(this.tenantId, dampeningId) != null;
            if (exists) {
                Dampening d = this.getCleanDampening(dampening);
                this.definitions.updateDampening(this.tenantId, d);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Dampening: " + d));
                }
                return ResponseUtil.ok((Object)d);
            }
            return ResponseUtil.notFound((String)("No dampening found for dampeningId: " + dampeningId));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.badRequest((String)("Bad arguments: " + e.getMessage()));
            }
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @PUT
    @Path(value="/groups/{groupId}/dampenings/{dampeningId}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update an existing group dampening definition.", notes="Note that the trigger mode can not be changed. Return Dampening updated.", response=Dampening.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampening Updated."), @ApiResponse(code=400, message="Bad Request/Invalid Parameters.", response=ResponseUtil.ApiError.class), @ApiResponse(code=404, message="No Dampening Found.", response=ResponseUtil.ApiError.class), @ApiResponse(code=500, message="Internal server error", response=ResponseUtil.ApiError.class)})
    public Response updateGroupDampening(@ApiParam(value="Trigger definition id to be retrieved.", required=true) @PathParam(value="groupId") String groupId, @ApiParam(value="Dampening id.", required=true) @PathParam(value="dampeningId") String dampeningId, @ApiParam(value="Updated dampening definition.", required=true) Dampening dampening) {
        try {
            boolean exists;
            boolean bl = exists = this.definitions.getDampening(this.tenantId, dampeningId) != null;
            if (exists) {
                Dampening d = this.getCleanDampening(dampening);
                this.definitions.updateGroupDampening(this.tenantId, d);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Group Dampening: " + d));
                }
                return ResponseUtil.ok((Object)d);
            }
            return ResponseUtil.notFound((String)("No dampening found for dampeningId: " + dampeningId));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.badRequest((String)("Bad arguments: " + e.getMessage()));
            }
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @DELETE
    @Path(value="/{triggerId}/dampenings/{dampeningId}")
    @ApiOperation(value="Delete an existing dampening definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampening deleted."), @ApiResponse(code=404, message="No Dampening found.", response=ResponseUtil.ApiError.class), @ApiResponse(code=500, message="Internal server error", response=ResponseUtil.ApiError.class)})
    public Response deleteDampening(@ApiParam(value="Trigger definition id to be deleted.", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Dampening id for dampening definition to be deleted.", required=true) @PathParam(value="dampeningId") String dampeningId) {
        try {
            boolean exists;
            boolean bl = exists = this.definitions.getDampening(this.tenantId, dampeningId) != null;
            if (exists) {
                this.definitions.removeDampening(this.tenantId, dampeningId);
                log.debug((Object)("DampeningId: " + dampeningId));
                return ResponseUtil.ok();
            }
            return ResponseUtil.notFound((String)("Dampening not found for dampeningId: " + dampeningId));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @DELETE
    @Path(value="/groups/{groupId}/dampenings/{dampeningId}")
    @ApiOperation(value="Delete an existing group dampening definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampening deleted."), @ApiResponse(code=404, message="No Dampening found.", response=ResponseUtil.ApiError.class), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class)})
    public Response deleteGroupDampening(@ApiParam(value="Trigger definition id to be retrieved.", required=true) @PathParam(value="groupId") String groupId, @ApiParam(value="Dampening id for dampening definition to be deleted.", required=true) @PathParam(value="dampeningId") String dampeningId) {
        try {
            boolean exists;
            boolean bl = exists = this.definitions.getDampening(this.tenantId, dampeningId) != null;
            if (exists) {
                this.definitions.removeGroupDampening(this.tenantId, dampeningId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Group DampeningId: " + dampeningId));
                }
                return ResponseUtil.ok();
            }
            return ResponseUtil.notFound((String)("Dampening not found for dampeningId: " + dampeningId));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @GET
    @Path(value="/{triggerId}/conditions")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all conditions for a specific trigger.", response=Condition.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched list of conditions."), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class)})
    public Response getTriggerConditions(@ApiParam(value="Trigger definition id to be retrieved.", required=true) @PathParam(value="triggerId") String triggerId) {
        try {
            Collection conditions = this.definitions.getTriggerConditions(this.tenantId, triggerId, null);
            log.debug((Object)("Conditions: " + conditions));
            return ResponseUtil.ok((Object)conditions);
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @GET
    @Path(value="/{triggerId}/conditions/{conditionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="@Deprecated : Get Condition by conditionId.", notes="Use GET /alerts/triggers/{triggerId}/conditions .", response=Condition.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Condition found."), @ApiResponse(code=404, message="No Condition found.", response=ResponseUtil.ApiError.class), @ApiResponse(code=500, message="Internal server error,", response=ResponseUtil.ApiError.class)})
    @Deprecated
    public Response getTriggerCondition(@ApiParam(value="Trigger definition id to be retrieved.", required=true) @PathParam(value="triggerId") String triggerId, @PathParam(value="conditionId") String conditionId) {
        try {
            Trigger trigger = this.definitions.getTrigger(this.tenantId, triggerId);
            if (trigger == null) {
                return ResponseUtil.notFound((String)("No trigger found for triggerId: " + triggerId));
            }
            Condition found = this.definitions.getCondition(this.tenantId, conditionId);
            if (found == null) {
                return ResponseUtil.notFound((String)("No condition found for conditionId: " + conditionId));
            }
            if (!found.getTriggerId().equals(triggerId)) {
                return ResponseUtil.notFound((String)("ConditionId: " + conditionId + " does not belong to triggerId: " + triggerId));
            }
            return ResponseUtil.ok((Object)found);
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @PUT
    @Path(value="/{triggerId}/conditions/{triggerMode}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Set the conditions for the trigger. ", notes="This replaces any existing conditions. Returns the new conditions.", response=Condition.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Condition Set created."), @ApiResponse(code=404, message="No trigger found.", response=ResponseUtil.ApiError.class), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters", response=ResponseUtil.ApiError.class)})
    public Response setConditions(@ApiParam(value="The relevant Trigger.", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="FIRING or AUTORESOLVE (not case sensitive).", required=true) @PathParam(value="triggerMode") String triggerMode, @ApiParam(value="Collection of Conditions to set.", required=true) Collection<Condition> conditions) {
        try {
            Mode mode = Mode.valueOf((String)triggerMode.toUpperCase());
            if (!this.isEmpty(conditions)) {
                for (Condition condition : conditions) {
                    condition.setTriggerId(triggerId);
                    condition.setTriggerMode(mode);
                }
            }
            Collection updatedConditions = this.definitions.setConditions(this.tenantId, triggerId, mode, conditions);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Conditions: " + updatedConditions));
            }
            return ResponseUtil.ok((Object)updatedConditions);
        }
        catch (NotFoundException e) {
            return ResponseUtil.notFound((String)e.getMessage());
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.badRequest((String)("Bad arguments: " + e.getMessage()));
            }
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @PUT
    @Path(value="/groups/{groupId}/conditions/{triggerMode}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Set the conditions for the group trigger.", notes="This replaces any existing conditions on the group and member conditions. Return the new group conditions.", response=Condition.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Group Condition Set created."), @ApiResponse(code=404, message="No trigger found.", response=ResponseUtil.ApiError.class), @ApiResponse(code=500, message="Internal server error", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters", response=ResponseUtil.ApiError.class)})
    public Response setGroupConditions(@ApiParam(value="The relevant Group Trigger.", required=true) @PathParam(value="groupId") String groupId, @ApiParam(value="FIRING or AUTORESOLVE (not case sensitive).", required=true) @PathParam(value="triggerMode") String triggerMode, @ApiParam(value="Collection of Conditions to set and Map with tokens per dataId on members.") GroupConditionsInfo groupConditionsInfo) {
        try {
            Mode mode = Mode.valueOf((String)triggerMode.toUpperCase());
            for (Condition condition : groupConditionsInfo.getConditions()) {
                if (condition == null) {
                    return ResponseUtil.badRequest((String)("GroupConditionsInfo must have non null conditions: " + groupConditionsInfo));
                }
                condition.setTriggerId(groupId);
                condition.setTriggerMode(mode);
            }
            Collection conditions = this.definitions.setGroupConditions(this.tenantId, groupId, mode, groupConditionsInfo.getConditions(), groupConditionsInfo.getDataIdMemberMap());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Conditions: " + conditions));
            }
            return ResponseUtil.ok((Object)conditions);
        }
        catch (IllegalArgumentException e) {
            return ResponseUtil.badRequest((String)("Bad trigger mode: " + triggerMode));
        }
        catch (NotFoundException e) {
            return ResponseUtil.notFound((String)e.getMessage());
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.badRequest((String)("Bad arguments: " + e.getMessage()));
            }
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @POST
    @Path(value="/{triggerId}/conditions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="@Deprecated : Add a condition.", notes="Use PUT /alerts/triggers/{triggerId}/conditions to set the entire condition set in one service. Return the updated collection of Conditions for a trigger.", response=Condition.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched list of conditions."), @ApiResponse(code=404, message="No trigger found.", response=ResponseUtil.ApiError.class), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters.", response=ResponseUtil.ApiError.class)})
    @Deprecated
    public Response createCondition(@ApiParam(value="Trigger definition id to be retrieved.", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Condition to add.") Condition condition) {
        try {
            if (condition == null) {
                return ResponseUtil.badRequest((String)"Bad json condition");
            }
            condition.setTriggerId(triggerId);
            Collection conditions = this.definitions.addCondition(this.tenantId, condition.getTriggerId(), condition.getTriggerMode(), condition);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Conditions: " + conditions));
            }
            return ResponseUtil.ok((Object)conditions);
        }
        catch (NotFoundException e) {
            return ResponseUtil.notFound((String)e.getMessage());
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.badRequest((String)("Bad arguments: " + e.getMessage()));
            }
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @PUT
    @Path(value="/{triggerId}/conditions/{conditionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="@Deprecated : Update an existing Condition.", notes="Use PUT /alerts/triggers/{triggerId}/conditions to set the entire condition set in one service. Return the updated collection of Conditions for a trigger.", response=Condition.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Condition updated."), @ApiResponse(code=404, message="No Condition found.", response=ResponseUtil.ApiError.class), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters.", response=ResponseUtil.ApiError.class)})
    @Deprecated
    public Response updateCondition(@ApiParam(value="Trigger definition id to be retrieved.", required=true) @PathParam(value="triggerId") String triggerId, @PathParam(value="conditionId") String conditionId, @ApiParam(value="Condition to update.") Condition condition) {
        try {
            Trigger trigger = this.definitions.getTrigger(this.tenantId, triggerId);
            if (trigger == null) {
                return ResponseUtil.notFound((String)("No trigger found for triggerId: " + triggerId));
            }
            if (condition == null) {
                return ResponseUtil.badRequest((String)"Bad json condition");
            }
            condition.setTriggerId(triggerId);
            boolean exists = false;
            if (conditionId.equals(condition.getConditionId())) {
                boolean bl = exists = this.definitions.getCondition(this.tenantId, condition.getConditionId()) != null;
            }
            if (!exists) {
                return ResponseUtil.notFound((String)("Condition not found for conditionId: " + conditionId));
            }
            Collection conditions = this.definitions.updateCondition(this.tenantId, condition);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Conditions: " + conditions));
            }
            return ResponseUtil.ok((Object)conditions);
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() != null && e.getCause() instanceof IllegalArgumentException) {
                return ResponseUtil.badRequest((String)("Bad arguments: " + e.getMessage()));
            }
            return ResponseUtil.internalError((Exception)e);
        }
    }

    @DELETE
    @Path(value="/{triggerId}/conditions/{conditionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="@Deprecated : Delete a condition.", notes="Use PUT /alerts/triggers/{triggerId}/conditions to set the entire condition set in one service.Return the updated collection of Conditions for a trigger.", response=Condition.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Condition deleted."), @ApiResponse(code=404, message="No Condition found.", response=ResponseUtil.ApiError.class), @ApiResponse(code=500, message="Internal server error.", response=ResponseUtil.ApiError.class), @ApiResponse(code=400, message="Bad Request/Invalid Parameters.", response=ResponseUtil.ApiError.class)})
    @Deprecated
    public Response deleteCondition(@ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId, @PathParam(value="conditionId") String conditionId) {
        try {
            Trigger trigger = this.definitions.getTrigger(this.tenantId, triggerId);
            if (trigger == null) {
                return ResponseUtil.notFound((String)("No trigger found for triggerId: " + triggerId));
            }
            Condition condition = this.definitions.getCondition(this.tenantId, conditionId);
            if (condition == null) {
                return ResponseUtil.notFound((String)("No condition found for conditionId: " + conditionId));
            }
            if (!condition.getTriggerId().equals(triggerId)) {
                return ResponseUtil.badRequest((String)("ConditionId: " + conditionId + " does not belong to triggerId: " + triggerId));
            }
            Collection conditions = this.definitions.removeCondition(this.tenantId, conditionId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Conditions: " + conditions));
            }
            return ResponseUtil.ok((Object)conditions);
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((Exception)e);
        }
    }

    private boolean isEmpty(String s) {
        return null == s || s.trim().isEmpty();
    }

    private boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }
}

