/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.model.events;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hawkular.apm.api.model.Property;
import org.hawkular.apm.api.utils.SerializationUtil;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;

@Indexed
public class CommunicationDetails
implements Externalizable {
    @Field
    private String id;
    private String businessTransaction;
    private String source;
    private String target;
    private boolean multiConsumer = false;
    private boolean internal = false;
    private long timestamp = 0L;
    private long latency = 0L;
    private long consumerDuration = 0L;
    private long producerDuration = 0L;
    private long timestampOffset = 0L;
    private String sourceFragmentId;
    private String sourceHostName;
    private String sourceHostAddress;
    private String targetFragmentId;
    private String targetHostName;
    private String targetHostAddress;
    private long targetFragmentDuration;
    private String principal;
    private Set<Property> properties = new HashSet<Property>();
    private List<Outbound> outbound = new ArrayList<Outbound>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getBusinessTransaction() {
        return this.businessTransaction;
    }

    public void setBusinessTransaction(String businessTransaction) {
        this.businessTransaction = businessTransaction;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public boolean isMultiConsumer() {
        return this.multiConsumer;
    }

    public void setMultiConsumer(boolean multiConsumer) {
        this.multiConsumer = multiConsumer;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public void setInternal(boolean internal) {
        this.internal = internal;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getLatency() {
        return this.latency;
    }

    public void setLatency(long latency) {
        this.latency = latency;
    }

    public long getConsumerDuration() {
        return this.consumerDuration;
    }

    public void setConsumerDuration(long consumerDuration) {
        this.consumerDuration = consumerDuration;
    }

    public long getProducerDuration() {
        return this.producerDuration;
    }

    public void setProducerDuration(long producerDuration) {
        this.producerDuration = producerDuration;
    }

    public long getTimestampOffset() {
        return this.timestampOffset;
    }

    public void setTimestampOffset(long timestampOffset) {
        this.timestampOffset = timestampOffset;
    }

    public String getSourceFragmentId() {
        return this.sourceFragmentId;
    }

    public void setSourceFragmentId(String sourceFragmentId) {
        this.sourceFragmentId = sourceFragmentId;
    }

    public String getSourceHostName() {
        return this.sourceHostName;
    }

    public void setSourceHostName(String sourceHostName) {
        this.sourceHostName = sourceHostName;
    }

    public String getSourceHostAddress() {
        return this.sourceHostAddress;
    }

    public void setSourceHostAddress(String sourceHostAddress) {
        this.sourceHostAddress = sourceHostAddress;
    }

    public String getTargetFragmentId() {
        return this.targetFragmentId;
    }

    public void setTargetFragmentId(String targetFragmentId) {
        this.targetFragmentId = targetFragmentId;
    }

    public String getTargetHostName() {
        return this.targetHostName;
    }

    public void setTargetHostName(String targetHostName) {
        this.targetHostName = targetHostName;
    }

    public String getTargetHostAddress() {
        return this.targetHostAddress;
    }

    public void setTargetHostAddress(String targetHostAddress) {
        this.targetHostAddress = targetHostAddress;
    }

    public long getTargetFragmentDuration() {
        return this.targetFragmentDuration;
    }

    public void setTargetFragmentDuration(long targetFragmentDuration) {
        this.targetFragmentDuration = targetFragmentDuration;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public Set<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(Set<Property> properties) {
        this.properties = properties;
    }

    public boolean hasProperty(String name) {
        for (Property property : this.properties) {
            if (!property.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Set<Property> getProperties(String name) {
        HashSet<Property> ret = new HashSet<Property>();
        for (Property property : this.properties) {
            if (!property.getName().equals(name)) continue;
            ret.add(property);
        }
        return ret;
    }

    public List<Outbound> getOutbound() {
        return this.outbound;
    }

    public void setOutbound(List<Outbound> outbound) {
        this.outbound = outbound;
    }

    public String toString() {
        return "CommunicationDetails [id=" + this.id + ", businessTransaction=" + this.businessTransaction + ", source=" + this.source + ", target=" + this.target + ", multiConsumer=" + this.multiConsumer + ", internal=" + this.internal + ", timestamp=" + this.timestamp + ", latency=" + this.latency + ", consumerDuration=" + this.consumerDuration + ", producerDuration=" + this.producerDuration + ", timestampOffset=" + this.timestampOffset + ", sourceFragmentId=" + this.sourceFragmentId + ", sourceHostName=" + this.sourceHostName + ", sourceHostAddress=" + this.sourceHostAddress + ", targetFragmentId=" + this.targetFragmentId + ", targetHostName=" + this.targetHostName + ", targetHostAddress=" + this.targetHostAddress + ", targetFragmentDuration=" + this.targetFragmentDuration + ", principal=" + this.principal + ", properties=" + this.properties + ", outbound=" + this.outbound + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.businessTransaction == null ? 0 : this.businessTransaction.hashCode());
        result = 31 * result + (int)(this.consumerDuration ^ this.consumerDuration >>> 32);
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.internal ? 1231 : 1237);
        result = 31 * result + (int)(this.latency ^ this.latency >>> 32);
        result = 31 * result + (this.multiConsumer ? 1231 : 1237);
        result = 31 * result + (this.outbound == null ? 0 : this.outbound.hashCode());
        result = 31 * result + (this.principal == null ? 0 : this.principal.hashCode());
        result = 31 * result + (int)(this.producerDuration ^ this.producerDuration >>> 32);
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.sourceFragmentId == null ? 0 : this.sourceFragmentId.hashCode());
        result = 31 * result + (this.sourceHostAddress == null ? 0 : this.sourceHostAddress.hashCode());
        result = 31 * result + (this.sourceHostName == null ? 0 : this.sourceHostName.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        result = 31 * result + (int)(this.targetFragmentDuration ^ this.targetFragmentDuration >>> 32);
        result = 31 * result + (this.targetFragmentId == null ? 0 : this.targetFragmentId.hashCode());
        result = 31 * result + (this.targetHostAddress == null ? 0 : this.targetHostAddress.hashCode());
        result = 31 * result + (this.targetHostName == null ? 0 : this.targetHostName.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (int)(this.timestampOffset ^ this.timestampOffset >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommunicationDetails other = (CommunicationDetails)obj;
        if (this.businessTransaction == null ? other.businessTransaction != null : !this.businessTransaction.equals(other.businessTransaction)) {
            return false;
        }
        if (this.consumerDuration != other.consumerDuration) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.internal != other.internal) {
            return false;
        }
        if (this.latency != other.latency) {
            return false;
        }
        if (this.multiConsumer != other.multiConsumer) {
            return false;
        }
        if (this.outbound == null ? other.outbound != null : !this.outbound.equals(other.outbound)) {
            return false;
        }
        if (this.principal == null ? other.principal != null : !this.principal.equals(other.principal)) {
            return false;
        }
        if (this.producerDuration != other.producerDuration) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        if (this.sourceFragmentId == null ? other.sourceFragmentId != null : !this.sourceFragmentId.equals(other.sourceFragmentId)) {
            return false;
        }
        if (this.sourceHostAddress == null ? other.sourceHostAddress != null : !this.sourceHostAddress.equals(other.sourceHostAddress)) {
            return false;
        }
        if (this.sourceHostName == null ? other.sourceHostName != null : !this.sourceHostName.equals(other.sourceHostName)) {
            return false;
        }
        if (this.target == null ? other.target != null : !this.target.equals(other.target)) {
            return false;
        }
        if (this.targetFragmentDuration != other.targetFragmentDuration) {
            return false;
        }
        if (this.targetFragmentId == null ? other.targetFragmentId != null : !this.targetFragmentId.equals(other.targetFragmentId)) {
            return false;
        }
        if (this.targetHostAddress == null ? other.targetHostAddress != null : !this.targetHostAddress.equals(other.targetHostAddress)) {
            return false;
        }
        if (this.targetHostName == null ? other.targetHostName != null : !this.targetHostName.equals(other.targetHostName)) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        return this.timestampOffset == other.timestampOffset;
    }

    @Override
    public void readExternal(ObjectInput ois) throws IOException, ClassNotFoundException {
        int i;
        ois.readInt();
        this.id = SerializationUtil.deserializeString(ois);
        this.businessTransaction = SerializationUtil.deserializeString(ois);
        this.source = SerializationUtil.deserializeString(ois);
        this.target = SerializationUtil.deserializeString(ois);
        this.multiConsumer = ois.readBoolean();
        this.internal = ois.readBoolean();
        this.timestamp = ois.readLong();
        this.latency = ois.readLong();
        this.consumerDuration = ois.readLong();
        this.producerDuration = ois.readLong();
        this.timestampOffset = ois.readLong();
        this.sourceFragmentId = SerializationUtil.deserializeString(ois);
        this.sourceHostName = SerializationUtil.deserializeString(ois);
        this.sourceHostAddress = SerializationUtil.deserializeString(ois);
        this.targetFragmentId = SerializationUtil.deserializeString(ois);
        this.targetHostName = SerializationUtil.deserializeString(ois);
        this.targetHostAddress = SerializationUtil.deserializeString(ois);
        this.targetFragmentDuration = ois.readLong();
        this.principal = SerializationUtil.deserializeString(ois);
        int size = ois.readInt();
        for (i = 0; i < size; ++i) {
            this.properties.add((Property)ois.readObject());
        }
        size = ois.readInt();
        for (i = 0; i < size; ++i) {
            this.outbound.add((Outbound)ois.readObject());
        }
    }

    @Override
    public void writeExternal(ObjectOutput oos) throws IOException {
        oos.writeInt(1);
        SerializationUtil.serializeString(oos, this.id);
        SerializationUtil.serializeString(oos, this.businessTransaction);
        SerializationUtil.serializeString(oos, this.source);
        SerializationUtil.serializeString(oos, this.target);
        oos.writeBoolean(this.multiConsumer);
        oos.writeBoolean(this.internal);
        oos.writeLong(this.timestamp);
        oos.writeLong(this.latency);
        oos.writeLong(this.consumerDuration);
        oos.writeLong(this.producerDuration);
        oos.writeLong(this.timestampOffset);
        SerializationUtil.serializeString(oos, this.sourceFragmentId);
        SerializationUtil.serializeString(oos, this.sourceHostName);
        SerializationUtil.serializeString(oos, this.sourceHostAddress);
        SerializationUtil.serializeString(oos, this.targetFragmentId);
        SerializationUtil.serializeString(oos, this.targetHostName);
        SerializationUtil.serializeString(oos, this.targetHostAddress);
        oos.writeLong(this.targetFragmentDuration);
        SerializationUtil.serializeString(oos, this.principal);
        oos.writeInt(this.properties.size());
        for (Property property : this.properties) {
            oos.writeObject(property);
        }
        oos.writeInt(this.outbound.size());
        for (int i = 0; i < this.outbound.size(); ++i) {
            oos.writeObject(this.outbound.get(i));
        }
    }

    public static class Outbound
    implements Externalizable {
        private List<String> ids = new ArrayList<String>();
        private boolean multiConsumer = false;
        private long producerOffset = 0L;

        public List<String> getIds() {
            return this.ids;
        }

        public void setIds(List<String> ids) {
            this.ids = ids;
        }

        public boolean isMultiConsumer() {
            return this.multiConsumer;
        }

        public void setMultiConsumer(boolean multiConsumer) {
            this.multiConsumer = multiConsumer;
        }

        public long getProducerOffset() {
            return this.producerOffset;
        }

        public void setProducerOffset(long producerOffset) {
            this.producerOffset = producerOffset;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.ids == null ? 0 : this.ids.hashCode());
            result = 31 * result + (this.multiConsumer ? 1231 : 1237);
            result = 31 * result + (int)(this.producerOffset ^ this.producerOffset >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Outbound other = (Outbound)obj;
            if (this.ids == null ? other.ids != null : !this.ids.equals(other.ids)) {
                return false;
            }
            if (this.multiConsumer != other.multiConsumer) {
                return false;
            }
            return this.producerOffset == other.producerOffset;
        }

        public String toString() {
            return "Outbound [ids=" + this.ids + ", multiConsumer=" + this.multiConsumer + ", producerOffset=" + this.producerOffset + "]";
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            in.readInt();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                this.ids.add(in.readUTF());
            }
            this.multiConsumer = in.readBoolean();
            this.producerOffset = in.readLong();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            out.writeInt(this.ids.size());
            for (int i = 0; i < this.ids.size(); ++i) {
                out.writeUTF(this.ids.get(i));
            }
            out.writeBoolean(this.multiConsumer);
            out.writeLong(this.producerOffset);
        }
    }
}

