/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.services.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hawkular.apm.api.model.analytics.CommunicationSummaryStatistics;

public class CommunicationSummaryTreeBuilder {
    public static Collection<CommunicationSummaryStatistics> buildCommunicationSummaryTree(Collection<CommunicationSummaryStatistics> nodes) {
        HashMap<String, CommunicationSummaryStatistics> nodeMap = new HashMap<String, CommunicationSummaryStatistics>();
        for (CommunicationSummaryStatistics css : nodes) {
            nodeMap.put(css.getId(), css);
        }
        Collection<CommunicationSummaryStatistics> rootNodes = CommunicationSummaryTreeBuilder.getRootCommunicationSummaryNodes(nodeMap);
        if (rootNodes != null) {
            ArrayList<CommunicationSummaryStatistics> ret = new ArrayList<CommunicationSummaryStatistics>();
            for (CommunicationSummaryStatistics css : rootNodes) {
                CommunicationSummaryStatistics rootNode = new CommunicationSummaryStatistics(css);
                ArrayList<String> usedIds = new ArrayList<String>();
                usedIds.add(rootNode.getId());
                CommunicationSummaryTreeBuilder.initCommunicationSummaryTreeNode(rootNode, nodeMap, usedIds);
                ret.add(rootNode);
            }
            return ret;
        }
        return null;
    }

    protected static void initCommunicationSummaryTreeNode(CommunicationSummaryStatistics node, Map<String, CommunicationSummaryStatistics> nodeMap, List<String> usedIds) {
        for (String id : node.getOutbound().keySet()) {
            if (usedIds.contains(id)) continue;
            CommunicationSummaryStatistics copy = new CommunicationSummaryStatistics(nodeMap.get(id));
            CommunicationSummaryStatistics.ConnectionStatistics cs = node.getOutbound().get(id);
            cs.setNode(copy);
            usedIds.add(id);
            CommunicationSummaryTreeBuilder.initCommunicationSummaryTreeNode(copy, nodeMap, usedIds);
        }
    }

    protected static Collection<CommunicationSummaryStatistics> getRootCommunicationSummaryNodes(Map<String, CommunicationSummaryStatistics> nodeMap) {
        HashMap<String, CommunicationSummaryStatistics> nodeMapCopy = new HashMap<String, CommunicationSummaryStatistics>(nodeMap);
        for (CommunicationSummaryStatistics css : nodeMap.values()) {
            for (String linkId : css.getOutbound().keySet()) {
                nodeMapCopy.remove(linkId);
            }
        }
        return nodeMapCopy.values();
    }
}

