/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.instrumenter.rules;

import org.hawkular.apm.api.model.config.instrumentation.jvm.InstrumentAction;
import org.hawkular.apm.api.model.config.instrumentation.jvm.SetState;
import org.hawkular.apm.instrumenter.rules.InstrumentActionTransformer;

public class SetStateTransformer
implements InstrumentActionTransformer {
    @Override
    public Class<? extends InstrumentAction> getActionType() {
        return SetState.class;
    }

    @Override
    public String convertToRuleAction(InstrumentAction action) {
        SetState setState = (SetState)action;
        StringBuilder builder = new StringBuilder(32);
        builder.append("setState(");
        if (setState.getContextExpression() == null) {
            builder.append("null");
        } else {
            builder.append(setState.getContextExpression());
        }
        builder.append(",\"");
        builder.append(setState.getName());
        builder.append("\",");
        if (setState.getValueExpression() == null) {
            builder.append("null");
        } else {
            builder.append(setState.getValueExpression());
        }
        builder.append(",");
        builder.append(setState.isSession());
        builder.append(")");
        return builder.toString();
    }
}

