/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.trace.publisher.rest.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.List;
import org.hawkular.apm.api.logging.Logger;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.api.services.PublisherMetricHandler;
import org.hawkular.apm.api.services.TracePublisher;
import org.hawkular.apm.api.utils.PropertyUtil;

public class TracePublisherRESTClient
implements TracePublisher {
    private static final Logger log = Logger.getLogger(TracePublisherRESTClient.class.getName());
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String HAWKULAR_TENANT = "Hawkular-Tenant";
    private String username = PropertyUtil.getProperty("HAWKULAR_APM_USERNAME");
    private String password = PropertyUtil.getProperty("HAWKULAR_APM_PASSWORD");
    private String authorization = null;
    private String uri = PropertyUtil.getProperty("HAWKULAR_APM_URI");
    private PublisherMetricHandler<Trace> handler = null;

    public TracePublisherRESTClient() {
        if (this.uri != null && !this.uri.isEmpty() && this.uri.charAt(this.uri.length() - 1) != '/') {
            this.uri = this.uri + '/';
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.authorization = null;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.authorization = null;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    public int getInitialRetryCount() {
        return 0;
    }

    @Override
    public void publish(String tenantId, List<Trace> traces) throws Exception {
        URL url = new URL(this.uri + "hawkular/apm/fragments");
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Publish traces [tenant=" + tenantId + "][url=" + url + "]: " + traces);
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(false);
        connection.setRequestProperty("Content-Type", "application/json");
        this.addHeaders(connection, tenantId);
        long startTime = 0L;
        if (this.handler != null) {
            startTime = System.currentTimeMillis();
        }
        OutputStream os = connection.getOutputStream();
        os.write(mapper.writeValueAsBytes(traces));
        os.flush();
        os.close();
        int statusCode = connection.getResponseCode();
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Status code is: " + statusCode);
        }
        if (this.handler != null) {
            this.handler.published(tenantId, traces, System.currentTimeMillis() - startTime);
        }
        if (statusCode != 200) {
            if (log.isLoggable(Logger.Level.FINER)) {
                log.finer("Failed to publish trace fragments: status=[" + statusCode + "]");
            }
            throw new Exception(connection.getResponseMessage());
        }
    }

    @Override
    public void publish(String tenantId, List<Trace> items, int retryCount, long delay) throws Exception {
        throw new UnsupportedOperationException("Cannot set the retry count and delay");
    }

    @Override
    public void retry(String tenantId, List<Trace> items, String subscriber, int retryCount, long delay) throws Exception {
        throw new UnsupportedOperationException("Cannot retry");
    }

    protected void addHeaders(HttpURLConnection connection, String tenantId) {
        if (tenantId == null) {
            tenantId = PropertyUtil.getProperty("HAWKULAR_TENANT");
        }
        if (tenantId != null) {
            connection.setRequestProperty(HAWKULAR_TENANT, tenantId);
        }
        if (this.authorization == null && this.username != null) {
            String authString = this.username + ":" + this.password;
            String encoded = Base64.getEncoder().encodeToString(authString.getBytes());
            this.authorization = "Basic " + encoded;
        }
        if (this.authorization != null) {
            connection.setRequestProperty("Authorization", this.authorization);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.uri != null && this.uri.startsWith("http");
    }

    @Override
    public void setMetricHandler(PublisherMetricHandler<Trace> handler) {
        this.handler = handler;
    }
}

