/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.shaded.org.mvel2;

import java.util.Map;
import org.hawkular.apm.shaded.org.mvel2.CompileException;
import org.hawkular.apm.shaded.org.mvel2.ast.ASTNode;
import org.hawkular.apm.shaded.org.mvel2.ast.Substatement;
import org.hawkular.apm.shaded.org.mvel2.compiler.AbstractParser;
import org.hawkular.apm.shaded.org.mvel2.compiler.BlankLiteral;
import org.hawkular.apm.shaded.org.mvel2.integration.VariableResolverFactory;
import org.hawkular.apm.shaded.org.mvel2.integration.impl.ImmutableDefaultFactory;
import org.hawkular.apm.shaded.org.mvel2.integration.impl.MapVariableResolverFactory;
import org.hawkular.apm.shaded.org.mvel2.util.ErrorUtil;
import org.hawkular.apm.shaded.org.mvel2.util.ExecutionStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVELInterpretedRuntime
extends AbstractParser {
    private Object holdOverRegister;

    public Object parse() {
        try {
            this.stk = new ExecutionStack();
            this.dStack = new ExecutionStack();
            this.variableFactory.setTiltFlag(false);
            this.cursor = this.start;
            return this.parseAndExecuteInterpreted();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new CompileException("unexpected end of statement", this.expr, this.length);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            if (this.cursor >= this.length) {
                throw new CompileException("unexpected end of statement", this.expr, this.length);
            }
            throw e;
        }
        catch (CompileException e) {
            throw ErrorUtil.rewriteIfNeeded(e, this.expr, this.cursor);
        }
    }

    private Object parseAndExecuteInterpreted() {
        ASTNode tk = null;
        this.lastWasIdentifier = false;
        try {
            block13: while ((tk = this.nextToken()) != null) {
                int operator;
                this.holdOverRegister = null;
                if (this.lastWasIdentifier && this.lastNode.isDiscard()) {
                    this.stk.discard();
                }
                if (this.stk.isEmpty()) {
                    if ((tk.fields & 0x400000) != 0) {
                        this.stk.push(tk.getReducedValue(this.stk, this.ctx, this.variableFactory));
                        Object o = this.stk.peek();
                        if (o instanceof Integer) {
                            this.arithmeticFunctionReduction((Integer)o);
                        }
                    } else {
                        this.stk.push(tk.getReducedValue(this.ctx, this.ctx, this.variableFactory));
                    }
                    if (!(tk instanceof Substatement) || (tk = this.nextToken()) == null) continue;
                    operator = tk.getOperator();
                    if (MVELInterpretedRuntime.isArithmeticOperator(operator)) {
                        this.stk.push(this.nextToken().getReducedValue(this.ctx, this.ctx, this.variableFactory), operator);
                        if (this.procBooleanOperator(this.arithmeticFunctionReduction(operator)) != -1) continue;
                        return this.stk.peek();
                    }
                }
                if (this.variableFactory.tiltFlag()) {
                    return this.stk.pop();
                }
                operator = tk.getOperator();
                switch (this.procBooleanOperator(operator)) {
                    case 99: {
                        this.variableFactory.setTiltFlag(true);
                        return this.stk.pop();
                    }
                    case -1: {
                        return this.stk.peek();
                    }
                    case 0: {
                        continue block13;
                    }
                    case -2: {
                        if (tk.isOperator()) continue block13;
                        if (!(this.stk.peek() instanceof Class)) {
                            throw new CompileException("unexpected token or unknown identifier:" + tk.getName(), this.expr, this.st);
                        }
                        this.variableFactory.createVariable(tk.getName(), null, (Class)this.stk.peek());
                        continue block13;
                    }
                }
                this.stk.push(this.nextToken().getReducedValue(this.ctx, this.ctx, this.variableFactory), operator);
                operator = this.arithmeticFunctionReduction(operator);
                switch (operator) {
                    case -1: {
                        return this.stk.peek();
                    }
                    case 0: {
                        continue block13;
                    }
                }
                if (this.procBooleanOperator(operator) != -1) continue;
                return this.stk.peek();
            }
            if (this.holdOverRegister != null) {
                return this.holdOverRegister;
            }
        }
        catch (CompileException e) {
            throw ErrorUtil.rewriteIfNeeded(e, this.expr, this.start);
        }
        catch (NullPointerException e) {
            if (tk != null && tk.isOperator()) {
                CompileException ce = new CompileException("incomplete statement: " + tk.getName() + " (possible use of reserved keyword as identifier: " + tk.getName() + ")", this.expr, this.st, e);
                ce.setExpr(this.expr);
                ce.setLineNumber(this.line);
                ce.setCursor(this.cursor);
                throw ce;
            }
            throw e;
        }
        return this.stk.peek();
    }

    private int procBooleanOperator(int operator) {
        switch (operator) {
            case 99: {
                return 99;
            }
            case -1: {
                return -2;
            }
            case 21: {
                this.reduceRight();
                if (!this.stk.peekBoolean().booleanValue()) {
                    if (this.unwindStatement(operator)) {
                        return -1;
                    }
                    this.stk.clear();
                    return 0;
                }
                this.stk.discard();
                return 0;
            }
            case 22: {
                this.reduceRight();
                if (this.stk.peekBoolean().booleanValue()) {
                    if (this.unwindStatement(operator)) {
                        return -1;
                    }
                    this.stk.clear();
                    return 0;
                }
                this.stk.discard();
                return 0;
            }
            case 23: {
                if (BlankLiteral.INSTANCE.equals(this.stk.peek())) break;
                return -1;
            }
            case 29: {
                if (!this.stk.popBoolean().booleanValue()) {
                    ASTNode tk;
                    this.stk.clear();
                    while ((tk = this.nextToken()) != null && !tk.isOperator(30)) {
                    }
                }
                return 0;
            }
            case 30: {
                this.captureToEOS();
                return 0;
            }
            case 37: {
                if (this.hasMore()) {
                    this.holdOverRegister = this.stk.pop();
                    this.stk.clear();
                }
                return 0;
            }
        }
        return 1;
    }

    private void reduceRight() {
        if (this.dStack.isEmpty()) {
            return;
        }
        Object o = this.stk.pop();
        this.stk.push(this.dStack.pop(), o, this.dStack.pop());
        this.reduce();
    }

    private boolean hasMore() {
        return this.cursor <= this.end;
    }

    private boolean unwindStatement(int operator) {
        ASTNode tk;
        switch (operator) {
            case 21: {
                while ((tk = this.nextToken()) != null && !tk.isOperator(37) && !tk.isOperator(22)) {
                }
                break;
            }
            default: {
                while ((tk = this.nextToken()) != null && !tk.isOperator(37)) {
                }
                break block0;
            }
        }
        return tk == null;
    }

    MVELInterpretedRuntime(char[] expression, Object ctx, Map<String, Object> variables) {
        this.expr = expression;
        this.length = this.expr.length;
        this.ctx = ctx;
        this.variableFactory = new MapVariableResolverFactory(variables);
    }

    MVELInterpretedRuntime(char[] expression, Object ctx) {
        this.expr = expression;
        this.length = this.expr.length;
        this.ctx = ctx;
        this.variableFactory = new ImmutableDefaultFactory();
    }

    MVELInterpretedRuntime(String expression) {
        this.setExpression(expression);
        this.variableFactory = new ImmutableDefaultFactory();
    }

    MVELInterpretedRuntime(char[] expression) {
        this.expr = expression;
        this.length = this.end = expression.length;
    }

    public MVELInterpretedRuntime(char[] expr, Object ctx, VariableResolverFactory resolverFactory) {
        this.expr = expr;
        this.length = this.end = expr.length;
        this.ctx = ctx;
        this.variableFactory = resolverFactory;
    }

    public MVELInterpretedRuntime(char[] expr, int start, int offset, Object ctx, VariableResolverFactory resolverFactory) {
        this.expr = expr;
        this.start = start;
        this.end = start + offset;
        this.length = this.end - start;
        this.ctx = ctx;
        this.variableFactory = resolverFactory;
    }

    public MVELInterpretedRuntime(String expression, Object ctx, VariableResolverFactory resolverFactory) {
        this.setExpression(expression);
        this.ctx = ctx;
        this.variableFactory = resolverFactory;
    }

    MVELInterpretedRuntime(String expression, VariableResolverFactory resolverFactory) {
        this.setExpression(expression);
        this.variableFactory = resolverFactory;
    }

    MVELInterpretedRuntime(String expression, Object ctx) {
        this.setExpression(expression);
        this.ctx = ctx;
        this.variableFactory = new ImmutableDefaultFactory();
    }
}

