/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.shaded.org.mvel2.ast;

import java.lang.reflect.Array;
import org.hawkular.apm.shaded.org.mvel2.CompileException;
import org.hawkular.apm.shaded.org.mvel2.DataConversion;
import org.hawkular.apm.shaded.org.mvel2.MVEL;
import org.hawkular.apm.shaded.org.mvel2.ParserContext;
import org.hawkular.apm.shaded.org.mvel2.ast.BlockNode;
import org.hawkular.apm.shaded.org.mvel2.compiler.ExecutableStatement;
import org.hawkular.apm.shaded.org.mvel2.integration.VariableResolverFactory;
import org.hawkular.apm.shaded.org.mvel2.integration.impl.DefaultLocalVariableResolverFactory;
import org.hawkular.apm.shaded.org.mvel2.integration.impl.ItemResolverFactory;
import org.hawkular.apm.shaded.org.mvel2.util.ParseTools;

public class ForEachNode
extends BlockNode {
    protected String item;
    protected Class itemType;
    protected ExecutableStatement condition;
    private static final int ITERABLE = 0;
    private static final int ARRAY = 1;
    private static final int CHARSEQUENCE = 2;
    private static final int INTEGER = 3;
    private int type = -1;

    public ForEachNode(char[] expr, int start, int offset, int blockStart, int blockOffset, int fields, ParserContext pCtx) {
        super(pCtx);
        this.expr = expr;
        this.start = start;
        this.offset = offset;
        this.fields = fields;
        this.handleCond(expr, this.start, this.offset, this.fields, pCtx);
        this.blockStart = blockStart;
        this.blockOffset = blockOffset;
        if ((fields & 0x10) != 0) {
            if (pCtx.isStrictTypeEnforcement() && this.itemType != null) {
                pCtx = pCtx.createSubcontext();
                pCtx.addInput(this.item, this.itemType);
            }
            pCtx.pushVariableScope();
            pCtx.makeVisible(this.item);
            this.compiledBlock = (ExecutableStatement)ParseTools.subCompileExpression(expr, blockStart, blockOffset, pCtx);
            pCtx.popVariableScope();
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        ItemResolverFactory.ItemResolver itemR = new ItemResolverFactory.ItemResolver(this.item);
        ItemResolverFactory itemFactory = new ItemResolverFactory(itemR, new DefaultLocalVariableResolverFactory(factory));
        Object iterCond = this.condition.getValue(ctx, thisValue, factory);
        if (this.type == -1) {
            this.determineIterType(iterCond.getClass());
        }
        switch (this.type) {
            case 1: {
                int len = Array.getLength(iterCond);
                for (int i = 0; i < len; ++i) {
                    itemR.setValue(Array.get(iterCond, i));
                    Object v = this.compiledBlock.getValue(ctx, thisValue, itemFactory);
                    if (!itemFactory.tiltFlag()) continue;
                    return v;
                }
                break;
            }
            case 2: {
                char[] arr$ = iterCond.toString().toCharArray();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Character o = Character.valueOf(arr$[i$]);
                    itemR.setValue(o);
                    Object v = this.compiledBlock.getValue(ctx, thisValue, itemFactory);
                    if (!itemFactory.tiltFlag()) continue;
                    return v;
                }
                break;
            }
            case 3: {
                int max = (Integer)iterCond + 1;
                for (int i = 1; i != max; ++i) {
                    itemR.setValue(i);
                    Object v = this.compiledBlock.getValue(ctx, thisValue, itemFactory);
                    if (!itemFactory.tiltFlag()) continue;
                    return v;
                }
                break;
            }
            case 0: {
                for (Object o : (Iterable)iterCond) {
                    itemR.setValue(o);
                    Object v = this.compiledBlock.getValue(ctx, thisValue, itemFactory);
                    if (!itemFactory.tiltFlag()) continue;
                    return v;
                }
                break;
            }
        }
        return null;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        ItemResolverFactory.ItemResolver itemR = new ItemResolverFactory.ItemResolver(this.item);
        ItemResolverFactory itemFactory = new ItemResolverFactory(itemR, new DefaultLocalVariableResolverFactory(factory));
        Object iterCond = MVEL.eval(this.expr, this.start, this.offset, thisValue, factory);
        if (this.itemType != null && this.itemType.isArray()) {
            this.enforceTypeSafety(this.itemType, ParseTools.getBaseComponentType(iterCond.getClass()));
        }
        this.compiledBlock = (ExecutableStatement)ParseTools.subCompileExpression(this.expr, this.blockStart, this.blockOffset);
        if (iterCond instanceof Iterable) {
            for (Object o : (Iterable)iterCond) {
                itemR.setValue(o);
                Object v = this.compiledBlock.getValue(ctx, thisValue, itemFactory);
                if (!itemFactory.tiltFlag()) continue;
                return v;
            }
        } else if (iterCond != null && iterCond.getClass().isArray()) {
            int len = Array.getLength(iterCond);
            for (int i = 0; i < len; ++i) {
                itemR.setValue(Array.get(iterCond, i));
                Object v = this.compiledBlock.getValue(ctx, thisValue, itemFactory);
                if (!itemFactory.tiltFlag()) continue;
                return v;
            }
        } else if (iterCond instanceof CharSequence) {
            char[] arr$ = iterCond.toString().toCharArray();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Character o = Character.valueOf(arr$[i$]);
                itemR.setValue(o);
                Object v = this.compiledBlock.getValue(ctx, thisValue, itemFactory);
                if (!itemFactory.tiltFlag()) continue;
                return v;
            }
        } else if (iterCond instanceof Integer) {
            int max = (Integer)iterCond + 1;
            for (int i = 1; i != max; ++i) {
                itemR.setValue(i);
                Object v = this.compiledBlock.getValue(ctx, thisValue, itemFactory);
                if (!itemFactory.tiltFlag()) continue;
                return v;
            }
        } else {
            throw new CompileException("non-iterable type: " + (iterCond != null ? iterCond.getClass().getName() : "null"), this.expr, this.start);
        }
        return null;
    }

    private void handleCond(char[] condition, int start, int offset, int fields, ParserContext pCtx) {
        int cursor;
        int end = start + offset;
        for (cursor = start; cursor < end && condition[cursor] != ':'; ++cursor) {
        }
        if (cursor == end || condition[cursor] != ':') {
            throw new CompileException("expected : in foreach", condition, cursor);
        }
        this.item = ParseTools.createStringTrimmed(condition, start, cursor - start);
        int x = this.item.indexOf(32);
        if (x != -1) {
            String tk = new String(condition, start, x).trim();
            try {
                this.itemType = ParseTools.findClass(null, tk, pCtx);
                this.item = new String(condition, start + x, cursor - start - x).trim();
            }
            catch (ClassNotFoundException e) {
                throw new CompileException("cannot resolve identifier: " + tk, condition, start);
            }
        }
        this.start = cursor + 1;
        this.offset = offset - (cursor - start) - 1;
        if ((fields & 0x10) != 0) {
            this.condition = (ExecutableStatement)ParseTools.subCompileExpression(this.expr, this.start, this.offset, pCtx);
            Class egress = this.condition.getKnownEgressType();
            if (this.itemType != null && egress.isArray()) {
                this.enforceTypeSafety(this.itemType, ParseTools.getBaseComponentType(this.condition.getKnownEgressType()));
            } else if (pCtx.isStrongTyping()) {
                this.determineIterType(egress);
            }
        }
    }

    private void determineIterType(Class t) {
        if (Iterable.class.isAssignableFrom(t)) {
            this.type = 0;
        } else if (t.isArray()) {
            this.type = 1;
        } else if (CharSequence.class.isAssignableFrom(t)) {
            this.type = 2;
        } else if (Integer.class.isAssignableFrom(t)) {
            this.type = 3;
        } else {
            throw new CompileException("non-iterable type: " + t.getName(), this.expr, this.start);
        }
    }

    private void enforceTypeSafety(Class required, Class actual) {
        if (!required.isAssignableFrom(actual) && !DataConversion.canConvert(actual, required)) {
            throw new CompileException("type mismatch in foreach: expected: " + required.getName() + "; but found: " + ParseTools.getBaseComponentType(actual), this.expr, this.start);
        }
    }
}

