/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.model.events;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import org.hawkular.apm.api.model.Property;
import org.hawkular.apm.api.utils.SerializationUtil;

public class ProducerInfo
implements Externalizable {
    private String id;
    private String sourceUri;
    private String sourceOperation;
    private long timestamp = 0L;
    private long duration = 0L;
    private String fragmentId;
    private String hostName;
    private String hostAddress;
    private boolean multipleConsumers = false;
    private Set<Property> properties = new HashSet<Property>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSourceUri() {
        return this.sourceUri;
    }

    public void setSourceUri(String sourceUri) {
        this.sourceUri = sourceUri;
    }

    public String getSourceOperation() {
        return this.sourceOperation;
    }

    public void setSourceOperation(String sourceOperation) {
        this.sourceOperation = sourceOperation;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public String getFragmentId() {
        return this.fragmentId;
    }

    public void setFragmentId(String fragmentId) {
        this.fragmentId = fragmentId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public void setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
    }

    public boolean isMultipleConsumers() {
        return this.multipleConsumers;
    }

    public void setMultipleConsumers(boolean multipleConsumers) {
        this.multipleConsumers = multipleConsumers;
    }

    public Set<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(Set<Property> properties) {
        this.properties = properties;
    }

    public boolean hasProperty(String name) {
        for (Property property : this.properties) {
            if (!property.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Set<Property> getProperties(String name) {
        HashSet<Property> ret = new HashSet<Property>();
        for (Property property : this.properties) {
            if (!property.getName().equals(name)) continue;
            ret.add(property);
        }
        return ret;
    }

    public String toString() {
        return "ProducerInfo [id=" + this.id + ", sourceUri=" + this.sourceUri + ", sourceOperation=" + this.sourceOperation + ", timestamp=" + this.timestamp + ", duration=" + this.duration + ", fragmentId=" + this.fragmentId + ", hostName=" + this.hostName + ", hostAddress=" + this.hostAddress + ", multipleConsumers=" + this.multipleConsumers + ", properties=" + this.properties + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.duration ^ this.duration >>> 32);
        result = 31 * result + (this.fragmentId == null ? 0 : this.fragmentId.hashCode());
        result = 31 * result + (this.hostAddress == null ? 0 : this.hostAddress.hashCode());
        result = 31 * result + (this.hostName == null ? 0 : this.hostName.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.multipleConsumers ? 1231 : 1237);
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.sourceOperation == null ? 0 : this.sourceOperation.hashCode());
        result = 31 * result + (this.sourceUri == null ? 0 : this.sourceUri.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProducerInfo other = (ProducerInfo)obj;
        if (this.duration != other.duration) {
            return false;
        }
        if (this.fragmentId == null ? other.fragmentId != null : !this.fragmentId.equals(other.fragmentId)) {
            return false;
        }
        if (this.hostAddress == null ? other.hostAddress != null : !this.hostAddress.equals(other.hostAddress)) {
            return false;
        }
        if (this.hostName == null ? other.hostName != null : !this.hostName.equals(other.hostName)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.multipleConsumers != other.multipleConsumers) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        if (this.sourceOperation == null ? other.sourceOperation != null : !this.sourceOperation.equals(other.sourceOperation)) {
            return false;
        }
        if (this.sourceUri == null ? other.sourceUri != null : !this.sourceUri.equals(other.sourceUri)) {
            return false;
        }
        return this.timestamp == other.timestamp;
    }

    @Override
    public void readExternal(ObjectInput ois) throws IOException, ClassNotFoundException {
        ois.readInt();
        this.id = SerializationUtil.deserializeString(ois);
        this.sourceUri = SerializationUtil.deserializeString(ois);
        this.sourceOperation = SerializationUtil.deserializeString(ois);
        this.timestamp = ois.readLong();
        this.duration = ois.readLong();
        this.fragmentId = SerializationUtil.deserializeString(ois);
        this.hostName = SerializationUtil.deserializeString(ois);
        this.hostAddress = SerializationUtil.deserializeString(ois);
        this.multipleConsumers = ois.readBoolean();
        int size = ois.readInt();
        for (int i = 0; i < size; ++i) {
            this.properties.add((Property)ois.readObject());
        }
    }

    @Override
    public void writeExternal(ObjectOutput oos) throws IOException {
        oos.writeInt(1);
        SerializationUtil.serializeString(oos, this.id);
        SerializationUtil.serializeString(oos, this.sourceUri);
        SerializationUtil.serializeString(oos, this.sourceOperation);
        oos.writeLong(this.timestamp);
        oos.writeLong(this.duration);
        SerializationUtil.serializeString(oos, this.fragmentId);
        SerializationUtil.serializeString(oos, this.hostName);
        SerializationUtil.serializeString(oos, this.hostAddress);
        oos.writeBoolean(this.multipleConsumers);
        oos.writeInt(this.properties.size());
        for (Property property : this.properties) {
            oos.writeObject(property);
        }
    }
}

