/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.client.collector.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hawkular.apm.api.logging.Logger;
import org.hawkular.apm.api.model.config.CollectorConfiguration;
import org.hawkular.apm.api.model.config.btxn.BusinessTxnConfig;
import org.hawkular.apm.client.collector.internal.FilterProcessor;

public class FilterManager {
    private static final Logger log = Logger.getLogger(FilterManager.class.getName());
    private Map<String, FilterProcessor> filterMap = new HashMap<String, FilterProcessor>();
    private List<FilterProcessor> globalExclusionFilters = new ArrayList<FilterProcessor>();
    private List<FilterProcessor> btxnFilters = new ArrayList<FilterProcessor>();
    private boolean onlyNamedTransactions = false;
    private static final FilterProcessor unnamedBTxn = new FilterProcessor();

    public FilterManager(CollectorConfiguration config) {
        this.init(config);
    }

    protected void init(CollectorConfiguration config) {
        for (String btxn : config.getBusinessTransactions().keySet()) {
            BusinessTxnConfig btc = config.getBusinessTransactions().get(btxn);
            this.init(btxn, btc);
        }
        this.onlyNamedTransactions = new Boolean(config.getProperty("HAWKULAR_APM_COLLECTOR_ONLYNAMED", Boolean.FALSE.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String btxn, BusinessTxnConfig btc) {
        FilterProcessor fp = null;
        if (btc.getFilter() != null) {
            fp = new FilterProcessor(btxn, btc);
        }
        Map<String, FilterProcessor> map = this.filterMap;
        synchronized (map) {
            FilterProcessor oldfp = this.filterMap.get(btxn);
            if (oldfp != null) {
                this.globalExclusionFilters.remove(oldfp);
                this.btxnFilters.remove(oldfp);
            }
            if (fp != null) {
                this.filterMap.put(btxn, fp);
                if (fp.isIncludeAll()) {
                    this.globalExclusionFilters.add(fp);
                } else {
                    this.btxnFilters.add(fp);
                }
            } else {
                this.filterMap.remove(btxn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String btxn) {
        Map<String, FilterProcessor> map = this.filterMap;
        synchronized (map) {
            FilterProcessor oldfp = this.filterMap.get(btxn);
            if (oldfp != null) {
                this.globalExclusionFilters.remove(oldfp);
                this.btxnFilters.remove(oldfp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterProcessor getFilterProcessor(String endpoint) {
        FilterProcessor ret = this.onlyNamedTransactions ? null : unnamedBTxn;
        Map<String, FilterProcessor> map = this.filterMap;
        synchronized (map) {
            int i;
            for (i = 0; i < this.globalExclusionFilters.size(); ++i) {
                if (!this.globalExclusionFilters.get(i).isExcluded(endpoint)) continue;
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Excluding endpoint=" + endpoint);
                }
                return null;
            }
            for (i = 0; i < this.btxnFilters.size(); ++i) {
                if (!this.btxnFilters.get(i).isIncluded(endpoint)) continue;
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Endpoint has passed inclusion filter: endpoint=" + endpoint);
                }
                if (this.btxnFilters.get(i).isExcluded(endpoint)) {
                    if (log.isLoggable(Logger.Level.FINEST)) {
                        log.finest("Endpoint has failed exclusion filter: endpoint=" + endpoint);
                    }
                    return null;
                }
                ret = this.btxnFilters.get(i);
                if (!log.isLoggable(Logger.Level.FINEST)) break;
                log.finest("Endpoint belongs to business transaction '" + ret + ": endpoint=" + endpoint);
                break;
            }
        }
        return ret;
    }

    protected Map<String, FilterProcessor> getFilterMap() {
        return this.filterMap;
    }

    protected void setFilterMap(Map<String, FilterProcessor> filterMap) {
        this.filterMap = filterMap;
    }

    protected List<FilterProcessor> getGlobalExclusionFilters() {
        return this.globalExclusionFilters;
    }

    protected void setGlobalExclusionFilters(List<FilterProcessor> globalExclusionFilters) {
        this.globalExclusionFilters = globalExclusionFilters;
    }

    protected List<FilterProcessor> getBtxnFilters() {
        return this.btxnFilters;
    }

    protected void setBtxnFilters(List<FilterProcessor> btxnFilters) {
        this.btxnFilters = btxnFilters;
    }
}

