/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.api.model.zipkin;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.apm.server.api.model.zipkin.Annotation;
import org.hawkular.apm.server.api.model.zipkin.BinaryAnnotation;
import org.hawkular.apm.server.api.model.zipkin.Endpoint;
import org.hawkular.apm.server.api.utils.zipkin.BinaryAnnotationMappingDeriver;
import org.hawkular.apm.server.api.utils.zipkin.MappingResult;

public class Span {
    private static final Logger log = Logger.getLogger(Span.class.getName());
    private String traceId;
    private String name;
    private String id;
    private String parentId;
    private List<Annotation> annotations = Collections.emptyList();
    private final List<BinaryAnnotation> binaryAnnotations;
    private Boolean debug;
    private long timestamp;
    private long duration;
    private final MappingResult mappingResult;
    private String service;
    private String ipv4;
    private URL url;

    public Span() {
        this(Collections.emptyList());
    }

    @JsonCreator
    public Span(@JsonProperty(value="binaryAnnotations") List<BinaryAnnotation> binaryAnnotations) {
        if (binaryAnnotations == null) {
            binaryAnnotations = Collections.emptyList();
        }
        this.binaryAnnotations = Collections.unmodifiableList(binaryAnnotations);
        this.mappingResult = BinaryAnnotationMappingDeriver.getInstance().mappingResult(binaryAnnotations);
        this.initUrl();
        this.initIpv4AndService();
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<Annotation> annotations) {
        this.annotations = annotations;
    }

    public List<BinaryAnnotation> getBinaryAnnotations() {
        return this.binaryAnnotations;
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public void setDebug(Boolean debug) {
        this.debug = debug;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public boolean topLevelSpan() {
        return this.getParentId() == null || this.getParentId().equals(this.getId());
    }

    public boolean clientSpan() {
        return this.annotations.size() == 2 && this.annotations.get(0).getValue().equals("cs") && this.annotations.get(1).getValue().equals("cr");
    }

    public boolean serverSpan() {
        return this.annotations.size() == 2 && this.annotations.get(0).getValue().equals("sr") && this.annotations.get(1).getValue().equals("ss");
    }

    public BinaryAnnotation getBinaryAnnotation(String key) {
        for (int i = 0; i < this.binaryAnnotations.size(); ++i) {
            BinaryAnnotation ba = this.binaryAnnotations.get(i);
            if (!ba.getKey().equals(key)) continue;
            return ba;
        }
        return null;
    }

    public MappingResult binaryAnnotationMapping() {
        return this.mappingResult;
    }

    public String ipv4() {
        return this.ipv4;
    }

    public String service() {
        return this.service;
    }

    public URL url() {
        return this.url;
    }

    private void initUrl() {
        BinaryAnnotation httpUrl = this.getBinaryAnnotation("http.url");
        if (httpUrl != null) {
            try {
                this.url = new URL(httpUrl.getValue());
            }
            catch (MalformedURLException e) {
                try {
                    this.url = new URL("http", null, httpUrl.getValue());
                }
                catch (MalformedURLException e1) {
                    log.log(Level.SEVERE, "Failed to decode URL", e);
                }
            }
        }
    }

    private void initIpv4AndService() {
        Endpoint endpoint;
        HashSet<Endpoint> endpoints = new HashSet<Endpoint>();
        for (BinaryAnnotation binaryAnnotation : this.binaryAnnotations) {
            if (binaryAnnotation.getEndpoint() == null) continue;
            Endpoint endpoint2 = binaryAnnotation.getEndpoint();
            endpoints.add(endpoint2);
        }
        if (endpoints.size() > 1) {
            log.severe("Multiple different Endpoints within one Span: " + endpoints);
        }
        Endpoint endpoint3 = endpoint = endpoints.size() > 0 ? (Endpoint)endpoints.iterator().next() : null;
        if (endpoint != null) {
            this.ipv4 = endpoint.getIpv4();
            this.service = endpoint.getServiceName();
        }
    }

    public String toString() {
        return "Span [traceId=" + this.traceId + ", name=" + this.name + ", id=" + this.id + ", parentId=" + this.parentId + ", annotations=" + this.annotations + ", binaryAnnotations=" + this.binaryAnnotations + ", debug=" + this.debug + ", timestamp=" + this.timestamp + ", duration=" + this.duration + "]";
    }
}

