/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.api.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.apm.api.model.Property;
import org.hawkular.apm.api.model.events.ProducerInfo;
import org.hawkular.apm.api.model.trace.Consumer;
import org.hawkular.apm.api.model.trace.ContainerNode;
import org.hawkular.apm.api.model.trace.CorrelationIdentifier;
import org.hawkular.apm.api.model.trace.Node;
import org.hawkular.apm.api.model.trace.Producer;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.server.api.model.zipkin.Span;
import org.hawkular.apm.server.api.services.CacheException;
import org.hawkular.apm.server.api.services.ProducerInfoCache;
import org.hawkular.apm.server.api.services.SpanCache;
import org.hawkular.apm.server.api.task.RetryAttemptException;
import org.hawkular.apm.server.api.utils.zipkin.SpanDeriverUtil;
import org.hawkular.apm.server.api.utils.zipkin.SpanUniqueIdGenerator;

public class ProducerInfoUtil {
    private static final Logger log = Logger.getLogger(ProducerInfoUtil.class.getName());

    private ProducerInfoUtil() {
    }

    public static void initialise(String tenantId, List<Trace> items, ProducerInfoCache producerInfoCache) throws RetryAttemptException {
        ArrayList<ProducerInfo> producerInfoList = new ArrayList<ProducerInfo>();
        for (int i = 0; i < items.size(); ++i) {
            Origin originUri = new Origin();
            Trace trace = items.get(i);
            for (int j = 0; j < trace.getNodes().size(); ++j) {
                Node node = trace.getNodes().get(j);
                ProducerInfoUtil.initialiseProducerInfo(producerInfoList, tenantId, trace, originUri, node, producerInfoCache);
            }
        }
        try {
            producerInfoCache.store(tenantId, producerInfoList);
        }
        catch (CacheException e) {
            throw new RetryAttemptException(e);
        }
    }

    protected static void initialiseProducerInfo(List<ProducerInfo> producerInfoList, String tenantId, Trace trace, Origin origin, Node node, ProducerInfoCache producerInfoCache) {
        block7: {
            block6: {
                if (node.getClass() != Producer.class) break block6;
                Producer producer = (Producer)node;
                if (origin.getUri() == null) {
                    origin.setUri("client:" + producer.getUri());
                    origin.setOperation(producer.getOperation());
                }
                long diffns = producer.getBaseTime() - trace.getNodes().get(0).getBaseTime();
                long diffms = TimeUnit.MILLISECONDS.convert(diffns, TimeUnit.NANOSECONDS);
                long timestamp = trace.getStartTime() + diffms;
                List<CorrelationIdentifier> cids = producer.getCorrelationIds(CorrelationIdentifier.Scope.Interaction);
                if (cids.isEmpty()) break block7;
                for (int i = 0; i < cids.size(); ++i) {
                    ProducerInfo pi = new ProducerInfo();
                    pi.setId(cids.get(i).getValue());
                    pi.setSourceUri(origin.getUri());
                    pi.setSourceOperation(origin.getOperation());
                    pi.setTimestamp(timestamp);
                    pi.setDuration(producer.getDuration());
                    pi.setFragmentId(trace.getId());
                    pi.setHostName(trace.getHostName());
                    pi.setHostAddress(trace.getHostAddress());
                    pi.setMultipleConsumers(producer.multipleConsumers());
                    pi.getProperties().addAll(producer.getProperties());
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Adding producer information for id=" + cids.get(i).getValue() + " pi=" + pi);
                    }
                    producerInfoList.add(pi);
                }
                break block7;
            }
            if (node instanceof ContainerNode) {
                if (origin.getUri() == null && node.getClass() == Consumer.class) {
                    origin.setUri(node.getUri());
                    origin.setOperation(node.getOperation());
                }
                for (int j = 0; j < ((ContainerNode)node).getNodes().size(); ++j) {
                    ProducerInfoUtil.initialiseProducerInfo(producerInfoList, tenantId, trace, origin, ((ContainerNode)node).getNodes().get(j), producerInfoCache);
                }
            }
        }
    }

    protected static Span findRootOrServerSpan(String tenantId, Span span, SpanCache spanCache) {
        while (span != null && !span.serverSpan() && !span.topLevelSpan()) {
            span = (Span)spanCache.get(tenantId, span.getParentId());
        }
        return span;
    }

    public static ProducerInfo getProducerInfo(String tenantId, Span serverSpan, SpanCache spanCache) {
        Span clientSpan;
        Span rootOrServerSpan;
        String clientSpanId = SpanUniqueIdGenerator.getClientId(serverSpan.getId());
        if (spanCache != null && clientSpanId != null && (rootOrServerSpan = ProducerInfoUtil.findRootOrServerSpan(tenantId, clientSpan = (Span)spanCache.get(tenantId, clientSpanId), spanCache)) != null) {
            ProducerInfo pi = new ProducerInfo();
            pi.setDuration(TimeUnit.MILLISECONDS.convert(clientSpan.getDuration(), TimeUnit.MICROSECONDS));
            pi.setTimestamp(TimeUnit.MILLISECONDS.convert(clientSpan.getTimestamp(), TimeUnit.MICROSECONDS));
            pi.setFragmentId(clientSpan.getId());
            pi.getProperties().addAll(clientSpan.binaryAnnotationMapping().getProperties());
            pi.setHostAddress(clientSpan.ipv4());
            if (clientSpan.service() != null) {
                pi.getProperties().add(new Property("service", clientSpan.service()));
            }
            pi.setId(clientSpan.getId());
            pi.setMultipleConsumers(false);
            pi.setSourceOperation(SpanDeriverUtil.deriveOperation(rootOrServerSpan));
            if (rootOrServerSpan.serverSpan()) {
                pi.setSourceUri(rootOrServerSpan.url().getPath());
            } else {
                pi.setSourceUri("client:" + clientSpan.url().getPath());
            }
            return pi;
        }
        return null;
    }

    public static class Origin {
        private String uri;
        private String operation;

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getOperation() {
            return this.operation;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }
    }
}

