/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.api.utils.zipkin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hawkular.apm.api.model.Property;

public class MappingResult {
    private final String componentType;
    private final String endpointType;
    private final Map<String, String> nodeDetails;
    private final List<Property> properties;

    public MappingResult(String componentType, String endpointType, Map<String, String> nodeDetails, List<Property> properties) {
        this.componentType = componentType;
        this.endpointType = endpointType;
        this.nodeDetails = Collections.unmodifiableMap(nodeDetails);
        this.properties = Collections.unmodifiableList(properties);
    }

    public MappingResult() {
        this.componentType = null;
        this.endpointType = null;
        this.nodeDetails = Collections.emptyMap();
        this.properties = Collections.emptyList();
    }

    public String getComponentType() {
        return this.componentType;
    }

    public String getEndpointType() {
        return this.endpointType;
    }

    public Map<String, String> getNodeDetails() {
        return this.nodeDetails;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String componentType;
        private String endpointType;
        private Map<String, String> nodeDetails = new HashMap<String, String>();
        private List<Property> properties = new ArrayList<Property>();

        private Builder() {
        }

        public Builder withComponentType(String componentType) {
            this.componentType = componentType;
            return this;
        }

        public Builder withEndpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        public Builder withNodeDetails(Map<String, String> nodeDetails) {
            this.nodeDetails = nodeDetails;
            return this;
        }

        public Builder withProperties(List<Property> properties) {
            this.properties = properties;
            return this;
        }

        public Builder addNodeDetail(String key, String value) {
            this.nodeDetails.put(key, value);
            return this;
        }

        public Builder addProperty(Property property) {
            this.properties.add(property);
            return this;
        }

        public MappingResult build() {
            return new MappingResult(this.componentType, this.endpointType, this.nodeDetails, this.properties);
        }
    }
}

