/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.api.utils.zipkin;

import org.hawkular.apm.server.api.model.zipkin.Span;

public class SpanUniqueIdGenerator {
    protected static final String CLIENT_ID_SUFFIX = "-client";

    public static String toUnique(Span span) {
        String id = span.getId();
        if (span.clientSpan()) {
            id = SpanUniqueIdGenerator.getClientId(span.getId());
        }
        return id;
    }

    public static String toOriginal(Span span) {
        int suffixIndex;
        String id = span.getId();
        if (span.clientSpan() && (suffixIndex = id.lastIndexOf(CLIENT_ID_SUFFIX)) > 0) {
            id = id.substring(0, suffixIndex);
        }
        return id;
    }

    public static String getClientId(String id) {
        if (id.endsWith(CLIENT_ID_SUFFIX)) {
            throw new IllegalStateException("Id already contains suffix: -client");
        }
        return id + CLIENT_ID_SUFFIX;
    }
}

