/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.trace.publisher.rest.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import org.hawkular.apm.api.logging.Logger;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.api.services.PublisherMetricHandler;
import org.hawkular.apm.api.services.TracePublisher;
import org.hawkular.apm.client.api.rest.AbstractRESTClient;

public class TracePublisherRESTClient
extends AbstractRESTClient
implements TracePublisher {
    private static final Logger log = Logger.getLogger(TracePublisherRESTClient.class.getName());
    private static final ObjectMapper mapper = new ObjectMapper();
    private PublisherMetricHandler<Trace> handler = null;

    public TracePublisherRESTClient() {
        super("HAWKULAR_APM_URI_PUBLISHER");
    }

    @Override
    public int getInitialRetryCount() {
        return 0;
    }

    @Override
    public void publish(String tenantId, List<Trace> traces) throws Exception {
        int statusCode;
        URL url = new URL(this.getUri() + "hawkular/apm/traces/fragments");
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Publish traces [tenant=" + tenantId + "][url=" + url + "]: " + traces);
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(false);
        connection.setRequestProperty("Content-Type", "application/json");
        this.addHeaders(connection, tenantId);
        long startTime = 0L;
        if (this.handler != null) {
            startTime = System.currentTimeMillis();
        }
        OutputStream os = connection.getOutputStream();
        os.write(mapper.writeValueAsBytes(traces));
        os.flush();
        os.close();
        try {
            statusCode = connection.getResponseCode();
        }
        catch (ConnectException exception) {
            log.warning("Could not connect to server at " + connection.getURL());
            throw exception;
        }
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Status code is: " + statusCode);
        }
        if (this.handler != null) {
            this.handler.published(tenantId, traces, System.currentTimeMillis() - startTime);
        }
        if (statusCode != 200) {
            if (log.isLoggable(Logger.Level.FINER)) {
                log.finer("Failed to publish trace fragments: status=[" + statusCode + "]");
            }
            throw new Exception(connection.getResponseMessage());
        }
    }

    @Override
    public void publish(String tenantId, List<Trace> items, int retryCount, long delay) throws Exception {
        throw new UnsupportedOperationException("Cannot set the retry count and delay");
    }

    @Override
    public void retry(String tenantId, List<Trace> items, String subscriber, int retryCount, long delay) throws Exception {
        throw new UnsupportedOperationException("Cannot retry");
    }

    @Override
    public void setMetricHandler(PublisherMetricHandler<Trace> handler) {
        this.handler = handler;
    }
}

