/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.synchronization;

import org.jboss.byteman.rule.exception.ExecuteException;

public class Rendezvous {
    private int expected;
    private Counter counter;
    private boolean rejoinable;
    private boolean isDeleted;
    private boolean needsRemove;

    public Rendezvous(int expected) {
        this(expected, false);
    }

    public Rendezvous(int expected, boolean rejoinable) {
        this.expected = expected;
        this.rejoinable = rejoinable;
        this.needsRemove = false;
        this.isDeleted = false;
        this.counter = new Counter();
    }

    public int rendezvous(long millis) {
        Counter currentCounter = this.counter;
        if (this.isDeleted || currentCounter.arrived == this.expected) {
            return -1;
        }
        int index = currentCounter.arrived++;
        if (currentCounter.arrived < this.expected) {
            long target_time = System.currentTimeMillis() + millis;
            while (currentCounter.arrived < this.expected) {
                block10: {
                    try {
                        if (millis <= 0L) {
                            this.wait();
                            break block10;
                        }
                        long wait_time = target_time - System.currentTimeMillis();
                        if (wait_time > 0L) {
                            this.wait(wait_time);
                            break block10;
                        }
                        throw new ExecuteException("timeout occurred in rendezvous");
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (!currentCounter.isPoisoned) continue;
                return -1;
            }
        } else {
            if (this.rejoinable) {
                this.counter = new Counter();
            } else {
                this.isDeleted = true;
                this.needsRemove = true;
            }
            this.notifyAll();
        }
        return index;
    }

    public boolean delete() {
        if (this.isDeleted) {
            return false;
        }
        this.isDeleted = true;
        this.needsRemove = true;
        if (this.counter.arrived > 0 && this.counter.arrived < this.expected) {
            this.counter.isPoisoned = true;
            this.notifyAll();
        }
        return true;
    }

    public int getExpected() {
        return this.expected;
    }

    public int getArrived() {
        if (this.isDeleted) {
            return -1;
        }
        return this.counter.arrived;
    }

    public boolean needsRemove() {
        return this.needsRemove;
    }

    public void setRemoved() {
        this.needsRemove = false;
    }

    public class Counter {
        public int arrived = 0;
        public boolean isPoisoned = false;
    }
}

