/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hawkular.apm.api.internal.actions;

import java.util.Map;
import shaded.org.hawkular.apm.api.internal.actions.ExpressionHandler;
import shaded.org.hawkular.apm.api.model.config.Direction;
import shaded.org.hawkular.apm.api.model.config.btxn.DataExpression;
import shaded.org.hawkular.apm.api.model.config.btxn.DataSource;
import shaded.org.hawkular.apm.api.model.config.btxn.Expression;
import shaded.org.hawkular.apm.api.model.config.btxn.Processor;
import shaded.org.hawkular.apm.api.model.config.btxn.ProcessorAction;
import shaded.org.hawkular.apm.api.model.trace.Node;
import shaded.org.hawkular.apm.api.model.trace.Trace;

public abstract class DataExpressionHandler
extends ExpressionHandler {
    private DataSource source;
    private String key;
    private int index = 0;

    public DataExpressionHandler(Expression expression) {
        super(expression);
    }

    @Override
    public boolean isUsesHeaders() {
        return ((DataExpression)this.getExpression()).getSource() == DataSource.Header;
    }

    @Override
    public boolean isUsesContent() {
        return ((DataExpression)this.getExpression()).getSource() == DataSource.Content;
    }

    @Override
    public void init(Processor processor, ProcessorAction action, boolean predicate) {
        DataExpression expr = (DataExpression)this.getExpression();
        this.source = expr.getSource();
        this.key = expr.getKey();
        if (this.source == DataSource.Content) {
            this.index = Integer.parseInt(this.key);
        }
    }

    protected Object getDataValue(Trace trace, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        if (this.source == DataSource.Content) {
            return values[this.index];
        }
        if (this.source == DataSource.Header) {
            return headers.get(this.key);
        }
        return null;
    }
}

