/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hawkular.apm.api.internal.actions;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import shaded.org.hawkular.apm.api.internal.actions.ProcessorActionHandler;
import shaded.org.hawkular.apm.api.logging.Logger;
import shaded.org.hawkular.apm.api.model.Property;
import shaded.org.hawkular.apm.api.model.Severity;
import shaded.org.hawkular.apm.api.model.config.Direction;
import shaded.org.hawkular.apm.api.model.config.btxn.EvaluateURIAction;
import shaded.org.hawkular.apm.api.model.config.btxn.Processor;
import shaded.org.hawkular.apm.api.model.config.btxn.ProcessorAction;
import shaded.org.hawkular.apm.api.model.trace.Issue;
import shaded.org.hawkular.apm.api.model.trace.Node;
import shaded.org.hawkular.apm.api.model.trace.ProcessorIssue;
import shaded.org.hawkular.apm.api.model.trace.Trace;
import shaded.org.hawkular.apm.api.utils.NodeUtil;

public class EvaluateURIActionHandler
extends ProcessorActionHandler {
    private static final Logger log = Logger.getLogger(EvaluateURIActionHandler.class.getName());
    public static final String TEMPLATE_MUST_BE_SPECIFIED = "Template must be specified";
    private String pathTemplate;
    private List<String> queryParameters = new ArrayList<String>();

    public EvaluateURIActionHandler(ProcessorAction action) {
        super(action);
        this.pathTemplate = ((EvaluateURIAction)this.getAction()).getTemplate();
        if (this.pathTemplate != null && this.pathTemplate.indexOf(63) != -1) {
            int index = this.pathTemplate.indexOf(63);
            String queryString = this.pathTemplate.substring(index + 1);
            this.pathTemplate = this.pathTemplate.substring(0, index);
            StringTokenizer st = new StringTokenizer(queryString, "&");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.charAt(0) == '{' && token.charAt(token.length() - 1) == '}') {
                    this.queryParameters.add(token.substring(1, token.length() - 1));
                    continue;
                }
                log.severe("Expecting query parameter template, e.g. {name}, but got '" + token + "'");
            }
        }
    }

    @Override
    public void init(Processor processor) {
        super.init(processor);
        EvaluateURIAction action = (EvaluateURIAction)this.getAction();
        if (action.getTemplate() == null || action.getTemplate().trim().isEmpty()) {
            ProcessorIssue pi = new ProcessorIssue();
            pi.setProcessor(processor.getDescription());
            pi.setAction(this.getAction().getDescription());
            pi.setField("template");
            pi.setSeverity(Severity.Error);
            pi.setDescription(TEMPLATE_MUST_BE_SPECIFIED);
            if (this.getIssues() == null) {
                this.setIssues(new ArrayList<Issue>());
            }
            this.getIssues().add(0, pi);
        }
    }

    @Override
    public boolean process(Trace trace, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        if (super.process(trace, node, direction, headers, values) && node.getUri() != null && this.pathTemplate != null) {
            StringTokenizer uriTokens = new StringTokenizer(node.getUri(), "/");
            StringTokenizer templateTokens = new StringTokenizer(this.pathTemplate, "/");
            if (uriTokens.countTokens() == templateTokens.countTokens()) {
                HashSet<Property> props = null;
                while (uriTokens.hasMoreTokens()) {
                    String uriToken = uriTokens.nextToken();
                    String templateToken = templateTokens.nextToken();
                    if (templateToken.charAt(0) == '{' && templateToken.charAt(templateToken.length() - 1) == '}') {
                        String name = templateToken.substring(1, templateToken.length() - 1);
                        if (props == null) {
                            props = new HashSet<Property>();
                        }
                        try {
                            props.add(new Property(name, URLDecoder.decode(uriToken, "UTF-8")));
                        }
                        catch (UnsupportedEncodingException e) {
                            if (!log.isLoggable(Logger.Level.FINEST)) continue;
                            log.finest("Failed to decode value '" + uriToken + "': " + e);
                        }
                        continue;
                    }
                    if (uriToken.equals(templateToken)) continue;
                    return false;
                }
                boolean processed = false;
                if (props != null) {
                    node.getProperties().addAll(props);
                    NodeUtil.rewriteURI(node, this.pathTemplate);
                    processed = true;
                }
                if (!this.queryParameters.isEmpty() && this.processQueryParameters(trace, node)) {
                    processed = true;
                }
                return processed;
            }
        }
        return false;
    }

    protected boolean processQueryParameters(Trace trace, Node node) {
        boolean ret = false;
        Set<Property> queryString = node.getProperties("http.query");
        if (!queryString.isEmpty()) {
            StringTokenizer st = new StringTokenizer(queryString.iterator().next().getValue(), "&");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                String[] namevalue = token.split("=");
                if (namevalue.length == 2) {
                    if (this.queryParameters.contains(namevalue[0])) {
                        try {
                            node.getProperties().add(new Property(namevalue[0], URLDecoder.decode(namevalue[1], "UTF-8")));
                            ret = true;
                        }
                        catch (UnsupportedEncodingException e) {
                            if (!log.isLoggable(Logger.Level.FINEST)) continue;
                            log.finest("Failed to decode value '" + namevalue[1] + "': " + e);
                        }
                        continue;
                    }
                    if (!log.isLoggable(Logger.Level.FINEST)) continue;
                    log.finest("Ignoring query parameter '" + namevalue[0] + "'");
                    continue;
                }
                if (!log.isLoggable(Logger.Level.FINEST)) continue;
                log.finest("Query string part does not include name/value pair: " + token);
            }
        }
        return ret;
    }
}

