/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hawkular.apm.api.internal.actions.helpers;

import shaded.com.fasterxml.jackson.core.JsonProcessingException;
import shaded.com.fasterxml.jackson.databind.ObjectMapper;
import shaded.com.jayway.jsonpath.JsonPath;
import shaded.com.jayway.jsonpath.Predicate;
import shaded.net.minidev.json.JSONArray;
import shaded.org.hawkular.apm.api.logging.Logger;

public class JSON {
    private static final Logger log = Logger.getLogger(JSON.class.getName());
    private static ObjectMapper mapper = new ObjectMapper();

    public static String serialize(Object data) {
        String ret;
        block8: {
            ret = null;
            if (data != null) {
                if (data.getClass() == String.class) {
                    ret = (String)data;
                } else if (data instanceof byte[]) {
                    ret = new String((byte[])data);
                } else {
                    try {
                        ret = mapper.writeValueAsString(data);
                    }
                    catch (JsonProcessingException e) {
                        if (!log.isLoggable(Logger.Level.FINEST)) break block8;
                        log.log(Logger.Level.FINEST, "Failed to serialize object into json", e);
                    }
                }
            }
        }
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Serialized '" + data + "' to json: " + ret);
        }
        return ret;
    }

    public static boolean predicate(String jsonpath, Object data) {
        Object result;
        if (jsonpath == null || jsonpath.trim().isEmpty()) {
            return false;
        }
        String json = JSON.serialize(data);
        if (json != null && (result = JsonPath.parse(json).read(jsonpath, new Predicate[0])) != null) {
            if (result.getClass() == Boolean.class) {
                return (Boolean)result;
            }
            if (result.getClass() == String.class) {
                return Boolean.valueOf((String)result);
            }
            if (result.getClass() == JSONArray.class) {
                return !((JSONArray)result).isEmpty();
            }
        }
        return false;
    }

    public static String evaluate(String jsonpath, Object data) {
        Object result;
        String json = JSON.serialize(data);
        if (jsonpath == null || jsonpath.trim().isEmpty()) {
            return json;
        }
        if (json != null && (result = JsonPath.parse(json).read(jsonpath, new Predicate[0])) != null) {
            if (result.getClass() == JSONArray.class) {
                JSONArray arr = (JSONArray)result;
                if (arr.isEmpty()) {
                    result = null;
                } else if (arr.size() == 1) {
                    result = arr.get(0);
                }
            }
            return JSON.serialize(result);
        }
        return null;
    }
}

