/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.mvel2;

import java.util.Map;
import shaded.org.mvel2.Macro;
import shaded.org.mvel2.PreProcessor;
import shaded.org.mvel2.compiler.AbstractParser;
import shaded.org.mvel2.util.ParseTools;
import shaded.org.mvel2.util.StringAppender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroProcessor
extends AbstractParser
implements PreProcessor {
    private Map<String, Macro> macros;

    public MacroProcessor() {
    }

    public MacroProcessor(Map<String, Macro> macros) {
        this.macros = macros;
    }

    @Override
    public char[] parse(char[] input) {
        this.setExpression(input);
        StringAppender appender = new StringAppender();
        boolean macroArmed = true;
        while (this.cursor < this.length) {
            int start = this.cursor;
            while (this.cursor < this.length && ParseTools.isIdentifierPart(this.expr[this.cursor])) {
                ++this.cursor;
            }
            if (this.cursor > start) {
                String token = new String(this.expr, start, this.cursor - start);
                if (this.macros.containsKey(token) && macroArmed) {
                    appender.append(this.macros.get(token).doMacro());
                } else {
                    appender.append(token);
                }
            }
            if (this.cursor < this.length) {
                switch (this.expr[this.cursor]) {
                    case '\\': {
                        ++this.cursor;
                        break;
                    }
                    case '/': {
                        start = this.cursor;
                        if (this.cursor + 1 != this.length) {
                            switch (this.expr[this.cursor + 1]) {
                                case '/': {
                                    while (this.cursor != this.length && this.expr[this.cursor] != '\n') {
                                        ++this.cursor;
                                    }
                                    break;
                                }
                                case '*': {
                                    int len = this.length - 1;
                                    while (this.cursor != len && (this.expr[this.cursor] != '*' || this.expr[this.cursor + 1] != '/')) {
                                        ++this.cursor;
                                    }
                                    this.cursor += 2;
                                }
                            }
                        }
                        if (this.cursor < this.length) {
                            ++this.cursor;
                        }
                        appender.append(new String(this.expr, start, this.cursor - start));
                        if (this.cursor >= this.length) break;
                        --this.cursor;
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        start = this.cursor;
                        this.cursor = ParseTools.captureStringLiteral(this.expr[this.cursor], this.expr, this.cursor, this.length);
                        appender.append(new String(this.expr, start, this.cursor - start));
                        if (this.cursor >= this.length) break;
                        if (ParseTools.isIdentifierPart(this.expr[this.cursor])) {
                            --this.cursor;
                        }
                    }
                    default: {
                        switch (this.expr[this.cursor]) {
                            case '.': {
                                macroArmed = false;
                                break;
                            }
                            case '(': 
                            case ';': 
                            case '{': {
                                macroArmed = true;
                            }
                        }
                        appender.append(this.expr[this.cursor]);
                    }
                }
            }
            ++this.cursor;
        }
        return appender.toChars();
    }

    @Override
    public String parse(String input) {
        return new String(this.parse(input.toCharArray()));
    }

    public Map<String, Macro> getMacros() {
        return this.macros;
    }

    public void setMacros(Map<String, Macro> macros) {
        this.macros = macros;
    }

    public void captureToWhitespace() {
        while (this.cursor < this.length && !ParseTools.isWhitespace(this.expr[this.cursor])) {
            ++this.cursor;
        }
    }
}

