/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.mvel2.ast;

import java.util.HashMap;
import shaded.org.mvel2.CompileException;
import shaded.org.mvel2.MVEL;
import shaded.org.mvel2.ParserContext;
import shaded.org.mvel2.ast.BlockNode;
import shaded.org.mvel2.ast.NestedStatement;
import shaded.org.mvel2.compiler.ExecutableStatement;
import shaded.org.mvel2.integration.VariableResolverFactory;
import shaded.org.mvel2.integration.impl.MapVariableResolverFactory;
import shaded.org.mvel2.util.CompilerTools;
import shaded.org.mvel2.util.ParseTools;

public class IfNode
extends BlockNode
implements NestedStatement {
    protected ExecutableStatement condition;
    protected ExecutableStatement nestedStatement;
    protected IfNode elseIf;
    protected ExecutableStatement elseBlock;
    protected boolean idxAlloc = false;

    public IfNode(char[] expr, int start, int offset, int blockStart, int blockOffset, int fields, ParserContext pCtx) {
        super(pCtx);
        this.expr = expr;
        if (expr == null || offset == 0) {
            throw new CompileException("statement expected", expr, start);
        }
        this.start = start;
        this.offset = offset;
        this.blockStart = blockStart;
        this.blockOffset = blockOffset;
        boolean bl = this.idxAlloc = pCtx != null && pCtx.isIndexAllocation();
        if ((fields & 0x10) != 0) {
            this.condition = (ExecutableStatement)ParseTools.subCompileExpression(expr, start, offset, pCtx);
            CompilerTools.expectType(pCtx, this.condition, Boolean.class, true);
            if (pCtx != null) {
                pCtx.pushVariableScope();
            }
            this.nestedStatement = (ExecutableStatement)ParseTools.subCompileExpression(expr, blockStart, blockOffset, pCtx);
            if (pCtx != null) {
                pCtx.popVariableScope();
            }
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (((Boolean)this.condition.getValue(ctx, thisValue, factory)).booleanValue()) {
            return this.nestedStatement.getValue(ctx, thisValue, this.idxAlloc ? factory : new MapVariableResolverFactory(new HashMap<String, Object>(0), factory));
        }
        if (this.elseIf != null) {
            return this.elseIf.getReducedValueAccelerated(ctx, thisValue, this.idxAlloc ? factory : new MapVariableResolverFactory(new HashMap<String, Object>(0), factory));
        }
        if (this.elseBlock != null) {
            return this.elseBlock.getValue(ctx, thisValue, this.idxAlloc ? factory : new MapVariableResolverFactory(new HashMap<String, Object>(0), factory));
        }
        return null;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (((Boolean)MVEL.eval(this.expr, this.start, this.offset, ctx, factory)).booleanValue()) {
            return MVEL.eval(this.expr, this.blockStart, this.blockOffset, ctx, new MapVariableResolverFactory(new HashMap<String, Object>(0), factory));
        }
        if (this.elseIf != null) {
            return this.elseIf.getReducedValue(ctx, thisValue, new MapVariableResolverFactory(new HashMap<String, Object>(0), factory));
        }
        if (this.elseBlock != null) {
            return this.elseBlock.getValue(ctx, thisValue, new MapVariableResolverFactory(new HashMap<String, Object>(0), factory));
        }
        return null;
    }

    public ExecutableStatement getNestedStatement() {
        return this.nestedStatement;
    }

    public IfNode setElseIf(IfNode elseIf) {
        this.elseIf = elseIf;
        return this.elseIf;
    }

    public ExecutableStatement getElseBlock() {
        return this.elseBlock;
    }

    public IfNode setElseBlock(char[] block, int cursor, int offset, ParserContext ctx) {
        this.elseBlock = (ExecutableStatement)ParseTools.subCompileExpression(block, cursor, offset, ctx);
        return this;
    }

    public String toString() {
        return new String(this.expr, this.start, this.offset);
    }
}

