/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.jayway.jsonpath.internal.path;

import shaded.com.jayway.jsonpath.PathNotFoundException;
import shaded.com.jayway.jsonpath.internal.PathRef;
import shaded.com.jayway.jsonpath.internal.path.ArrayIndexOperation;
import shaded.com.jayway.jsonpath.internal.path.ArraySliceOperation;
import shaded.com.jayway.jsonpath.internal.path.EvaluationContextImpl;
import shaded.com.jayway.jsonpath.internal.path.PathToken;
import shaded.org.slf4j.Logger;
import shaded.org.slf4j.LoggerFactory;

public class ArrayPathToken
extends PathToken {
    private static final Logger logger = LoggerFactory.getLogger(ArrayPathToken.class);
    private final ArraySliceOperation arraySliceOperation;
    private final ArrayIndexOperation arrayIndexOperation;

    ArrayPathToken(ArraySliceOperation arraySliceOperation) {
        this.arraySliceOperation = arraySliceOperation;
        this.arrayIndexOperation = null;
    }

    ArrayPathToken(ArrayIndexOperation arrayIndexOperation) {
        this.arrayIndexOperation = arrayIndexOperation;
        this.arraySliceOperation = null;
    }

    @Override
    public void evaluate(String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx) {
        if (!this.checkArrayModel(currentPath, model, ctx)) {
            return;
        }
        if (this.arraySliceOperation != null) {
            this.evaluateSliceOperation(currentPath, parent, model, ctx);
        } else {
            this.evaluateIndexOperation(currentPath, parent, model, ctx);
        }
    }

    public void evaluateIndexOperation(String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx) {
        if (!this.checkArrayModel(currentPath, model, ctx)) {
            return;
        }
        if (this.arrayIndexOperation.isSingleIndexOperation()) {
            this.handleArrayIndex(this.arrayIndexOperation.indexes().get(0), currentPath, model, ctx);
        } else {
            for (Integer index : this.arrayIndexOperation.indexes()) {
                this.handleArrayIndex(index, currentPath, model, ctx);
            }
        }
    }

    public void evaluateSliceOperation(String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx) {
        if (!this.checkArrayModel(currentPath, model, ctx)) {
            return;
        }
        switch (this.arraySliceOperation.operation()) {
            case SLICE_FROM: {
                this.sliceFrom(this.arraySliceOperation, currentPath, parent, model, ctx);
                break;
            }
            case SLICE_BETWEEN: {
                this.sliceBetween(this.arraySliceOperation, currentPath, parent, model, ctx);
                break;
            }
            case SLICE_TO: {
                this.sliceTo(this.arraySliceOperation, currentPath, parent, model, ctx);
            }
        }
    }

    public void sliceFrom(ArraySliceOperation operation, String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx) {
        int length = ctx.jsonProvider().length(model);
        int from = operation.from();
        if (from < 0) {
            from = length + from;
        }
        from = Math.max(0, from);
        logger.debug("Slice from index on array with length: {}. From index: {} to: {}. Input: {}", length, from, length - 1, this.toString());
        if (length == 0 || from >= length) {
            return;
        }
        for (int i = from; i < length; ++i) {
            this.handleArrayIndex(i, currentPath, model, ctx);
        }
    }

    public void sliceBetween(ArraySliceOperation operation, String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx) {
        int length = ctx.jsonProvider().length(model);
        int from = operation.from();
        int to = operation.to();
        if (from >= (to = Math.min(length, to)) || length == 0) {
            return;
        }
        logger.debug("Slice between indexes on array with length: {}. From index: {} to: {}. Input: {}", length, from, to, this.toString());
        for (int i = from; i < to; ++i) {
            this.handleArrayIndex(i, currentPath, model, ctx);
        }
    }

    public void sliceTo(ArraySliceOperation operation, String currentPath, PathRef parent, Object model, EvaluationContextImpl ctx) {
        int length = ctx.jsonProvider().length(model);
        if (length == 0) {
            return;
        }
        int to = operation.to();
        if (to < 0) {
            to = length + to;
        }
        to = Math.min(length, to);
        logger.debug("Slice to index on array with length: {}. From index: 0 to: {}. Input: {}", length, to, this.toString());
        for (int i = 0; i < to; ++i) {
            this.handleArrayIndex(i, currentPath, model, ctx);
        }
    }

    @Override
    public String getPathFragment() {
        if (this.arrayIndexOperation != null) {
            return this.arrayIndexOperation.toString();
        }
        return this.arraySliceOperation.toString();
    }

    @Override
    public boolean isTokenDefinite() {
        if (this.arrayIndexOperation != null) {
            return this.arrayIndexOperation.isSingleIndexOperation();
        }
        return false;
    }

    protected boolean checkArrayModel(String currentPath, Object model, EvaluationContextImpl ctx) {
        if (model == null) {
            if (!this.isUpstreamDefinite()) {
                return false;
            }
            throw new PathNotFoundException("The path " + currentPath + " is null");
        }
        if (!ctx.jsonProvider().isArray(model)) {
            if (!this.isUpstreamDefinite()) {
                return false;
            }
            throw new PathNotFoundException(String.format("Filter: %s can only be applied to arrays. Current context is: %s", this.toString(), model));
        }
        return true;
    }
}

