/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hawkular.apm.api.internal.actions;

import java.util.ArrayList;
import java.util.Map;
import shaded.org.hawkular.apm.api.internal.actions.ExpressionBasedActionHandler;
import shaded.org.hawkular.apm.api.logging.Logger;
import shaded.org.hawkular.apm.api.model.Severity;
import shaded.org.hawkular.apm.api.model.config.Direction;
import shaded.org.hawkular.apm.api.model.config.txn.AddContentAction;
import shaded.org.hawkular.apm.api.model.config.txn.Processor;
import shaded.org.hawkular.apm.api.model.config.txn.ProcessorAction;
import shaded.org.hawkular.apm.api.model.trace.InteractionNode;
import shaded.org.hawkular.apm.api.model.trace.Issue;
import shaded.org.hawkular.apm.api.model.trace.Message;
import shaded.org.hawkular.apm.api.model.trace.Node;
import shaded.org.hawkular.apm.api.model.trace.ProcessorIssue;
import shaded.org.hawkular.apm.api.model.trace.Trace;

public class AddContentActionHandler
extends ExpressionBasedActionHandler {
    private static final Logger log = Logger.getLogger(AddContentActionHandler.class.getName());
    private static final String NAME_MUST_BE_SPECIFIED = "Name must be specified";

    public AddContentActionHandler(ProcessorAction action) {
        super(action);
    }

    @Override
    public void init(Processor processor) {
        super.init(processor);
        AddContentAction action = (AddContentAction)this.getAction();
        if (action.getName() == null || action.getName().trim().isEmpty()) {
            ProcessorIssue pi = new ProcessorIssue();
            pi.setProcessor(processor.getDescription());
            pi.setAction(this.getAction().getDescription());
            pi.setField("name");
            pi.setSeverity(Severity.Error);
            pi.setDescription(NAME_MUST_BE_SPECIFIED);
            if (this.getIssues() == null) {
                this.setIssues(new ArrayList<Issue>());
            }
            this.getIssues().add(0, pi);
        }
    }

    @Override
    public boolean process(Trace trace, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        String value;
        if (super.process(trace, node, direction, headers, values) && (value = this.getValue(trace, node, direction, headers, values)) != null) {
            if (node.interactionNode()) {
                if (direction == Direction.In) {
                    if (((InteractionNode)node).getIn() == null) {
                        ((InteractionNode)node).setIn(new Message());
                    }
                    ((InteractionNode)node).getIn().addContent(((AddContentAction)this.getAction()).getName(), ((AddContentAction)this.getAction()).getType(), value);
                } else {
                    if (((InteractionNode)node).getOut() == null) {
                        ((InteractionNode)node).setOut(new Message());
                    }
                    ((InteractionNode)node).getOut().addContent(((AddContentAction)this.getAction()).getName(), ((AddContentAction)this.getAction()).getType(), value);
                }
                return true;
            }
            log.warning("Attempt to add content to a non-interaction based node type '" + (Object)((Object)node.getType()) + "'");
        }
        return false;
    }
}

