/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.adapter.LocalScopeMethodVisitor;
import org.jboss.byteman.agent.adapter.RuleTriggerAdapter;
import org.jboss.byteman.agent.adapter.RuleTriggerMethodAdapter;
import org.jboss.byteman.objectweb.asm.ClassVisitor;
import org.jboss.byteman.objectweb.asm.MethodVisitor;

public class VariableAccessTriggerAdapter
extends RuleTriggerAdapter {
    private String varName;
    private int flags;
    private int count;
    private boolean whenComplete;

    public VariableAccessTriggerAdapter(ClassVisitor cv, TransformContext transformContext, String varName, int flags, int count, boolean whenComplete) {
        super(cv, transformContext);
        this.varName = varName;
        this.flags = flags;
        this.count = count;
        this.whenComplete = whenComplete;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.injectIntoMethod(name, desc)) {
            if (name.equals("<init>")) {
                return new VariableAccessTriggerConstructorAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
            }
            return new VariableAccessTriggerMethodAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
        }
        return mv;
    }

    private class VariableAccessTriggerConstructorAdapter
    extends VariableAccessTriggerMethodAdapter {
        VariableAccessTriggerConstructorAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor, signature, exceptions);
            this.latched = true;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            if (this.latched && VariableAccessTriggerAdapter.this.isSuperOrSiblingConstructorCall(opcode, owner, name)) {
                this.latched = false;
            }
        }
    }

    private class VariableAccessTriggerMethodAdapter
    extends RuleTriggerMethodAdapter
    implements LocalScopeMethodVisitor {
        protected boolean latched;
        private int index;
        private int visitedCount;

        VariableAccessTriggerMethodAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor, signature, exceptions);
            this.index = -1;
            this.visitedCount = 0;
            this.latched = false;
        }

        @Override
        public void visitLocalScopeStart(String name, String desc, String signature, int stackSlot, int startOffset) {
            if (name.equals(VariableAccessTriggerAdapter.this.varName)) {
                this.index = stackSlot;
                if (startOffset > 0 && (VariableAccessTriggerAdapter.this.count == 0 || this.visitedCount < VariableAccessTriggerAdapter.this.count) && (VariableAccessTriggerAdapter.this.flags & 2) != 0) {
                    ++this.visitedCount;
                    if (!(this.latched || VariableAccessTriggerAdapter.this.count != 0 && this.visitedCount != VariableAccessTriggerAdapter.this.count)) {
                        this.injectTriggerPoint();
                    }
                }
            }
        }

        @Override
        public void visitLocalScopeEnd(String name, String desc, String signature, int stackSlot, int endOffset) {
            if (name.equals(VariableAccessTriggerAdapter.this.varName)) {
                this.index = -1;
            }
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
            if (this.inBytemanTrigger()) {
                super.visitVarInsn(opcode, var);
            } else {
                if (VariableAccessTriggerAdapter.this.whenComplete) {
                    super.visitVarInsn(opcode, var);
                }
                if (var == this.index && (VariableAccessTriggerAdapter.this.count == 0 || this.visitedCount < VariableAccessTriggerAdapter.this.count) && this.matchCall(opcode)) {
                    ++this.visitedCount;
                    if (!(this.latched || VariableAccessTriggerAdapter.this.count != 0 && this.visitedCount != VariableAccessTriggerAdapter.this.count)) {
                        this.injectTriggerPoint();
                    }
                }
                if (!VariableAccessTriggerAdapter.this.whenComplete) {
                    super.visitVarInsn(opcode, var);
                }
            }
        }

        @Override
        public void visitIincInsn(int var, int increment) {
            boolean ruleIsAfterWrite;
            boolean bl = ruleIsAfterWrite = (VariableAccessTriggerAdapter.this.flags & 2) != 0 && VariableAccessTriggerAdapter.this.whenComplete;
            if (ruleIsAfterWrite) {
                super.visitIincInsn(var, increment);
            }
            if (var == this.index && (VariableAccessTriggerAdapter.this.count == 0 || this.visitedCount < VariableAccessTriggerAdapter.this.count)) {
                ++this.visitedCount;
                if (!(this.latched || VariableAccessTriggerAdapter.this.count != 0 && this.visitedCount != VariableAccessTriggerAdapter.this.count)) {
                    this.injectTriggerPoint();
                }
            }
            if (!ruleIsAfterWrite) {
                super.visitIincInsn(var, increment);
            }
        }

        private boolean matchCall(int opcode) {
            if (opcode < 54) {
                return (VariableAccessTriggerAdapter.this.flags & 1) != 0;
            }
            return (VariableAccessTriggerAdapter.this.flags & 2) != 0;
        }
    }
}

