/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.check;

import java.util.ArrayList;
import java.util.List;

public class RuleCheckResult {
    private int errorCount = 0;
    private int warningCount = 0;
    private int parseErrorCount = 0;
    private int typeWarningCount = 0;
    private int typeErrorCount = 0;
    private List<String> errorMessages = new ArrayList<String>();
    private List<String> warningMessages = new ArrayList<String>();
    private List<String> parseErrorMessages = new ArrayList<String>();
    private List<String> typeWarningMessages = new ArrayList<String>();
    private List<String> typeErrorMessages = new ArrayList<String>();
    private List<String> infoMessages = new ArrayList<String>();

    public void addError(String msg) {
        ++this.errorCount;
        this.errorMessages.add(msg);
    }

    public void addWarning(String msg) {
        ++this.warningCount;
        this.warningMessages.add(msg);
    }

    public void addParseError(String msg) {
        ++this.parseErrorCount;
        this.parseErrorMessages.add(msg);
    }

    public void addTypeWarning(String msg) {
        ++this.typeWarningCount;
        this.typeWarningMessages.add(msg);
    }

    public void addTypeError(String msg) {
        ++this.typeErrorCount;
        this.typeErrorMessages.add(msg);
    }

    public void addInfo(String msg) {
        this.infoMessages.add(msg);
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public int getParseErrorCount() {
        return this.parseErrorCount;
    }

    public int getTypeWarningCount() {
        return this.typeWarningCount;
    }

    public int getTypeErrorCount() {
        return this.typeErrorCount;
    }

    public boolean hasError() {
        return this.errorCount != 0 || this.parseErrorCount != 0 || this.typeErrorCount != 0;
    }

    public boolean hasWarning() {
        return this.warningCount != 0 || this.typeWarningCount != 0;
    }

    public boolean hasInfo() {
        return !this.infoMessages.isEmpty();
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public List<String> getTypeErrorMessages() {
        return this.typeErrorMessages;
    }

    public List<String> getParseErrorMessages() {
        return this.parseErrorMessages;
    }

    public List<String> getWarningMessages() {
        return this.warningMessages;
    }

    public List<String> getTypeWarningMessages() {
        return this.typeWarningMessages;
    }

    public List<String> getInfoMessages() {
        return this.infoMessages;
    }
}

