/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hawkular.apm.api.model.trace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import shaded.com.fasterxml.jackson.annotation.JsonInclude;
import shaded.org.hawkular.apm.api.model.Property;
import shaded.org.hawkular.apm.api.model.trace.CorrelationIdentifier;
import shaded.org.hawkular.apm.api.model.trace.Node;

public class Trace {
    @JsonInclude
    private String traceId;
    @JsonInclude
    private String fragmentId;
    @JsonInclude
    private long timestamp;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String transaction;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String hostName;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String hostAddress;
    @JsonInclude
    private List<Node> nodes = new ArrayList<Node>();

    public String getTraceId() {
        return this.traceId;
    }

    public Trace setTraceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    public String getFragmentId() {
        return this.fragmentId;
    }

    public Trace setFragmentId(String fragmentId) {
        this.fragmentId = fragmentId;
        return this;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Trace setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String getTransaction() {
        return this.transaction;
    }

    public Trace setTransaction(String name) {
        this.transaction = name;
        return this;
    }

    public String getHostName() {
        return this.hostName;
    }

    public Trace setHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public Trace setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
        return this;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public Trace setNodes(List<Node> nodes) {
        this.nodes = nodes;
        return this;
    }

    public Set<Property> allProperties() {
        HashSet<Property> properties = new HashSet<Property>();
        for (Node n : this.nodes) {
            n.includeProperties(properties);
        }
        return Collections.unmodifiableSet(properties);
    }

    public boolean hasProperty(String name) {
        for (Property property : this.allProperties()) {
            if (!property.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Set<Property> getProperties(String name) {
        HashSet<Property> ret = new HashSet<Property>();
        for (Property property : this.allProperties()) {
            if (!property.getName().equals(name)) continue;
            ret.add(property);
        }
        return ret;
    }

    public boolean initialFragment() {
        return this.getTraceId().equals(this.getFragmentId());
    }

    public long endTime() {
        return this.getTimestamp() + this.calculateDuration();
    }

    public long calculateDuration() {
        if (!this.nodes.isEmpty()) {
            long endTime = 0L;
            for (int i = 0; i < this.getNodes().size(); ++i) {
                Node node = this.getNodes().get(i);
                long nodeEndTime = node.overallEndTime();
                if (nodeEndTime <= endTime) continue;
                endTime = nodeEndTime;
            }
            return endTime - this.getNodes().get(0).getTimestamp();
        }
        return 0L;
    }

    public Set<Node> getCorrelatedNodes(CorrelationIdentifier cid) {
        HashSet<Node> ret = new HashSet<Node>();
        for (Node n : this.getNodes()) {
            n.findCorrelatedNodes(cid, ret);
        }
        return ret;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.transaction == null ? 0 : this.transaction.hashCode());
        result = 31 * result + (this.fragmentId == null ? 0 : this.fragmentId.hashCode());
        result = 31 * result + (this.hostAddress == null ? 0 : this.hostAddress.hashCode());
        result = 31 * result + (this.hostName == null ? 0 : this.hostName.hashCode());
        result = 31 * result + (this.nodes == null ? 0 : this.nodes.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.traceId == null ? 0 : this.traceId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Trace other = (Trace)obj;
        if (this.transaction == null ? other.transaction != null : !this.transaction.equals(other.transaction)) {
            return false;
        }
        if (this.fragmentId == null ? other.fragmentId != null : !this.fragmentId.equals(other.fragmentId)) {
            return false;
        }
        if (this.hostAddress == null ? other.hostAddress != null : !this.hostAddress.equals(other.hostAddress)) {
            return false;
        }
        if (this.hostName == null ? other.hostName != null : !this.hostName.equals(other.hostName)) {
            return false;
        }
        if (this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes)) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        return !(this.traceId == null ? other.traceId != null : !this.traceId.equals(other.traceId));
    }

    public String toString() {
        return "Trace [traceId=" + this.traceId + ", fragmentId=" + this.fragmentId + ", timestamp=" + this.timestamp + ", transaction=" + this.transaction + ", hostName=" + this.hostName + ", hostAddress=" + this.hostAddress + ", nodes=" + this.nodes + "]";
    }
}

