/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hawkular.apm.api.model.trace;

import io.swagger.annotations.ApiModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import shaded.com.fasterxml.jackson.annotation.JsonInclude;
import shaded.com.fasterxml.jackson.annotation.JsonSubTypes;
import shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shaded.org.hawkular.apm.api.model.Property;
import shaded.org.hawkular.apm.api.model.trace.ContainerNode;
import shaded.org.hawkular.apm.api.model.trace.CorrelationIdentifier;
import shaded.org.hawkular.apm.api.model.trace.NodeType;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ContainerNode.class)})
@ApiModel(subTypes={ContainerNode.class}, discriminator="type")
public abstract class Node {
    @JsonInclude
    private NodeType type;
    @JsonInclude
    private String uri;
    @JsonInclude
    private String operation;
    @JsonInclude
    private long timestamp = 0L;
    @JsonInclude
    private long duration = 0L;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Set<Property> properties = new HashSet<Property>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<CorrelationIdentifier> correlationIds = new ArrayList<CorrelationIdentifier>();

    public Node(NodeType type) {
        this.type = type;
    }

    public Node(NodeType type, String uri) {
        this(type);
        this.uri = uri;
    }

    public boolean containerNode() {
        return false;
    }

    public boolean interactionNode() {
        return false;
    }

    public NodeType getType() {
        return this.type;
    }

    public Node setType(NodeType type) {
        this.type = type;
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public Node setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Node setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public long getDuration() {
        return this.duration;
    }

    public Node setDuration(long duration) {
        this.duration = duration;
        return this;
    }

    public Set<Property> getProperties() {
        return this.properties;
    }

    public Node setProperties(Set<Property> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Null value not permitted");
        }
        this.properties = properties;
        return this;
    }

    public boolean hasProperty(String name) {
        return this.properties.stream().filter(p -> p.getName().equals(name)).findFirst().isPresent();
    }

    public Set<Property> getProperties(String name) {
        return this.properties.stream().filter(property -> property.getName().equals(name)).collect(Collectors.toSet());
    }

    protected void includeProperties(Set<Property> allProperties) {
        allProperties.addAll(this.properties);
    }

    public List<CorrelationIdentifier> getCorrelationIds() {
        return this.correlationIds;
    }

    public Node setCorrelationIds(List<CorrelationIdentifier> correlationIds) {
        this.correlationIds = correlationIds;
        return this;
    }

    public Node addInteractionCorrelationId(String id) {
        this.correlationIds.add(new CorrelationIdentifier(CorrelationIdentifier.Scope.Interaction, id));
        return this;
    }

    public Node addControlFlowCorrelationId(String id) {
        this.correlationIds.add(new CorrelationIdentifier(CorrelationIdentifier.Scope.ControlFlow, id));
        return this;
    }

    public Node addCausedByCorrelationId(String id) {
        this.correlationIds.add(new CorrelationIdentifier(CorrelationIdentifier.Scope.CausedBy, id));
        return this;
    }

    public List<CorrelationIdentifier> findCorrelationIds(CorrelationIdentifier.Scope ... scope) {
        ArrayList<CorrelationIdentifier> ret = null;
        for (int i = 0; i < this.correlationIds.size(); ++i) {
            CorrelationIdentifier cid = this.correlationIds.get(i);
            for (int j = 0; j < scope.length; ++j) {
                if (cid.getScope() != scope[j]) continue;
                if (ret == null) {
                    ret = new ArrayList<CorrelationIdentifier>();
                }
                if (ret.contains(cid)) continue;
                ret.add(cid);
            }
        }
        return ret == null ? Collections.emptyList() : ret;
    }

    protected long endTime() {
        return this.timestamp + this.duration;
    }

    protected long completedTime() {
        return this.overallEndTime();
    }

    protected long completedDuration() {
        return this.overallEndTime() - this.timestamp;
    }

    protected long overallEndTime() {
        return this.endTime();
    }

    protected void findCorrelatedNodes(CorrelationIdentifier cid, Set<Node> nodes) {
        if (this.isCorrelated(cid)) {
            nodes.add(this);
        }
    }

    protected boolean isCorrelated(CorrelationIdentifier cid) {
        for (CorrelationIdentifier id : this.correlationIds) {
            if (!id.equals(cid)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.correlationIds == null ? 0 : this.correlationIds.hashCode());
        result = 31 * result + (int)(this.duration ^ this.duration >>> 32);
        result = 31 * result + (this.operation == null ? 0 : this.operation.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        if (this.timestamp != other.timestamp) {
            return false;
        }
        if (this.correlationIds == null ? other.correlationIds != null : !this.correlationIds.equals(other.correlationIds)) {
            return false;
        }
        if (this.duration != other.duration) {
            return false;
        }
        if (this.operation == null ? other.operation != null : !this.operation.equals(other.operation)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }
}

