/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.mvel2.conversion;

import java.util.HashMap;
import java.util.Map;
import shaded.org.mvel2.ConversionException;
import shaded.org.mvel2.ConversionHandler;
import shaded.org.mvel2.conversion.Converter;

public class ArrayCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>();

    public Object convertFrom(Object in) {
        if (!CNV.containsKey(in.getClass())) {
            throw new ConversionException("cannot convert type: " + in.getClass().getName() + " to: " + Boolean.class.getName());
        }
        return CNV.get(in.getClass()).convert(in);
    }

    public boolean canConvertFrom(Class cls) {
        return CNV.containsKey(cls);
    }

    static {
        CNV.put(String[].class, new Converter(){

            public Object convert(Object o) {
                Object[] old = (Object[])o;
                String[] n = new String[old.length];
                for (int i = 0; i < old.length; ++i) {
                    n[i] = String.valueOf(old[i]);
                }
                return n;
            }
        });
        CNV.put(Integer[].class, new Converter(){

            public Object convert(Object o) {
                Object[] old = (Object[])o;
                Integer[] n = new Integer[old.length];
                for (int i = 0; i < old.length; ++i) {
                    n[i] = Integer.parseInt(String.valueOf(old[i]));
                }
                return n;
            }
        });
        CNV.put(int[].class, new Converter(){

            public Object convert(Object o) {
                Object[] old = (Object[])o;
                int[] n = new int[old.length];
                for (int i = 0; i < old.length; ++i) {
                    n[i] = Integer.parseInt(String.valueOf(old[i]));
                }
                return n;
            }
        });
    }
}

